/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.utils;

import com.qingstor.sdk.config.EnvContext;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.model.RequestInputModel;
import com.qingstor.sdk.utils.Base64;
import com.qingstor.sdk.utils.QSLoggerUtil;
import com.qingstor.sdk.utils.QSParamInvokeUtil;
import com.qingstor.sdk.utils.QSStringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class QSSignatureUtil {
    private static Logger logger = QSLoggerUtil.setLoggerHanlder(QSSignatureUtil.class.getName());
    private static final String ENCODING = "UTF-8";
    private static final String ALGORITHM = "HmacSHA256";
    private static final String GMT_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    private static Map keysMap;

    public static String generateQSURL(Map<String, String> parameters, String requestUrl) throws QSException {
        parameters = QSParamInvokeUtil.serializeParams(parameters);
        StringBuilder sbStringToSign = new StringBuilder();
        Object[] sortedKeys = parameters.keySet().toArray(new String[0]);
        Arrays.sort(sortedKeys);
        int count = 0;
        try {
            for (Object key : sortedKeys) {
                if (count != 0) {
                    sbStringToSign.append("&");
                }
                sbStringToSign.append(QSStringUtil.percentEncode((String)key, ENCODING)).append("=").append(QSStringUtil.percentEncode((String)parameters.get(key), ENCODING));
                ++count;
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.SEVERE, e.getMessage());
            throw new QSException("generateQSURL error", e);
        }
        if (sbStringToSign.length() > 0) {
            if (requestUrl.indexOf("?") > 0) {
                return String.format("%s&%s", requestUrl, sbStringToSign.toString());
            }
            return String.format("%s?%s", requestUrl, sbStringToSign.toString());
        }
        return requestUrl;
    }

    public static String generateAuthorization(String accessKey, String secretKey, String method, String requestURI, Map<String, String> params, Map<String, String> headers) {
        String signature = QSSignatureUtil.generateSignature(secretKey, method, requestURI, params, headers);
        return String.format("QS %s:%s", accessKey, signature);
    }

    public static String generateAuthorization(String accessKey, String secretKey, String strToSign) {
        String signature = QSSignatureUtil.generateSignature(secretKey, strToSign);
        return String.format("QS %s:%s", accessKey, signature);
    }

    public static String generateSignature(String secretKey, String method, String requestURI, Map<String, String> params, Map<String, String> headers) {
        String signature = "";
        String strToSign = QSSignatureUtil.getStringToSignature(method, requestURI, params, headers);
        logger.log(Level.INFO, "== String to sign ==\n" + strToSign + "\n");
        signature = QSSignatureUtil.generateSignature(secretKey, strToSign);
        return signature;
    }

    public static String getStringToSignature(String method, String authPath, Map<String, String> params, Map<String, String> headers) {
        String SEPARATOR = "&";
        String strToSign = "";
        strToSign = strToSign + method.toUpperCase() + "\n";
        String contentMD5 = "";
        String contentType = "";
        if (headers != null) {
            if (headers.containsKey("Content-MD5")) {
                contentMD5 = headers.get("Content-MD5");
            }
            if (headers.containsKey("Content-Type")) {
                contentType = headers.get("Content-Type");
            }
        }
        strToSign = strToSign + contentMD5 + "\n";
        strToSign = strToSign + contentType;
        String dateStr = "";
        if (headers != null) {
            if (headers.containsKey("Date")) {
                dateStr = headers.get("Date");
            }
            if (headers.containsKey("Expires")) {
                dateStr = headers.get("Expires");
            }
        }
        strToSign = strToSign + "\n" + dateStr;
        if (headers != null) {
            Object[] sortedHeadersKeys = headers.keySet().toArray(new String[0]);
            Arrays.sort(sortedHeadersKeys);
            for (Object key : sortedHeadersKeys) {
                if (!((String)key).startsWith("x-qs-") && !((String)key).startsWith("X-QS-")) continue;
                strToSign = strToSign + String.format("\n%s:%s", ((String)key).toLowerCase(), headers.get(key));
            }
        }
        String canonicalized_query = "";
        if (params != null) {
            Object[] sortedParamsKeys = params.keySet().toArray(new String[0]);
            Arrays.sort(sortedParamsKeys);
            for (Object key : sortedParamsKeys) {
                if (!QSSignatureUtil.isSubKey((String)key)) continue;
                if (!canonicalized_query.isEmpty()) {
                    canonicalized_query = canonicalized_query + "&";
                }
                try {
                    canonicalized_query = canonicalized_query + (String)key;
                    String value = String.valueOf(params.get(key));
                    if (value.isEmpty()) continue;
                    canonicalized_query = canonicalized_query + "=" + value;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        String canonicalized_resource = authPath;
        if (!canonicalized_query.isEmpty()) {
            canonicalized_resource = canonicalized_resource + "?" + canonicalized_query;
        }
        strToSign = strToSign + String.format("\n%s", canonicalized_resource);
        logger.log(Level.INFO, "== String to sign ==\n" + strToSign + "\n");
        return strToSign;
    }

    public static String generateSignature(String secretKey, String strToSign) {
        byte[] signData = null;
        try {
            Mac mac = Mac.getInstance(ALGORITHM);
            mac.init(new SecretKeySpec(secretKey.getBytes(ENCODING), ALGORITHM));
            signData = mac.doFinal(strToSign.getBytes(ENCODING));
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalStateException e) {
            throw new RuntimeException(e);
        }
        return new String(Base64.encode(signData));
    }

    public static boolean isSubKey(String key) {
        if (keysMap == null) {
            keysMap = new HashMap(){
                {
                    this.put("acl", "acl");
                    this.put("cors", "cors");
                    this.put("delete", "delete");
                    this.put("mirror", "mirror");
                    this.put("part_number", "part_number");
                    this.put("policy", "policy");
                    this.put("stats", "stats");
                    this.put("upload_id", "upload_id");
                    this.put("response-expires", "response-expires");
                    this.put("response-cache-control", "response-cache-control");
                    this.put("response-content-type", "response-content-type");
                    this.put("response-content-language", "response-content-language");
                    this.put("response-content-encoding", "response-content-encoding");
                    this.put("response-content-disposition", "response-content-disposition");
                }
            };
        }
        return keysMap.containsKey(key);
    }

    public static String formatGmtDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(GMT_DATE_FORMAT, Locale.US);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        String dateStr = df.format(date);
        if (dateStr.indexOf("+") > 0) {
            return dateStr.substring(0, dateStr.indexOf("+"));
        }
        return dateStr;
    }

    public static String getObjectAuthRequestUrl(EnvContext envContext, String zone, String bucketName, String objectName, int expiresSecond) throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        try {
            objectName = QSStringUtil.asciiCharactersEncoding(objectName);
            context.put("RequestZone", zone);
            context.put("evnContext", envContext);
            context.put("OperationName", "GetObject");
            context.put("APIName", "GetObject");
            context.put("ServiceName", "QingStor");
            context.put("RequestMethod", "GET");
            context.put("RequestURI", "/<bucket-name>/<object-key>");
            context.put("bucketNameInput", bucketName);
            context.put("objectNameInput", objectName);
            long expiresTime = new Date().getTime() / 1000L + (long)expiresSecond;
            String expireAuth = QSSignatureUtil.getExpireAuth(context, expiresTime, new RequestInputModel());
            String serviceUrl = envContext.getRequestUrl();
            String storRequestUrl = serviceUrl.replace("://", "://%s." + zone + ".");
            if (objectName != null && objectName.indexOf("?") > 0) {
                return String.format(storRequestUrl + "/%s&access_key_id=%s&expires=%s&signature=%s", bucketName, objectName, envContext.getAccessKey(), expiresTime + "", expireAuth);
            }
            return String.format(storRequestUrl + "/%s?access_key_id=%s&expires=%s&signature=%s", bucketName, objectName, envContext.getAccessKey(), expiresTime + "", expireAuth);
        }
        catch (UnsupportedEncodingException e) {
            throw new QSException("Auth signature error", e);
        }
    }

    public static String getExpireAuth(Map context, long expiresSecond, RequestInputModel params) throws UnsupportedEncodingException {
        EnvContext envContext = (EnvContext)context.get("evnContext");
        Map paramsQuery = QSParamInvokeUtil.getRequestParams(params, "query");
        Map paramsHeaders = QSParamInvokeUtil.getRequestParams(params, "header");
        paramsHeaders.remove("Date");
        paramsHeaders.clear();
        paramsHeaders.put("Expires", expiresSecond + "");
        String method = (String)context.get("RequestMethod");
        String bucketName = (String)context.get("bucketNameInput");
        String requestPath = (String)context.get("RequestURI");
        requestPath = requestPath.replace("<bucket-name>", bucketName);
        if (context.containsKey("objectNameInput")) {
            requestPath = requestPath.replace("<object-key>", (String)context.get("objectNameInput"));
        }
        String authSign = QSSignatureUtil.generateSignature(envContext.getAccessSecret(), method, requestPath, paramsQuery, paramsHeaders);
        return URLEncoder.encode(authSign, ENCODING);
    }
}

