/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.utils;

import com.qingstor.sdk.annotation.ParamAnnotation;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.model.OutputModel;
import com.qingstor.sdk.request.ResponseCallBack;
import com.qingstor.sdk.utils.QSSignatureUtil;
import com.qingstor.sdk.utils.QSStringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QSParamInvokeUtil {
    public static Map getRequestParams(Object model, String paramType) {
        HashMap<String, String> retParametersMap = new HashMap<String, String>();
        if (model != null) {
            try {
                for (Class<?> tmpClass = model.getClass(); tmpClass != Object.class; tmpClass = tmpClass.getSuperclass()) {
                    QSParamInvokeUtil.initParameterMap(tmpClass, model, retParametersMap, paramType);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ("header".equals(paramType) && !retParametersMap.containsKey("Date")) {
            retParametersMap.put("Date", QSSignatureUtil.formatGmtDate(new Date()));
        }
        return retParametersMap;
    }

    private static void initParameterMap(Class objClass, Object source, Map retParametersMap, String paramType) throws InvocationTargetException, IllegalAccessException, QSException {
        Field[] declaredField;
        for (Field field : declaredField = objClass.getDeclaredFields()) {
            Method[] methods;
            String methodName = "get" + QSParamInvokeUtil.capitalize(field.getName());
            String fieldName = field.getName();
            for (Method m : methods = objClass.getDeclaredMethods()) {
                ParamAnnotation annotation;
                if (!m.getName().equalsIgnoreCase(methodName) || (annotation = m.getAnnotation(ParamAnnotation.class)) == null) continue;
                if (!"".equals(annotation.paramName())) {
                    fieldName = annotation.paramName();
                }
                if (paramType.equals(annotation.paramType())) {
                    QSParamInvokeUtil.setParameterToMap(m, source, retParametersMap, fieldName);
                    continue;
                }
                if (paramType.equals(annotation.paramType())) {
                    QSParamInvokeUtil.setParameterToMap(m, source, retParametersMap, fieldName);
                    continue;
                }
                if (paramType.equals(annotation.paramType())) {
                    QSParamInvokeUtil.setParameterToMap(m, source, retParametersMap, fieldName);
                    continue;
                }
                if (!"".equals(paramType)) continue;
                QSParamInvokeUtil.setParameterToMap(m, source, retParametersMap, fieldName);
            }
        }
    }

    private static void setParameterToMap(Method m, Object source, Map targetParametersMap, String paramKey) throws QSException {
        Object[] invokeParams = null;
        try {
            Object objValue = m.invoke(source, invokeParams);
            if (objValue != null) {
                targetParametersMap.put(paramKey, objValue);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new QSException("IllegalAccessException", e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new QSException("InvocationTargetException", e);
        }
    }

    public static void invokeObject2Map(Class sourceClass, Object source, Map targetParametersMap) throws QSException {
        Field[] declaredField;
        for (Field field : declaredField = sourceClass.getDeclaredFields()) {
            Method[] methods;
            String methodName = "get" + QSParamInvokeUtil.capitalize(field.getName());
            String fieldName = field.getName();
            for (Method m : methods = sourceClass.getDeclaredMethods()) {
                if (!m.getName().equalsIgnoreCase(methodName)) continue;
                ParamAnnotation annotation = m.getAnnotation(ParamAnnotation.class);
                if (annotation != null && !QSStringUtil.isEmpty(annotation.paramName())) {
                    fieldName = annotation.paramName();
                }
                QSParamInvokeUtil.setParameterToMap(m, source, targetParametersMap, fieldName);
            }
        }
    }

    public static String capitalize(String word) {
        return word.substring(0, 1).toUpperCase() + word.substring(1);
    }

    public static Object getOutputModel(Class className) throws QSException {
        try {
            return className.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new QSException(e.getMessage());
        }
    }

    public static Map serializeParams(Map parameters) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : parameters.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof List) {
                int cnt = ((List)value).size();
                for (int i = 0; i < cnt; ++i) {
                    Object v2 = ((List)value).get(i);
                    if (v2 instanceof Map) {
                        for (Object key2 : ((Map)v2).keySet()) {
                            result.put(key + "." + String.valueOf(i + 1) + "." + key2, ((Map)v2).get(key2));
                        }
                        continue;
                    }
                    result.put(key + "." + String.valueOf(i + 1), v2);
                }
                continue;
            }
            if (value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Boolean) {
                result.put(key, String.valueOf(value));
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    public static OutputModel getOutputModel(ResponseCallBack o) throws QSException {
        Type[] typeClass = o.getClass().getGenericInterfaces();
        try {
            if (typeClass[0] instanceof ParameterizedType) {
                Class actualType = (Class)((ParameterizedType)typeClass[0]).getActualTypeArguments()[0];
                return (OutputModel)actualType.newInstance();
            }
            return (OutputModel)OutputModel.class.newInstance();
        }
        catch (InstantiationException e) {
            throw new QSException("InstantiationException", e);
        }
        catch (IllegalAccessException e) {
            throw new QSException("IllegalAccessException", e);
        }
    }
}

