/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.service;

import com.qingstor.sdk.annotation.ParamAnnotation;
import com.qingstor.sdk.config.EnvContext;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.model.OutputModel;
import com.qingstor.sdk.model.RequestInputModel;
import com.qingstor.sdk.request.RequestHandler;
import com.qingstor.sdk.request.ResourceRequestFactory;
import com.qingstor.sdk.request.ResponseCallBack;
import com.qingstor.sdk.service.Types;
import com.qingstor.sdk.utils.QSSignatureUtil;
import com.qingstor.sdk.utils.QSStringUtil;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;

public class Bucket {
    private String zone;
    private String bucketName;
    private EnvContext envContext;

    public Bucket(EnvContext envContext, String zone, String bucketName) {
        this.envContext = envContext;
        this.zone = zone;
        this.bucketName = bucketName;
    }

    public DeleteBucketOutput delete() throws QSException {
        RequestHandler requestHandler = this.deleteRequest();
        OutputModel backModel = requestHandler.send();
        if (backModel != null) {
            return (DeleteBucketOutput)backModel;
        }
        return null;
    }

    public RequestHandler deleteRequest() throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "DeleteBucket");
        context.put("APIName", "DeleteBucket");
        context.put("ServiceName", "DELETE Bucket");
        context.put("RequestMethod", "DELETE");
        context.put("RequestURI", "/<bucket-name>");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, null, DeleteBucketOutput.class);
        return requestHandler;
    }

    public void deleteAsync(ResponseCallBack<DeleteBucketOutput> callback) throws QSException {
        RequestHandler requestHandler = this.deleteAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler deleteAsyncRequest(ResponseCallBack<DeleteBucketOutput> callback) throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "DeleteBucket");
        context.put("APIName", "DeleteBucket");
        context.put("ServiceName", "DELETE Bucket");
        context.put("RequestMethod", "DELETE");
        context.put("RequestURI", "/<bucket-name>");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, null, callback);
        return requestHandler;
    }

    public DeleteBucketCORSOutput deleteCORS() throws QSException {
        RequestHandler requestHandler = this.deleteCORSRequest();
        OutputModel backModel = requestHandler.send();
        if (backModel != null) {
            return (DeleteBucketCORSOutput)backModel;
        }
        return null;
    }

    public RequestHandler deleteCORSRequest() throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "DeleteBucketCORS");
        context.put("APIName", "DeleteBucketCORS");
        context.put("ServiceName", "DELETE Bucket CORS");
        context.put("RequestMethod", "DELETE");
        context.put("RequestURI", "/<bucket-name>?cors");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, null, DeleteBucketCORSOutput.class);
        return requestHandler;
    }

    public void deleteCORSAsync(ResponseCallBack<DeleteBucketCORSOutput> callback) throws QSException {
        RequestHandler requestHandler = this.deleteCORSAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler deleteCORSAsyncRequest(ResponseCallBack<DeleteBucketCORSOutput> callback) throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "DeleteBucketCORS");
        context.put("APIName", "DeleteBucketCORS");
        context.put("ServiceName", "DELETE Bucket CORS");
        context.put("RequestMethod", "DELETE");
        context.put("RequestURI", "/<bucket-name>?cors");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, null, callback);
        return requestHandler;
    }

    public DeleteBucketExternalMirrorOutput deleteExternalMirror() throws QSException {
        RequestHandler requestHandler = this.deleteExternalMirrorRequest();
        OutputModel backModel = requestHandler.send();
        if (backModel != null) {
            return (DeleteBucketExternalMirrorOutput)backModel;
        }
        return null;
    }

    public RequestHandler deleteExternalMirrorRequest() throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "DeleteBucketExternalMirror");
        context.put("APIName", "DeleteBucketExternalMirror");
        context.put("ServiceName", "DELETE Bucket External Mirror");
        context.put("RequestMethod", "DELETE");
        context.put("RequestURI", "/<bucket-name>?mirror");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, null, DeleteBucketExternalMirrorOutput.class);
        return requestHandler;
    }

    public void deleteExternalMirrorAsync(ResponseCallBack<DeleteBucketExternalMirrorOutput> callback) throws QSException {
        RequestHandler requestHandler = this.deleteExternalMirrorAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler deleteExternalMirrorAsyncRequest(ResponseCallBack<DeleteBucketExternalMirrorOutput> callback) throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "DeleteBucketExternalMirror");
        context.put("APIName", "DeleteBucketExternalMirror");
        context.put("ServiceName", "DELETE Bucket External Mirror");
        context.put("RequestMethod", "DELETE");
        context.put("RequestURI", "/<bucket-name>?mirror");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, null, callback);
        return requestHandler;
    }

    public DeleteBucketLifecycleOutput deleteLifecycle() throws QSException {
        RequestHandler requestHandler = this.deleteLifecycleRequest();
        OutputModel backModel = requestHandler.send();
        if (backModel != null) {
            return (DeleteBucketLifecycleOutput)backModel;
        }
        return null;
    }

    public RequestHandler deleteLifecycleRequest() throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "DeleteBucketLifecycle");
        context.put("APIName", "DeleteBucketLifecycle");
        context.put("ServiceName", "DELETE Bucket Lifecycle");
        context.put("RequestMethod", "DELETE");
        context.put("RequestURI", "/<bucket-name>?lifecycle");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, null, DeleteBucketLifecycleOutput.class);
        return requestHandler;
    }

    public void deleteLifecycleAsync(ResponseCallBack<DeleteBucketLifecycleOutput> callback) throws QSException {
        RequestHandler requestHandler = this.deleteLifecycleAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler deleteLifecycleAsyncRequest(ResponseCallBack<DeleteBucketLifecycleOutput> callback) throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "DeleteBucketLifecycle");
        context.put("APIName", "DeleteBucketLifecycle");
        context.put("ServiceName", "DELETE Bucket Lifecycle");
        context.put("RequestMethod", "DELETE");
        context.put("RequestURI", "/<bucket-name>?lifecycle");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, null, callback);
        return requestHandler;
    }

    public DeleteBucketNotificationOutput deleteNotification() throws QSException {
        RequestHandler requestHandler = this.deleteNotificationRequest();
        OutputModel backModel = requestHandler.send();
        if (backModel != null) {
            return (DeleteBucketNotificationOutput)backModel;
        }
        return null;
    }

    public RequestHandler deleteNotificationRequest() throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "DeleteBucketNotification");
        context.put("APIName", "DeleteBucketNotification");
        context.put("ServiceName", "DELETE Bucket Notification");
        context.put("RequestMethod", "DELETE");
        context.put("RequestURI", "/<bucket-name>?notification");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, null, DeleteBucketNotificationOutput.class);
        return requestHandler;
    }

    public void deleteNotificationAsync(ResponseCallBack<DeleteBucketNotificationOutput> callback) throws QSException {
        RequestHandler requestHandler = this.deleteNotificationAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler deleteNotificationAsyncRequest(ResponseCallBack<DeleteBucketNotificationOutput> callback) throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "DeleteBucketNotification");
        context.put("APIName", "DeleteBucketNotification");
        context.put("ServiceName", "DELETE Bucket Notification");
        context.put("RequestMethod", "DELETE");
        context.put("RequestURI", "/<bucket-name>?notification");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, null, callback);
        return requestHandler;
    }

    public DeleteBucketPolicyOutput deletePolicy() throws QSException {
        RequestHandler requestHandler = this.deletePolicyRequest();
        OutputModel backModel = requestHandler.send();
        if (backModel != null) {
            return (DeleteBucketPolicyOutput)backModel;
        }
        return null;
    }

    public RequestHandler deletePolicyRequest() throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "DeleteBucketPolicy");
        context.put("APIName", "DeleteBucketPolicy");
        context.put("ServiceName", "DELETE Bucket Policy");
        context.put("RequestMethod", "DELETE");
        context.put("RequestURI", "/<bucket-name>?policy");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, null, DeleteBucketPolicyOutput.class);
        return requestHandler;
    }

    public void deletePolicyAsync(ResponseCallBack<DeleteBucketPolicyOutput> callback) throws QSException {
        RequestHandler requestHandler = this.deletePolicyAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler deletePolicyAsyncRequest(ResponseCallBack<DeleteBucketPolicyOutput> callback) throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "DeleteBucketPolicy");
        context.put("APIName", "DeleteBucketPolicy");
        context.put("ServiceName", "DELETE Bucket Policy");
        context.put("RequestMethod", "DELETE");
        context.put("RequestURI", "/<bucket-name>?policy");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, null, callback);
        return requestHandler;
    }

    public DeleteMultipleObjectsOutput deleteMultipleObjects(DeleteMultipleObjectsInput input) throws QSException {
        RequestHandler requestHandler;
        OutputModel backModel;
        if (input == null) {
            input = new DeleteMultipleObjectsInput();
        }
        if ((backModel = (requestHandler = this.deleteMultipleObjectsRequest(input)).send()) != null) {
            return (DeleteMultipleObjectsOutput)backModel;
        }
        return null;
    }

    public RequestHandler deleteMultipleObjectsRequest(DeleteMultipleObjectsInput input) throws QSException {
        if (input == null) {
            input = new DeleteMultipleObjectsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "DeleteMultipleObjects");
        context.put("APIName", "DeleteMultipleObjects");
        context.put("ServiceName", "Delete Multiple Objects");
        context.put("RequestMethod", "POST");
        context.put("RequestURI", "/<bucket-name>?delete");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, input, DeleteMultipleObjectsOutput.class);
        return requestHandler;
    }

    public void deleteMultipleObjectsAsync(DeleteMultipleObjectsInput input, ResponseCallBack<DeleteMultipleObjectsOutput> callback) throws QSException {
        if (input == null) {
            input = new DeleteMultipleObjectsInput();
        }
        RequestHandler requestHandler = this.deleteMultipleObjectsAsyncRequest(input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler deleteMultipleObjectsAsyncRequest(DeleteMultipleObjectsInput input, ResponseCallBack<DeleteMultipleObjectsOutput> callback) throws QSException {
        if (input == null) {
            input = new DeleteMultipleObjectsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "DeleteMultipleObjects");
        context.put("APIName", "DeleteMultipleObjects");
        context.put("ServiceName", "Delete Multiple Objects");
        context.put("RequestMethod", "POST");
        context.put("RequestURI", "/<bucket-name>?delete");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, input, callback);
        return requestHandler;
    }

    public GetBucketACLOutput getACL() throws QSException {
        RequestHandler requestHandler = this.getACLRequest();
        OutputModel backModel = requestHandler.send();
        if (backModel != null) {
            return (GetBucketACLOutput)backModel;
        }
        return null;
    }

    public RequestHandler getACLRequest() throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "GetBucketACL");
        context.put("APIName", "GetBucketACL");
        context.put("ServiceName", "GET Bucket ACL");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/<bucket-name>?acl");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, null, GetBucketACLOutput.class);
        return requestHandler;
    }

    public void getACLAsync(ResponseCallBack<GetBucketACLOutput> callback) throws QSException {
        RequestHandler requestHandler = this.getACLAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler getACLAsyncRequest(ResponseCallBack<GetBucketACLOutput> callback) throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "GetBucketACL");
        context.put("APIName", "GetBucketACL");
        context.put("ServiceName", "GET Bucket ACL");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/<bucket-name>?acl");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, null, callback);
        return requestHandler;
    }

    public GetBucketCORSOutput getCORS() throws QSException {
        RequestHandler requestHandler = this.getCORSRequest();
        OutputModel backModel = requestHandler.send();
        if (backModel != null) {
            return (GetBucketCORSOutput)backModel;
        }
        return null;
    }

    public RequestHandler getCORSRequest() throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "GetBucketCORS");
        context.put("APIName", "GetBucketCORS");
        context.put("ServiceName", "GET Bucket CORS");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/<bucket-name>?cors");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, null, GetBucketCORSOutput.class);
        return requestHandler;
    }

    public void getCORSAsync(ResponseCallBack<GetBucketCORSOutput> callback) throws QSException {
        RequestHandler requestHandler = this.getCORSAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler getCORSAsyncRequest(ResponseCallBack<GetBucketCORSOutput> callback) throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "GetBucketCORS");
        context.put("APIName", "GetBucketCORS");
        context.put("ServiceName", "GET Bucket CORS");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/<bucket-name>?cors");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, null, callback);
        return requestHandler;
    }

    public GetBucketExternalMirrorOutput getExternalMirror() throws QSException {
        RequestHandler requestHandler = this.getExternalMirrorRequest();
        OutputModel backModel = requestHandler.send();
        if (backModel != null) {
            return (GetBucketExternalMirrorOutput)backModel;
        }
        return null;
    }

    public RequestHandler getExternalMirrorRequest() throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "GetBucketExternalMirror");
        context.put("APIName", "GetBucketExternalMirror");
        context.put("ServiceName", "GET Bucket External Mirror");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/<bucket-name>?mirror");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, null, GetBucketExternalMirrorOutput.class);
        return requestHandler;
    }

    public void getExternalMirrorAsync(ResponseCallBack<GetBucketExternalMirrorOutput> callback) throws QSException {
        RequestHandler requestHandler = this.getExternalMirrorAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler getExternalMirrorAsyncRequest(ResponseCallBack<GetBucketExternalMirrorOutput> callback) throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "GetBucketExternalMirror");
        context.put("APIName", "GetBucketExternalMirror");
        context.put("ServiceName", "GET Bucket External Mirror");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/<bucket-name>?mirror");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, null, callback);
        return requestHandler;
    }

    public GetBucketLifecycleOutput getLifecycle() throws QSException {
        RequestHandler requestHandler = this.getLifecycleRequest();
        OutputModel backModel = requestHandler.send();
        if (backModel != null) {
            return (GetBucketLifecycleOutput)backModel;
        }
        return null;
    }

    public RequestHandler getLifecycleRequest() throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "GetBucketLifecycle");
        context.put("APIName", "GetBucketLifecycle");
        context.put("ServiceName", "GET Bucket Lifecycle");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/<bucket-name>?lifecycle");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, null, GetBucketLifecycleOutput.class);
        return requestHandler;
    }

    public void getLifecycleAsync(ResponseCallBack<GetBucketLifecycleOutput> callback) throws QSException {
        RequestHandler requestHandler = this.getLifecycleAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler getLifecycleAsyncRequest(ResponseCallBack<GetBucketLifecycleOutput> callback) throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "GetBucketLifecycle");
        context.put("APIName", "GetBucketLifecycle");
        context.put("ServiceName", "GET Bucket Lifecycle");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/<bucket-name>?lifecycle");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, null, callback);
        return requestHandler;
    }

    public GetBucketNotificationOutput getNotification() throws QSException {
        RequestHandler requestHandler = this.getNotificationRequest();
        OutputModel backModel = requestHandler.send();
        if (backModel != null) {
            return (GetBucketNotificationOutput)backModel;
        }
        return null;
    }

    public RequestHandler getNotificationRequest() throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "GetBucketNotification");
        context.put("APIName", "GetBucketNotification");
        context.put("ServiceName", "GET Bucket Notification");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/<bucket-name>?notification");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, null, GetBucketNotificationOutput.class);
        return requestHandler;
    }

    public void getNotificationAsync(ResponseCallBack<GetBucketNotificationOutput> callback) throws QSException {
        RequestHandler requestHandler = this.getNotificationAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler getNotificationAsyncRequest(ResponseCallBack<GetBucketNotificationOutput> callback) throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "GetBucketNotification");
        context.put("APIName", "GetBucketNotification");
        context.put("ServiceName", "GET Bucket Notification");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/<bucket-name>?notification");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, null, callback);
        return requestHandler;
    }

    public GetBucketPolicyOutput getPolicy() throws QSException {
        RequestHandler requestHandler = this.getPolicyRequest();
        OutputModel backModel = requestHandler.send();
        if (backModel != null) {
            return (GetBucketPolicyOutput)backModel;
        }
        return null;
    }

    public RequestHandler getPolicyRequest() throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "GetBucketPolicy");
        context.put("APIName", "GetBucketPolicy");
        context.put("ServiceName", "GET Bucket Policy");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/<bucket-name>?policy");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, null, GetBucketPolicyOutput.class);
        return requestHandler;
    }

    public void getPolicyAsync(ResponseCallBack<GetBucketPolicyOutput> callback) throws QSException {
        RequestHandler requestHandler = this.getPolicyAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler getPolicyAsyncRequest(ResponseCallBack<GetBucketPolicyOutput> callback) throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "GetBucketPolicy");
        context.put("APIName", "GetBucketPolicy");
        context.put("ServiceName", "GET Bucket Policy");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/<bucket-name>?policy");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, null, callback);
        return requestHandler;
    }

    public GetBucketStatisticsOutput getStatistics() throws QSException {
        RequestHandler requestHandler = this.getStatisticsRequest();
        OutputModel backModel = requestHandler.send();
        if (backModel != null) {
            return (GetBucketStatisticsOutput)backModel;
        }
        return null;
    }

    public RequestHandler getStatisticsRequest() throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "GetBucketStatistics");
        context.put("APIName", "GetBucketStatistics");
        context.put("ServiceName", "GET Bucket Statistics");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/<bucket-name>?stats");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, null, GetBucketStatisticsOutput.class);
        return requestHandler;
    }

    public void getStatisticsAsync(ResponseCallBack<GetBucketStatisticsOutput> callback) throws QSException {
        RequestHandler requestHandler = this.getStatisticsAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler getStatisticsAsyncRequest(ResponseCallBack<GetBucketStatisticsOutput> callback) throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "GetBucketStatistics");
        context.put("APIName", "GetBucketStatistics");
        context.put("ServiceName", "GET Bucket Statistics");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/<bucket-name>?stats");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, null, callback);
        return requestHandler;
    }

    public HeadBucketOutput head() throws QSException {
        RequestHandler requestHandler = this.headRequest();
        OutputModel backModel = requestHandler.send();
        if (backModel != null) {
            return (HeadBucketOutput)backModel;
        }
        return null;
    }

    public RequestHandler headRequest() throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "HeadBucket");
        context.put("APIName", "HeadBucket");
        context.put("ServiceName", "HEAD Bucket");
        context.put("RequestMethod", "HEAD");
        context.put("RequestURI", "/<bucket-name>");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, null, HeadBucketOutput.class);
        return requestHandler;
    }

    public void headAsync(ResponseCallBack<HeadBucketOutput> callback) throws QSException {
        RequestHandler requestHandler = this.headAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler headAsyncRequest(ResponseCallBack<HeadBucketOutput> callback) throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "HeadBucket");
        context.put("APIName", "HeadBucket");
        context.put("ServiceName", "HEAD Bucket");
        context.put("RequestMethod", "HEAD");
        context.put("RequestURI", "/<bucket-name>");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, null, callback);
        return requestHandler;
    }

    public ListMultipartUploadsOutput listMultipartUploads(ListMultipartUploadsInput input) throws QSException {
        RequestHandler requestHandler;
        OutputModel backModel;
        if (input == null) {
            input = new ListMultipartUploadsInput();
        }
        if ((backModel = (requestHandler = this.listMultipartUploadsRequest(input)).send()) != null) {
            return (ListMultipartUploadsOutput)backModel;
        }
        return null;
    }

    public RequestHandler listMultipartUploadsRequest(ListMultipartUploadsInput input) throws QSException {
        if (input == null) {
            input = new ListMultipartUploadsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "ListMultipartUploads");
        context.put("APIName", "ListMultipartUploads");
        context.put("ServiceName", "List Multipart Uploads");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/<bucket-name>?uploads");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, input, ListMultipartUploadsOutput.class);
        return requestHandler;
    }

    public void listMultipartUploadsAsync(ListMultipartUploadsInput input, ResponseCallBack<ListMultipartUploadsOutput> callback) throws QSException {
        if (input == null) {
            input = new ListMultipartUploadsInput();
        }
        RequestHandler requestHandler = this.listMultipartUploadsAsyncRequest(input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler listMultipartUploadsAsyncRequest(ListMultipartUploadsInput input, ResponseCallBack<ListMultipartUploadsOutput> callback) throws QSException {
        if (input == null) {
            input = new ListMultipartUploadsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "ListMultipartUploads");
        context.put("APIName", "ListMultipartUploads");
        context.put("ServiceName", "List Multipart Uploads");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/<bucket-name>?uploads");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, input, callback);
        return requestHandler;
    }

    public ListObjectsOutput listObjects(ListObjectsInput input) throws QSException {
        RequestHandler requestHandler;
        OutputModel backModel;
        if (input == null) {
            input = new ListObjectsInput();
        }
        if ((backModel = (requestHandler = this.listObjectsRequest(input)).send()) != null) {
            return (ListObjectsOutput)backModel;
        }
        return null;
    }

    public RequestHandler listObjectsRequest(ListObjectsInput input) throws QSException {
        if (input == null) {
            input = new ListObjectsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "ListObjects");
        context.put("APIName", "ListObjects");
        context.put("ServiceName", "GET Bucket (List Objects)");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/<bucket-name>");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, input, ListObjectsOutput.class);
        return requestHandler;
    }

    public void listObjectsAsync(ListObjectsInput input, ResponseCallBack<ListObjectsOutput> callback) throws QSException {
        if (input == null) {
            input = new ListObjectsInput();
        }
        RequestHandler requestHandler = this.listObjectsAsyncRequest(input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler listObjectsAsyncRequest(ListObjectsInput input, ResponseCallBack<ListObjectsOutput> callback) throws QSException {
        if (input == null) {
            input = new ListObjectsInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "ListObjects");
        context.put("APIName", "ListObjects");
        context.put("ServiceName", "GET Bucket (List Objects)");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/<bucket-name>");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, input, callback);
        return requestHandler;
    }

    public PutBucketOutput put() throws QSException {
        RequestHandler requestHandler = this.putRequest();
        OutputModel backModel = requestHandler.send();
        if (backModel != null) {
            return (PutBucketOutput)backModel;
        }
        return null;
    }

    public RequestHandler putRequest() throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "PutBucket");
        context.put("APIName", "PutBucket");
        context.put("ServiceName", "PUT Bucket");
        context.put("RequestMethod", "PUT");
        context.put("RequestURI", "/<bucket-name>");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, null, PutBucketOutput.class);
        return requestHandler;
    }

    public void putAsync(ResponseCallBack<PutBucketOutput> callback) throws QSException {
        RequestHandler requestHandler = this.putAsyncRequest(callback);
        requestHandler.sendAsync();
    }

    public RequestHandler putAsyncRequest(ResponseCallBack<PutBucketOutput> callback) throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "PutBucket");
        context.put("APIName", "PutBucket");
        context.put("ServiceName", "PUT Bucket");
        context.put("RequestMethod", "PUT");
        context.put("RequestURI", "/<bucket-name>");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, null, callback);
        return requestHandler;
    }

    public PutBucketACLOutput putACL(PutBucketACLInput input) throws QSException {
        RequestHandler requestHandler;
        OutputModel backModel;
        if (input == null) {
            input = new PutBucketACLInput();
        }
        if ((backModel = (requestHandler = this.putACLRequest(input)).send()) != null) {
            return (PutBucketACLOutput)backModel;
        }
        return null;
    }

    public RequestHandler putACLRequest(PutBucketACLInput input) throws QSException {
        if (input == null) {
            input = new PutBucketACLInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "PutBucketACL");
        context.put("APIName", "PutBucketACL");
        context.put("ServiceName", "PUT Bucket ACL");
        context.put("RequestMethod", "PUT");
        context.put("RequestURI", "/<bucket-name>?acl");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, input, PutBucketACLOutput.class);
        return requestHandler;
    }

    public void putACLAsync(PutBucketACLInput input, ResponseCallBack<PutBucketACLOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketACLInput();
        }
        RequestHandler requestHandler = this.putACLAsyncRequest(input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler putACLAsyncRequest(PutBucketACLInput input, ResponseCallBack<PutBucketACLOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketACLInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "PutBucketACL");
        context.put("APIName", "PutBucketACL");
        context.put("ServiceName", "PUT Bucket ACL");
        context.put("RequestMethod", "PUT");
        context.put("RequestURI", "/<bucket-name>?acl");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, input, callback);
        return requestHandler;
    }

    public PutBucketCORSOutput putCORS(PutBucketCORSInput input) throws QSException {
        RequestHandler requestHandler;
        OutputModel backModel;
        if (input == null) {
            input = new PutBucketCORSInput();
        }
        if ((backModel = (requestHandler = this.putCORSRequest(input)).send()) != null) {
            return (PutBucketCORSOutput)backModel;
        }
        return null;
    }

    public RequestHandler putCORSRequest(PutBucketCORSInput input) throws QSException {
        if (input == null) {
            input = new PutBucketCORSInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "PutBucketCORS");
        context.put("APIName", "PutBucketCORS");
        context.put("ServiceName", "PUT Bucket CORS");
        context.put("RequestMethod", "PUT");
        context.put("RequestURI", "/<bucket-name>?cors");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, input, PutBucketCORSOutput.class);
        return requestHandler;
    }

    public void putCORSAsync(PutBucketCORSInput input, ResponseCallBack<PutBucketCORSOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketCORSInput();
        }
        RequestHandler requestHandler = this.putCORSAsyncRequest(input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler putCORSAsyncRequest(PutBucketCORSInput input, ResponseCallBack<PutBucketCORSOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketCORSInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "PutBucketCORS");
        context.put("APIName", "PutBucketCORS");
        context.put("ServiceName", "PUT Bucket CORS");
        context.put("RequestMethod", "PUT");
        context.put("RequestURI", "/<bucket-name>?cors");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, input, callback);
        return requestHandler;
    }

    public PutBucketExternalMirrorOutput putExternalMirror(PutBucketExternalMirrorInput input) throws QSException {
        RequestHandler requestHandler;
        OutputModel backModel;
        if (input == null) {
            input = new PutBucketExternalMirrorInput();
        }
        if ((backModel = (requestHandler = this.putExternalMirrorRequest(input)).send()) != null) {
            return (PutBucketExternalMirrorOutput)backModel;
        }
        return null;
    }

    public RequestHandler putExternalMirrorRequest(PutBucketExternalMirrorInput input) throws QSException {
        if (input == null) {
            input = new PutBucketExternalMirrorInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "PutBucketExternalMirror");
        context.put("APIName", "PutBucketExternalMirror");
        context.put("ServiceName", "PUT Bucket External Mirror");
        context.put("RequestMethod", "PUT");
        context.put("RequestURI", "/<bucket-name>?mirror");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, input, PutBucketExternalMirrorOutput.class);
        return requestHandler;
    }

    public void putExternalMirrorAsync(PutBucketExternalMirrorInput input, ResponseCallBack<PutBucketExternalMirrorOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketExternalMirrorInput();
        }
        RequestHandler requestHandler = this.putExternalMirrorAsyncRequest(input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler putExternalMirrorAsyncRequest(PutBucketExternalMirrorInput input, ResponseCallBack<PutBucketExternalMirrorOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketExternalMirrorInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "PutBucketExternalMirror");
        context.put("APIName", "PutBucketExternalMirror");
        context.put("ServiceName", "PUT Bucket External Mirror");
        context.put("RequestMethod", "PUT");
        context.put("RequestURI", "/<bucket-name>?mirror");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, input, callback);
        return requestHandler;
    }

    public PutBucketLifecycleOutput putLifecycle(PutBucketLifecycleInput input) throws QSException {
        RequestHandler requestHandler;
        OutputModel backModel;
        if (input == null) {
            input = new PutBucketLifecycleInput();
        }
        if ((backModel = (requestHandler = this.putLifecycleRequest(input)).send()) != null) {
            return (PutBucketLifecycleOutput)backModel;
        }
        return null;
    }

    public RequestHandler putLifecycleRequest(PutBucketLifecycleInput input) throws QSException {
        if (input == null) {
            input = new PutBucketLifecycleInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "PutBucketLifecycle");
        context.put("APIName", "PutBucketLifecycle");
        context.put("ServiceName", "PUT Bucket Lifecycle");
        context.put("RequestMethod", "PUT");
        context.put("RequestURI", "/<bucket-name>?lifecycle");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, input, PutBucketLifecycleOutput.class);
        return requestHandler;
    }

    public void putLifecycleAsync(PutBucketLifecycleInput input, ResponseCallBack<PutBucketLifecycleOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketLifecycleInput();
        }
        RequestHandler requestHandler = this.putLifecycleAsyncRequest(input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler putLifecycleAsyncRequest(PutBucketLifecycleInput input, ResponseCallBack<PutBucketLifecycleOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketLifecycleInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "PutBucketLifecycle");
        context.put("APIName", "PutBucketLifecycle");
        context.put("ServiceName", "PUT Bucket Lifecycle");
        context.put("RequestMethod", "PUT");
        context.put("RequestURI", "/<bucket-name>?lifecycle");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, input, callback);
        return requestHandler;
    }

    public PutBucketNotificationOutput putNotification(PutBucketNotificationInput input) throws QSException {
        RequestHandler requestHandler;
        OutputModel backModel;
        if (input == null) {
            input = new PutBucketNotificationInput();
        }
        if ((backModel = (requestHandler = this.putNotificationRequest(input)).send()) != null) {
            return (PutBucketNotificationOutput)backModel;
        }
        return null;
    }

    public RequestHandler putNotificationRequest(PutBucketNotificationInput input) throws QSException {
        if (input == null) {
            input = new PutBucketNotificationInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "PutBucketNotification");
        context.put("APIName", "PutBucketNotification");
        context.put("ServiceName", "PUT Bucket Notification");
        context.put("RequestMethod", "PUT");
        context.put("RequestURI", "/<bucket-name>?notification");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, input, PutBucketNotificationOutput.class);
        return requestHandler;
    }

    public void putNotificationAsync(PutBucketNotificationInput input, ResponseCallBack<PutBucketNotificationOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketNotificationInput();
        }
        RequestHandler requestHandler = this.putNotificationAsyncRequest(input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler putNotificationAsyncRequest(PutBucketNotificationInput input, ResponseCallBack<PutBucketNotificationOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketNotificationInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "PutBucketNotification");
        context.put("APIName", "PutBucketNotification");
        context.put("ServiceName", "PUT Bucket Notification");
        context.put("RequestMethod", "PUT");
        context.put("RequestURI", "/<bucket-name>?notification");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, input, callback);
        return requestHandler;
    }

    public PutBucketPolicyOutput putPolicy(PutBucketPolicyInput input) throws QSException {
        RequestHandler requestHandler;
        OutputModel backModel;
        if (input == null) {
            input = new PutBucketPolicyInput();
        }
        if ((backModel = (requestHandler = this.putPolicyRequest(input)).send()) != null) {
            return (PutBucketPolicyOutput)backModel;
        }
        return null;
    }

    public RequestHandler putPolicyRequest(PutBucketPolicyInput input) throws QSException {
        if (input == null) {
            input = new PutBucketPolicyInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "PutBucketPolicy");
        context.put("APIName", "PutBucketPolicy");
        context.put("ServiceName", "PUT Bucket Policy");
        context.put("RequestMethod", "PUT");
        context.put("RequestURI", "/<bucket-name>?policy");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, input, PutBucketPolicyOutput.class);
        return requestHandler;
    }

    public void putPolicyAsync(PutBucketPolicyInput input, ResponseCallBack<PutBucketPolicyOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketPolicyInput();
        }
        RequestHandler requestHandler = this.putPolicyAsyncRequest(input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler putPolicyAsyncRequest(PutBucketPolicyInput input, ResponseCallBack<PutBucketPolicyOutput> callback) throws QSException {
        if (input == null) {
            input = new PutBucketPolicyInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "PutBucketPolicy");
        context.put("APIName", "PutBucketPolicy");
        context.put("ServiceName", "PUT Bucket Policy");
        context.put("RequestMethod", "PUT");
        context.put("RequestURI", "/<bucket-name>?policy");
        context.put("bucketNameInput", this.bucketName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, input, callback);
        return requestHandler;
    }

    public AbortMultipartUploadOutput abortMultipartUpload(String objectName, AbortMultipartUploadInput input) throws QSException {
        RequestHandler requestHandler;
        OutputModel backModel;
        if (input == null) {
            input = new AbortMultipartUploadInput();
        }
        if ((backModel = (requestHandler = this.abortMultipartUploadRequest(objectName, input)).send()) != null) {
            return (AbortMultipartUploadOutput)backModel;
        }
        return null;
    }

    public RequestHandler abortMultipartUploadRequest(String objectName, AbortMultipartUploadInput input) throws QSException {
        if (input == null) {
            input = new AbortMultipartUploadInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "AbortMultipartUpload");
        context.put("APIName", "AbortMultipartUpload");
        context.put("ServiceName", "Abort Multipart Upload");
        context.put("RequestMethod", "DELETE");
        context.put("RequestURI", "/<bucket-name>/<object-key>");
        context.put("bucketNameInput", this.bucketName);
        context.put("objectNameInput", objectName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, input, AbortMultipartUploadOutput.class);
        return requestHandler;
    }

    public void abortMultipartUploadAsync(String objectName, AbortMultipartUploadInput input, ResponseCallBack<AbortMultipartUploadOutput> callback) throws QSException {
        if (input == null) {
            input = new AbortMultipartUploadInput();
        }
        RequestHandler requestHandler = this.abortMultipartUploadAsyncRequest(objectName, input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler abortMultipartUploadAsyncRequest(String objectName, AbortMultipartUploadInput input, ResponseCallBack<AbortMultipartUploadOutput> callback) throws QSException {
        if (input == null) {
            input = new AbortMultipartUploadInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "AbortMultipartUpload");
        context.put("APIName", "AbortMultipartUpload");
        context.put("ServiceName", "Abort Multipart Upload");
        context.put("RequestMethod", "DELETE");
        context.put("RequestURI", "/<bucket-name>/<object-key>");
        context.put("bucketNameInput", this.bucketName);
        context.put("objectNameInput", objectName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, input, callback);
        return requestHandler;
    }

    public CompleteMultipartUploadOutput completeMultipartUpload(String objectName, CompleteMultipartUploadInput input) throws QSException {
        RequestHandler requestHandler;
        OutputModel backModel;
        if (input == null) {
            input = new CompleteMultipartUploadInput();
        }
        if ((backModel = (requestHandler = this.completeMultipartUploadRequest(objectName, input)).send()) != null) {
            return (CompleteMultipartUploadOutput)backModel;
        }
        return null;
    }

    public RequestHandler completeMultipartUploadRequest(String objectName, CompleteMultipartUploadInput input) throws QSException {
        if (input == null) {
            input = new CompleteMultipartUploadInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "CompleteMultipartUpload");
        context.put("APIName", "CompleteMultipartUpload");
        context.put("ServiceName", "Complete multipart upload");
        context.put("RequestMethod", "POST");
        context.put("RequestURI", "/<bucket-name>/<object-key>");
        context.put("bucketNameInput", this.bucketName);
        context.put("objectNameInput", objectName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, input, CompleteMultipartUploadOutput.class);
        return requestHandler;
    }

    public void completeMultipartUploadAsync(String objectName, CompleteMultipartUploadInput input, ResponseCallBack<CompleteMultipartUploadOutput> callback) throws QSException {
        if (input == null) {
            input = new CompleteMultipartUploadInput();
        }
        RequestHandler requestHandler = this.completeMultipartUploadAsyncRequest(objectName, input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler completeMultipartUploadAsyncRequest(String objectName, CompleteMultipartUploadInput input, ResponseCallBack<CompleteMultipartUploadOutput> callback) throws QSException {
        if (input == null) {
            input = new CompleteMultipartUploadInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "CompleteMultipartUpload");
        context.put("APIName", "CompleteMultipartUpload");
        context.put("ServiceName", "Complete multipart upload");
        context.put("RequestMethod", "POST");
        context.put("RequestURI", "/<bucket-name>/<object-key>");
        context.put("bucketNameInput", this.bucketName);
        context.put("objectNameInput", objectName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, input, callback);
        return requestHandler;
    }

    public DeleteObjectOutput deleteObject(String objectName) throws QSException {
        RequestHandler requestHandler = this.deleteObjectRequest(objectName);
        OutputModel backModel = requestHandler.send();
        if (backModel != null) {
            return (DeleteObjectOutput)backModel;
        }
        return null;
    }

    public RequestHandler deleteObjectRequest(String objectName) throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "DeleteObject");
        context.put("APIName", "DeleteObject");
        context.put("ServiceName", "DELETE Object");
        context.put("RequestMethod", "DELETE");
        context.put("RequestURI", "/<bucket-name>/<object-key>");
        context.put("bucketNameInput", this.bucketName);
        context.put("objectNameInput", objectName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, null, DeleteObjectOutput.class);
        return requestHandler;
    }

    public void deleteObjectAsync(String objectName, ResponseCallBack<DeleteObjectOutput> callback) throws QSException {
        RequestHandler requestHandler = this.deleteObjectAsyncRequest(objectName, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler deleteObjectAsyncRequest(String objectName, ResponseCallBack<DeleteObjectOutput> callback) throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "DeleteObject");
        context.put("APIName", "DeleteObject");
        context.put("ServiceName", "DELETE Object");
        context.put("RequestMethod", "DELETE");
        context.put("RequestURI", "/<bucket-name>/<object-key>");
        context.put("bucketNameInput", this.bucketName);
        context.put("objectNameInput", objectName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, null, callback);
        return requestHandler;
    }

    public GetObjectOutput getObject(String objectName, GetObjectInput input) throws QSException {
        RequestHandler requestHandler;
        OutputModel backModel;
        if (input == null) {
            input = new GetObjectInput();
        }
        if ((backModel = (requestHandler = this.getObjectRequest(objectName, input)).send()) != null) {
            return (GetObjectOutput)backModel;
        }
        return null;
    }

    public RequestHandler getObjectRequest(String objectName, GetObjectInput input) throws QSException {
        if (input == null) {
            input = new GetObjectInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "GetObject");
        context.put("APIName", "GetObject");
        context.put("ServiceName", "GET Object");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/<bucket-name>/<object-key>");
        context.put("bucketNameInput", this.bucketName);
        context.put("objectNameInput", objectName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, input, GetObjectOutput.class);
        return requestHandler;
    }

    public void getObjectAsync(String objectName, GetObjectInput input, ResponseCallBack<GetObjectOutput> callback) throws QSException {
        if (input == null) {
            input = new GetObjectInput();
        }
        RequestHandler requestHandler = this.getObjectAsyncRequest(objectName, input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler getObjectAsyncRequest(String objectName, GetObjectInput input, ResponseCallBack<GetObjectOutput> callback) throws QSException {
        if (input == null) {
            input = new GetObjectInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "GetObject");
        context.put("APIName", "GetObject");
        context.put("ServiceName", "GET Object");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/<bucket-name>/<object-key>");
        context.put("bucketNameInput", this.bucketName);
        context.put("objectNameInput", objectName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, input, callback);
        return requestHandler;
    }

    public HeadObjectOutput headObject(String objectName, HeadObjectInput input) throws QSException {
        RequestHandler requestHandler;
        OutputModel backModel;
        if (input == null) {
            input = new HeadObjectInput();
        }
        if ((backModel = (requestHandler = this.headObjectRequest(objectName, input)).send()) != null) {
            return (HeadObjectOutput)backModel;
        }
        return null;
    }

    public RequestHandler headObjectRequest(String objectName, HeadObjectInput input) throws QSException {
        if (input == null) {
            input = new HeadObjectInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "HeadObject");
        context.put("APIName", "HeadObject");
        context.put("ServiceName", "HEAD Object");
        context.put("RequestMethod", "HEAD");
        context.put("RequestURI", "/<bucket-name>/<object-key>");
        context.put("bucketNameInput", this.bucketName);
        context.put("objectNameInput", objectName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, input, HeadObjectOutput.class);
        return requestHandler;
    }

    public void headObjectAsync(String objectName, HeadObjectInput input, ResponseCallBack<HeadObjectOutput> callback) throws QSException {
        if (input == null) {
            input = new HeadObjectInput();
        }
        RequestHandler requestHandler = this.headObjectAsyncRequest(objectName, input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler headObjectAsyncRequest(String objectName, HeadObjectInput input, ResponseCallBack<HeadObjectOutput> callback) throws QSException {
        if (input == null) {
            input = new HeadObjectInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "HeadObject");
        context.put("APIName", "HeadObject");
        context.put("ServiceName", "HEAD Object");
        context.put("RequestMethod", "HEAD");
        context.put("RequestURI", "/<bucket-name>/<object-key>");
        context.put("bucketNameInput", this.bucketName);
        context.put("objectNameInput", objectName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, input, callback);
        return requestHandler;
    }

    public ImageProcessOutput imageProcess(String objectName, ImageProcessInput input) throws QSException {
        RequestHandler requestHandler;
        OutputModel backModel;
        if (input == null) {
            input = new ImageProcessInput();
        }
        if ((backModel = (requestHandler = this.imageProcessRequest(objectName, input)).send()) != null) {
            return (ImageProcessOutput)backModel;
        }
        return null;
    }

    public RequestHandler imageProcessRequest(String objectName, ImageProcessInput input) throws QSException {
        if (input == null) {
            input = new ImageProcessInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "ImageProcess");
        context.put("APIName", "ImageProcess");
        context.put("ServiceName", "Image Process");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/<bucket-name>/<object-key>?image");
        context.put("bucketNameInput", this.bucketName);
        context.put("objectNameInput", objectName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, input, ImageProcessOutput.class);
        return requestHandler;
    }

    public void imageProcessAsync(String objectName, ImageProcessInput input, ResponseCallBack<ImageProcessOutput> callback) throws QSException {
        if (input == null) {
            input = new ImageProcessInput();
        }
        RequestHandler requestHandler = this.imageProcessAsyncRequest(objectName, input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler imageProcessAsyncRequest(String objectName, ImageProcessInput input, ResponseCallBack<ImageProcessOutput> callback) throws QSException {
        if (input == null) {
            input = new ImageProcessInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "ImageProcess");
        context.put("APIName", "ImageProcess");
        context.put("ServiceName", "Image Process");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/<bucket-name>/<object-key>?image");
        context.put("bucketNameInput", this.bucketName);
        context.put("objectNameInput", objectName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, input, callback);
        return requestHandler;
    }

    public InitiateMultipartUploadOutput initiateMultipartUpload(String objectName, InitiateMultipartUploadInput input) throws QSException {
        RequestHandler requestHandler;
        OutputModel backModel;
        if (input == null) {
            input = new InitiateMultipartUploadInput();
        }
        if ((backModel = (requestHandler = this.initiateMultipartUploadRequest(objectName, input)).send()) != null) {
            return (InitiateMultipartUploadOutput)backModel;
        }
        return null;
    }

    public RequestHandler initiateMultipartUploadRequest(String objectName, InitiateMultipartUploadInput input) throws QSException {
        if (input == null) {
            input = new InitiateMultipartUploadInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "InitiateMultipartUpload");
        context.put("APIName", "InitiateMultipartUpload");
        context.put("ServiceName", "Initiate Multipart Upload");
        context.put("RequestMethod", "POST");
        context.put("RequestURI", "/<bucket-name>/<object-key>?uploads");
        context.put("bucketNameInput", this.bucketName);
        context.put("objectNameInput", objectName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, input, InitiateMultipartUploadOutput.class);
        return requestHandler;
    }

    public void initiateMultipartUploadAsync(String objectName, InitiateMultipartUploadInput input, ResponseCallBack<InitiateMultipartUploadOutput> callback) throws QSException {
        if (input == null) {
            input = new InitiateMultipartUploadInput();
        }
        RequestHandler requestHandler = this.initiateMultipartUploadAsyncRequest(objectName, input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler initiateMultipartUploadAsyncRequest(String objectName, InitiateMultipartUploadInput input, ResponseCallBack<InitiateMultipartUploadOutput> callback) throws QSException {
        if (input == null) {
            input = new InitiateMultipartUploadInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "InitiateMultipartUpload");
        context.put("APIName", "InitiateMultipartUpload");
        context.put("ServiceName", "Initiate Multipart Upload");
        context.put("RequestMethod", "POST");
        context.put("RequestURI", "/<bucket-name>/<object-key>?uploads");
        context.put("bucketNameInput", this.bucketName);
        context.put("objectNameInput", objectName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, input, callback);
        return requestHandler;
    }

    public ListMultipartOutput listMultipart(String objectName, ListMultipartInput input) throws QSException {
        RequestHandler requestHandler;
        OutputModel backModel;
        if (input == null) {
            input = new ListMultipartInput();
        }
        if ((backModel = (requestHandler = this.listMultipartRequest(objectName, input)).send()) != null) {
            return (ListMultipartOutput)backModel;
        }
        return null;
    }

    public RequestHandler listMultipartRequest(String objectName, ListMultipartInput input) throws QSException {
        if (input == null) {
            input = new ListMultipartInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "ListMultipart");
        context.put("APIName", "ListMultipart");
        context.put("ServiceName", "List Multipart");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/<bucket-name>/<object-key>");
        context.put("bucketNameInput", this.bucketName);
        context.put("objectNameInput", objectName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, input, ListMultipartOutput.class);
        return requestHandler;
    }

    public void listMultipartAsync(String objectName, ListMultipartInput input, ResponseCallBack<ListMultipartOutput> callback) throws QSException {
        if (input == null) {
            input = new ListMultipartInput();
        }
        RequestHandler requestHandler = this.listMultipartAsyncRequest(objectName, input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler listMultipartAsyncRequest(String objectName, ListMultipartInput input, ResponseCallBack<ListMultipartOutput> callback) throws QSException {
        if (input == null) {
            input = new ListMultipartInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "ListMultipart");
        context.put("APIName", "ListMultipart");
        context.put("ServiceName", "List Multipart");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/<bucket-name>/<object-key>");
        context.put("bucketNameInput", this.bucketName);
        context.put("objectNameInput", objectName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, input, callback);
        return requestHandler;
    }

    public OptionsObjectOutput optionsObject(String objectName, OptionsObjectInput input) throws QSException {
        RequestHandler requestHandler;
        OutputModel backModel;
        if (input == null) {
            input = new OptionsObjectInput();
        }
        if ((backModel = (requestHandler = this.optionsObjectRequest(objectName, input)).send()) != null) {
            return (OptionsObjectOutput)backModel;
        }
        return null;
    }

    public RequestHandler optionsObjectRequest(String objectName, OptionsObjectInput input) throws QSException {
        if (input == null) {
            input = new OptionsObjectInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "OptionsObject");
        context.put("APIName", "OptionsObject");
        context.put("ServiceName", "OPTIONS Object");
        context.put("RequestMethod", "OPTIONS");
        context.put("RequestURI", "/<bucket-name>/<object-key>");
        context.put("bucketNameInput", this.bucketName);
        context.put("objectNameInput", objectName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, input, OptionsObjectOutput.class);
        return requestHandler;
    }

    public void optionsObjectAsync(String objectName, OptionsObjectInput input, ResponseCallBack<OptionsObjectOutput> callback) throws QSException {
        if (input == null) {
            input = new OptionsObjectInput();
        }
        RequestHandler requestHandler = this.optionsObjectAsyncRequest(objectName, input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler optionsObjectAsyncRequest(String objectName, OptionsObjectInput input, ResponseCallBack<OptionsObjectOutput> callback) throws QSException {
        if (input == null) {
            input = new OptionsObjectInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "OptionsObject");
        context.put("APIName", "OptionsObject");
        context.put("ServiceName", "OPTIONS Object");
        context.put("RequestMethod", "OPTIONS");
        context.put("RequestURI", "/<bucket-name>/<object-key>");
        context.put("bucketNameInput", this.bucketName);
        context.put("objectNameInput", objectName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, input, callback);
        return requestHandler;
    }

    public PutObjectOutput putObject(String objectName, PutObjectInput input) throws QSException {
        RequestHandler requestHandler;
        OutputModel backModel;
        if (input == null) {
            input = new PutObjectInput();
        }
        if ((backModel = (requestHandler = this.putObjectRequest(objectName, input)).send()) != null) {
            return (PutObjectOutput)backModel;
        }
        return null;
    }

    public RequestHandler putObjectRequest(String objectName, PutObjectInput input) throws QSException {
        if (input == null) {
            input = new PutObjectInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "PutObject");
        context.put("APIName", "PutObject");
        context.put("ServiceName", "PUT Object");
        context.put("RequestMethod", "PUT");
        context.put("RequestURI", "/<bucket-name>/<object-key>");
        context.put("bucketNameInput", this.bucketName);
        context.put("objectNameInput", objectName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, input, PutObjectOutput.class);
        return requestHandler;
    }

    public void putObjectAsync(String objectName, PutObjectInput input, ResponseCallBack<PutObjectOutput> callback) throws QSException {
        if (input == null) {
            input = new PutObjectInput();
        }
        RequestHandler requestHandler = this.putObjectAsyncRequest(objectName, input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler putObjectAsyncRequest(String objectName, PutObjectInput input, ResponseCallBack<PutObjectOutput> callback) throws QSException {
        if (input == null) {
            input = new PutObjectInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "PutObject");
        context.put("APIName", "PutObject");
        context.put("ServiceName", "PUT Object");
        context.put("RequestMethod", "PUT");
        context.put("RequestURI", "/<bucket-name>/<object-key>");
        context.put("bucketNameInput", this.bucketName);
        context.put("objectNameInput", objectName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, input, callback);
        return requestHandler;
    }

    public UploadMultipartOutput uploadMultipart(String objectName, UploadMultipartInput input) throws QSException {
        RequestHandler requestHandler;
        OutputModel backModel;
        if (input == null) {
            input = new UploadMultipartInput();
        }
        if ((backModel = (requestHandler = this.uploadMultipartRequest(objectName, input)).send()) != null) {
            return (UploadMultipartOutput)backModel;
        }
        return null;
    }

    public RequestHandler uploadMultipartRequest(String objectName, UploadMultipartInput input) throws QSException {
        if (input == null) {
            input = new UploadMultipartInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "UploadMultipart");
        context.put("APIName", "UploadMultipart");
        context.put("ServiceName", "Upload Multipart");
        context.put("RequestMethod", "PUT");
        context.put("RequestURI", "/<bucket-name>/<object-key>");
        context.put("bucketNameInput", this.bucketName);
        context.put("objectNameInput", objectName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, input, UploadMultipartOutput.class);
        return requestHandler;
    }

    public void uploadMultipartAsync(String objectName, UploadMultipartInput input, ResponseCallBack<UploadMultipartOutput> callback) throws QSException {
        if (input == null) {
            input = new UploadMultipartInput();
        }
        RequestHandler requestHandler = this.uploadMultipartAsyncRequest(objectName, input, callback);
        requestHandler.sendAsync();
    }

    public RequestHandler uploadMultipartAsyncRequest(String objectName, UploadMultipartInput input, ResponseCallBack<UploadMultipartOutput> callback) throws QSException {
        if (input == null) {
            input = new UploadMultipartInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "UploadMultipart");
        context.put("APIName", "UploadMultipart");
        context.put("ServiceName", "Upload Multipart");
        context.put("RequestMethod", "PUT");
        context.put("RequestURI", "/<bucket-name>/<object-key>");
        context.put("bucketNameInput", this.bucketName);
        context.put("objectNameInput", objectName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequestAsync(context, input, callback);
        return requestHandler;
    }

    @Deprecated
    public String GetObjectSignatureUrl(String objectName, int expiresSecond) throws QSException {
        return QSSignatureUtil.getObjectAuthRequestUrl(this.envContext, this.zone, this.bucketName, objectName, expiresSecond);
    }

    public String GetObjectSignatureUrl(String objectName, long expires) throws QSException {
        RequestHandler requestHandler = this.GetObjectBySignatureUrlRequest(objectName, null, expires);
        return requestHandler.getExpiresRequestUrl();
    }

    public RequestHandler GetObjectBySignatureUrlRequest(String objectName, GetObjectInput input, long expires) throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("expires", String.valueOf(expires));
        context.put("OperationName", "GetObject");
        context.put("APIName", "GetObject");
        context.put("ServiceName", "Get Object");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/<bucket-name>/<object-key>");
        context.put("bucketNameInput", this.bucketName);
        context.put("objectNameInput", objectName);
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        if (input == null) {
            input = new GetObjectInput();
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, input, OutputModel.class);
        return requestHandler;
    }

    public GetObjectOutput GetObjectBySignatureUrl(String signaturedRequest) throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "GetObject");
        context.put("APIName", "GetObject");
        context.put("ServiceName", "QingStor");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/<bucket-name>/<object-key>");
        OutputModel backModel = ResourceRequestFactory.getResourceRequest().sendApiRequest(signaturedRequest, context, GetObjectOutput.class);
        if (backModel != null) {
            return (GetObjectOutput)backModel;
        }
        return null;
    }

    public void GetObjectBySignatureUrlAsync(String signaturedRequest, ResponseCallBack<GetObjectOutput> callback) throws QSException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "GetObject");
        context.put("APIName", "GetObject");
        context.put("ServiceName", "QingStor");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/<bucket-name>/<object-key>");
        if (callback == null) {
            throw new QSException("callback can't be null");
        }
        ResourceRequestFactory.getResourceRequest().sendApiRequestAsync(signaturedRequest, context, callback);
    }

    public RequestHandler imageProcessExpiredUrlRequest(String objectName, ImageProcessInput input, long expires) throws QSException {
        if (input == null) {
            input = new ImageProcessInput();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("RequestZone", this.zone);
        context.put("evnContext", this.envContext);
        context.put("OperationName", "ImageProcess");
        context.put("APIName", "ImageProcess");
        context.put("ServiceName", "Image Process");
        context.put("RequestMethod", "GET");
        context.put("RequestURI", "/<bucket-name>/<object-key>?image");
        context.put("bucketNameInput", this.bucketName);
        context.put("objectNameInput", objectName);
        if (expires > System.currentTimeMillis() / 1000L) {
            context.put("expires", String.valueOf(expires));
        }
        if (QSStringUtil.isEmpty(this.bucketName)) {
            throw new QSException("bucketName can't be empty!");
        }
        if (QSStringUtil.isEmpty(objectName)) {
            throw new QSException("objectName can't be empty!");
        }
        RequestHandler requestHandler = ResourceRequestFactory.getResourceRequest().getRequest(context, input, ImageProcessOutput.class);
        return requestHandler;
    }

    public static class UploadMultipartOutput
    extends OutputModel {
        private String eTag;
        private String xQSContentCopyRange;
        private String xQSEncryptionCustomerAlgorithm;

        public void setETag(String eTag) {
            this.eTag = eTag;
        }

        @ParamAnnotation(paramType="header", paramName="ETag")
        public String getETag() {
            return this.eTag;
        }

        public void setXQSContentCopyRange(String xQSContentCopyRange) {
            this.xQSContentCopyRange = xQSContentCopyRange;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Content-Copy-Range")
        public String getXQSContentCopyRange() {
            return this.xQSContentCopyRange;
        }

        public void setXQSEncryptionCustomerAlgorithm(String xQSEncryptionCustomerAlgorithm) {
            this.xQSEncryptionCustomerAlgorithm = xQSEncryptionCustomerAlgorithm;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Encryption-Customer-Algorithm")
        public String getXQSEncryptionCustomerAlgorithm() {
            return this.xQSEncryptionCustomerAlgorithm;
        }
    }

    public static class UploadMultipartInput
    extends RequestInputModel {
        private Integer partNumber;
        private String uploadID;
        private Long fileOffset = -1L;
        private Long contentLength;
        private String contentMD5;
        private String xQSCopyRange;
        private String xQSCopySource;
        private String xQSCopySourceEncryptionCustomerAlgorithm;
        private String xQSCopySourceEncryptionCustomerKey;
        private String xQSCopySourceEncryptionCustomerKeyMD5;
        private String xQSCopySourceIfMatch;
        private String xQSCopySourceIfModifiedSince;
        private String xQSCopySourceIfNoneMatch;
        private String xQSCopySourceIfUnmodifiedSince;
        private String xQSEncryptionCustomerAlgorithm;
        private String xQSEncryptionCustomerKey;
        private String xQSEncryptionCustomerKeyMD5;
        private File bodyInputFile;
        private InputStream bodyInputStream;

        public void setPartNumber(Integer partNumber) {
            this.partNumber = partNumber;
        }

        @ParamAnnotation(paramType="query", paramName="part_number")
        public Integer getPartNumber() {
            return this.partNumber;
        }

        public void setUploadID(String uploadID) {
            this.uploadID = uploadID;
        }

        @ParamAnnotation(paramType="query", paramName="upload_id")
        public String getUploadID() {
            return this.uploadID;
        }

        public void setFileOffset(Long fileOffset) {
            this.fileOffset = fileOffset;
        }

        @ParamAnnotation(paramType="query", paramName="file_offset")
        public Long getFileOffset() {
            return this.fileOffset;
        }

        public void setBodyInputFilePart(File bodyInputFilePart) {
            this.bodyInputFile = bodyInputFilePart;
            this.fileOffset = 0L;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInputFile")
        public File getBodyInputFilePart() {
            return this.bodyInputFile;
        }

        public void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        @ParamAnnotation(paramType="header", paramName="Content-Length")
        public Long getContentLength() {
            return this.contentLength;
        }

        public void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        @ParamAnnotation(paramType="header", paramName="Content-MD5")
        public String getContentMD5() {
            return this.contentMD5;
        }

        public void setXQSCopyRange(String xQSCopyRange) {
            this.xQSCopyRange = xQSCopyRange;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Copy-Range")
        public String getXQSCopyRange() {
            return this.xQSCopyRange;
        }

        public void setXQSCopySource(String xQSCopySource) {
            this.xQSCopySource = xQSCopySource;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Copy-Source")
        public String getXQSCopySource() {
            return this.xQSCopySource;
        }

        public void setXQSCopySourceEncryptionCustomerAlgorithm(String xQSCopySourceEncryptionCustomerAlgorithm) {
            this.xQSCopySourceEncryptionCustomerAlgorithm = xQSCopySourceEncryptionCustomerAlgorithm;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Copy-Source-Encryption-Customer-Algorithm")
        public String getXQSCopySourceEncryptionCustomerAlgorithm() {
            return this.xQSCopySourceEncryptionCustomerAlgorithm;
        }

        public void setXQSCopySourceEncryptionCustomerKey(String xQSCopySourceEncryptionCustomerKey) {
            this.xQSCopySourceEncryptionCustomerKey = xQSCopySourceEncryptionCustomerKey;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Copy-Source-Encryption-Customer-Key")
        public String getXQSCopySourceEncryptionCustomerKey() {
            return this.xQSCopySourceEncryptionCustomerKey;
        }

        public void setXQSCopySourceEncryptionCustomerKeyMD5(String xQSCopySourceEncryptionCustomerKeyMD5) {
            this.xQSCopySourceEncryptionCustomerKeyMD5 = xQSCopySourceEncryptionCustomerKeyMD5;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Copy-Source-Encryption-Customer-Key-MD5")
        public String getXQSCopySourceEncryptionCustomerKeyMD5() {
            return this.xQSCopySourceEncryptionCustomerKeyMD5;
        }

        public void setXQSCopySourceIfMatch(String xQSCopySourceIfMatch) {
            this.xQSCopySourceIfMatch = xQSCopySourceIfMatch;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Copy-Source-If-Match")
        public String getXQSCopySourceIfMatch() {
            return this.xQSCopySourceIfMatch;
        }

        public void setXQSCopySourceIfModifiedSince(String xQSCopySourceIfModifiedSince) {
            this.xQSCopySourceIfModifiedSince = xQSCopySourceIfModifiedSince;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Copy-Source-If-Modified-Since")
        public String getXQSCopySourceIfModifiedSince() {
            return this.xQSCopySourceIfModifiedSince;
        }

        public void setXQSCopySourceIfNoneMatch(String xQSCopySourceIfNoneMatch) {
            this.xQSCopySourceIfNoneMatch = xQSCopySourceIfNoneMatch;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Copy-Source-If-None-Match")
        public String getXQSCopySourceIfNoneMatch() {
            return this.xQSCopySourceIfNoneMatch;
        }

        public void setXQSCopySourceIfUnmodifiedSince(String xQSCopySourceIfUnmodifiedSince) {
            this.xQSCopySourceIfUnmodifiedSince = xQSCopySourceIfUnmodifiedSince;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Copy-Source-If-Unmodified-Since")
        public String getXQSCopySourceIfUnmodifiedSince() {
            return this.xQSCopySourceIfUnmodifiedSince;
        }

        public void setXQSEncryptionCustomerAlgorithm(String xQSEncryptionCustomerAlgorithm) {
            this.xQSEncryptionCustomerAlgorithm = xQSEncryptionCustomerAlgorithm;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Encryption-Customer-Algorithm")
        public String getXQSEncryptionCustomerAlgorithm() {
            return this.xQSEncryptionCustomerAlgorithm;
        }

        public void setXQSEncryptionCustomerKey(String xQSEncryptionCustomerKey) {
            this.xQSEncryptionCustomerKey = xQSEncryptionCustomerKey;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Encryption-Customer-Key")
        public String getXQSEncryptionCustomerKey() {
            return this.xQSEncryptionCustomerKey;
        }

        public void setXQSEncryptionCustomerKeyMD5(String xQSEncryptionCustomerKeyMD5) {
            this.xQSEncryptionCustomerKeyMD5 = xQSEncryptionCustomerKeyMD5;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Encryption-Customer-Key-MD5")
        public String getXQSEncryptionCustomerKeyMD5() {
            return this.xQSEncryptionCustomerKeyMD5;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInputFile")
        public File getBodyInputFile() {
            return this.bodyInputFile;
        }

        @Deprecated
        public void setBodyInputFile(File bodyInputFile) {
            this.bodyInputFile = bodyInputFile;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInputStream")
        public InputStream getBodyInputStream() {
            return this.bodyInputStream;
        }

        public void setBodyInputStream(InputStream bodyInputStream) {
            this.bodyInputStream = bodyInputStream;
        }

        @Override
        public String validateParam() {
            if (this.getPartNumber() < 0) {
                return QSStringUtil.getParameterRequired("PartNumber", "UploadMultipartInput");
            }
            if (QSStringUtil.isEmpty(this.getUploadID())) {
                return QSStringUtil.getParameterRequired("UploadID", "UploadMultipartInput");
            }
            return null;
        }
    }

    public static class PutObjectOutput
    extends OutputModel {
        private String eTag;
        private String xQSEncryptionCustomerAlgorithm;

        public void setETag(String eTag) {
            this.eTag = eTag;
        }

        @ParamAnnotation(paramType="header", paramName="ETag")
        public String getETag() {
            return this.eTag;
        }

        public void setXQSEncryptionCustomerAlgorithm(String xQSEncryptionCustomerAlgorithm) {
            this.xQSEncryptionCustomerAlgorithm = xQSEncryptionCustomerAlgorithm;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Encryption-Customer-Algorithm")
        public String getXQSEncryptionCustomerAlgorithm() {
            return this.xQSEncryptionCustomerAlgorithm;
        }
    }

    public static class PutObjectInput
    extends RequestInputModel {
        private Long contentLength;
        private String contentMD5;
        private String contentType;
        private String expect;
        private String xQSCopySource;
        private String xQSCopySourceEncryptionCustomerAlgorithm;
        private String xQSCopySourceEncryptionCustomerKey;
        private String xQSCopySourceEncryptionCustomerKeyMD5;
        private String xQSCopySourceIfMatch;
        private String xQSCopySourceIfModifiedSince;
        private String xQSCopySourceIfNoneMatch;
        private String xQSCopySourceIfUnmodifiedSince;
        private String xQSEncryptionCustomerAlgorithm;
        private String xQSEncryptionCustomerKey;
        private String xQSEncryptionCustomerKeyMD5;
        private String xQSFetchIfUnmodifiedSince;
        private String xQSFetchSource;
        private String xQSMoveSource;
        private String xQSStorageClass;
        private File bodyInputFile;
        private InputStream bodyInputStream;

        public void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        @ParamAnnotation(paramType="header", paramName="Content-Length")
        public Long getContentLength() {
            return this.contentLength;
        }

        public void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        @ParamAnnotation(paramType="header", paramName="Content-MD5")
        public String getContentMD5() {
            return this.contentMD5;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @ParamAnnotation(paramType="header", paramName="Content-Type")
        public String getContentType() {
            return this.contentType;
        }

        public void setExpect(String expect) {
            this.expect = expect;
        }

        @ParamAnnotation(paramType="header", paramName="Expect")
        public String getExpect() {
            return this.expect;
        }

        public void setXQSCopySource(String xQSCopySource) {
            this.xQSCopySource = xQSCopySource;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Copy-Source")
        public String getXQSCopySource() {
            return this.xQSCopySource;
        }

        public void setXQSCopySourceEncryptionCustomerAlgorithm(String xQSCopySourceEncryptionCustomerAlgorithm) {
            this.xQSCopySourceEncryptionCustomerAlgorithm = xQSCopySourceEncryptionCustomerAlgorithm;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Copy-Source-Encryption-Customer-Algorithm")
        public String getXQSCopySourceEncryptionCustomerAlgorithm() {
            return this.xQSCopySourceEncryptionCustomerAlgorithm;
        }

        public void setXQSCopySourceEncryptionCustomerKey(String xQSCopySourceEncryptionCustomerKey) {
            this.xQSCopySourceEncryptionCustomerKey = xQSCopySourceEncryptionCustomerKey;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Copy-Source-Encryption-Customer-Key")
        public String getXQSCopySourceEncryptionCustomerKey() {
            return this.xQSCopySourceEncryptionCustomerKey;
        }

        public void setXQSCopySourceEncryptionCustomerKeyMD5(String xQSCopySourceEncryptionCustomerKeyMD5) {
            this.xQSCopySourceEncryptionCustomerKeyMD5 = xQSCopySourceEncryptionCustomerKeyMD5;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Copy-Source-Encryption-Customer-Key-MD5")
        public String getXQSCopySourceEncryptionCustomerKeyMD5() {
            return this.xQSCopySourceEncryptionCustomerKeyMD5;
        }

        public void setXQSCopySourceIfMatch(String xQSCopySourceIfMatch) {
            this.xQSCopySourceIfMatch = xQSCopySourceIfMatch;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Copy-Source-If-Match")
        public String getXQSCopySourceIfMatch() {
            return this.xQSCopySourceIfMatch;
        }

        public void setXQSCopySourceIfModifiedSince(String xQSCopySourceIfModifiedSince) {
            this.xQSCopySourceIfModifiedSince = xQSCopySourceIfModifiedSince;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Copy-Source-If-Modified-Since")
        public String getXQSCopySourceIfModifiedSince() {
            return this.xQSCopySourceIfModifiedSince;
        }

        public void setXQSCopySourceIfNoneMatch(String xQSCopySourceIfNoneMatch) {
            this.xQSCopySourceIfNoneMatch = xQSCopySourceIfNoneMatch;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Copy-Source-If-None-Match")
        public String getXQSCopySourceIfNoneMatch() {
            return this.xQSCopySourceIfNoneMatch;
        }

        public void setXQSCopySourceIfUnmodifiedSince(String xQSCopySourceIfUnmodifiedSince) {
            this.xQSCopySourceIfUnmodifiedSince = xQSCopySourceIfUnmodifiedSince;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Copy-Source-If-Unmodified-Since")
        public String getXQSCopySourceIfUnmodifiedSince() {
            return this.xQSCopySourceIfUnmodifiedSince;
        }

        public void setXQSEncryptionCustomerAlgorithm(String xQSEncryptionCustomerAlgorithm) {
            this.xQSEncryptionCustomerAlgorithm = xQSEncryptionCustomerAlgorithm;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Encryption-Customer-Algorithm")
        public String getXQSEncryptionCustomerAlgorithm() {
            return this.xQSEncryptionCustomerAlgorithm;
        }

        public void setXQSEncryptionCustomerKey(String xQSEncryptionCustomerKey) {
            this.xQSEncryptionCustomerKey = xQSEncryptionCustomerKey;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Encryption-Customer-Key")
        public String getXQSEncryptionCustomerKey() {
            return this.xQSEncryptionCustomerKey;
        }

        public void setXQSEncryptionCustomerKeyMD5(String xQSEncryptionCustomerKeyMD5) {
            this.xQSEncryptionCustomerKeyMD5 = xQSEncryptionCustomerKeyMD5;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Encryption-Customer-Key-MD5")
        public String getXQSEncryptionCustomerKeyMD5() {
            return this.xQSEncryptionCustomerKeyMD5;
        }

        public void setXQSFetchIfUnmodifiedSince(String xQSFetchIfUnmodifiedSince) {
            this.xQSFetchIfUnmodifiedSince = xQSFetchIfUnmodifiedSince;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Fetch-If-Unmodified-Since")
        public String getXQSFetchIfUnmodifiedSince() {
            return this.xQSFetchIfUnmodifiedSince;
        }

        public void setXQSFetchSource(String xQSFetchSource) {
            this.xQSFetchSource = xQSFetchSource;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Fetch-Source")
        public String getXQSFetchSource() {
            return this.xQSFetchSource;
        }

        public void setXQSMoveSource(String xQSMoveSource) {
            this.xQSMoveSource = xQSMoveSource;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Move-Source")
        public String getXQSMoveSource() {
            return this.xQSMoveSource;
        }

        public void setXQSStorageClass(String xQSStorageClass) {
            this.xQSStorageClass = xQSStorageClass;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Storage-Class")
        public String getXQSStorageClass() {
            return this.xQSStorageClass;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInputFile")
        public File getBodyInputFile() {
            return this.bodyInputFile;
        }

        public void setBodyInputFile(File bodyInputFile) {
            this.bodyInputFile = bodyInputFile;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInputStream")
        public InputStream getBodyInputStream() {
            return this.bodyInputStream;
        }

        public void setBodyInputStream(InputStream bodyInputStream) {
            this.bodyInputStream = bodyInputStream;
        }

        @Override
        public String validateParam() {
            String[] xQSStorageClassValidValues = new String[]{"STANDARD", "STANDARD_IA"};
            boolean xQSStorageClassIsValid = false;
            String value = this.getXQSStorageClass();
            if (null == value || "".equals(value)) {
                xQSStorageClassIsValid = true;
            } else {
                for (String v : xQSStorageClassValidValues) {
                    if (!v.equals(value)) continue;
                    xQSStorageClassIsValid = true;
                }
            }
            if (!xQSStorageClassIsValid) {
                return QSStringUtil.getParameterValueNotAllowedError("XQSStorageClass", this.getXQSStorageClass() + "", xQSStorageClassValidValues);
            }
            return null;
        }
    }

    public static class OptionsObjectOutput
    extends OutputModel {
        private String accessControlAllowHeaders;
        private String accessControlAllowMethods;
        private String accessControlAllowOrigin;
        private String accessControlExposeHeaders;
        private String accessControlMaxAge;

        public void setAccessControlAllowHeaders(String accessControlAllowHeaders) {
            this.accessControlAllowHeaders = accessControlAllowHeaders;
        }

        @ParamAnnotation(paramType="header", paramName="Access-Control-Allow-Headers")
        public String getAccessControlAllowHeaders() {
            return this.accessControlAllowHeaders;
        }

        public void setAccessControlAllowMethods(String accessControlAllowMethods) {
            this.accessControlAllowMethods = accessControlAllowMethods;
        }

        @ParamAnnotation(paramType="header", paramName="Access-Control-Allow-Methods")
        public String getAccessControlAllowMethods() {
            return this.accessControlAllowMethods;
        }

        public void setAccessControlAllowOrigin(String accessControlAllowOrigin) {
            this.accessControlAllowOrigin = accessControlAllowOrigin;
        }

        @ParamAnnotation(paramType="header", paramName="Access-Control-Allow-Origin")
        public String getAccessControlAllowOrigin() {
            return this.accessControlAllowOrigin;
        }

        public void setAccessControlExposeHeaders(String accessControlExposeHeaders) {
            this.accessControlExposeHeaders = accessControlExposeHeaders;
        }

        @ParamAnnotation(paramType="header", paramName="Access-Control-Expose-Headers")
        public String getAccessControlExposeHeaders() {
            return this.accessControlExposeHeaders;
        }

        public void setAccessControlMaxAge(String accessControlMaxAge) {
            this.accessControlMaxAge = accessControlMaxAge;
        }

        @ParamAnnotation(paramType="header", paramName="Access-Control-Max-Age")
        public String getAccessControlMaxAge() {
            return this.accessControlMaxAge;
        }
    }

    public static class OptionsObjectInput
    extends RequestInputModel {
        private String accessControlRequestHeaders;
        private String accessControlRequestMethod;
        private String origin;

        public void setAccessControlRequestHeaders(String accessControlRequestHeaders) {
            this.accessControlRequestHeaders = accessControlRequestHeaders;
        }

        @ParamAnnotation(paramType="header", paramName="Access-Control-Request-Headers")
        public String getAccessControlRequestHeaders() {
            return this.accessControlRequestHeaders;
        }

        public void setAccessControlRequestMethod(String accessControlRequestMethod) {
            this.accessControlRequestMethod = accessControlRequestMethod;
        }

        @ParamAnnotation(paramType="header", paramName="Access-Control-Request-Method")
        public String getAccessControlRequestMethod() {
            return this.accessControlRequestMethod;
        }

        public void setOrigin(String origin) {
            this.origin = origin;
        }

        @ParamAnnotation(paramType="header", paramName="Origin")
        public String getOrigin() {
            return this.origin;
        }

        @Override
        public String validateParam() {
            if (QSStringUtil.isEmpty(this.getAccessControlRequestMethod())) {
                return QSStringUtil.getParameterRequired("AccessControlRequestMethod", "OptionsObjectInput");
            }
            if (QSStringUtil.isEmpty(this.getOrigin())) {
                return QSStringUtil.getParameterRequired("Origin", "OptionsObjectInput");
            }
            return null;
        }
    }

    public static class ListMultipartOutput
    extends OutputModel {
        private Integer count;
        private List<Types.ObjectPartModel> objectParts;

        public void setCount(Integer count) {
            this.count = count;
        }

        @ParamAnnotation(paramType="query", paramName="count")
        public Integer getCount() {
            return this.count;
        }

        public void setObjectParts(List<Types.ObjectPartModel> objectParts) {
            this.objectParts = objectParts;
        }

        @ParamAnnotation(paramType="query", paramName="object_parts")
        public List<Types.ObjectPartModel> getObjectParts() {
            return this.objectParts;
        }
    }

    public static class ListMultipartInput
    extends RequestInputModel {
        private Integer limit;
        private Integer partNumberMarker;
        private String uploadID;

        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @ParamAnnotation(paramType="query", paramName="limit")
        public Integer getLimit() {
            return this.limit;
        }

        public void setPartNumberMarker(Integer partNumberMarker) {
            this.partNumberMarker = partNumberMarker;
        }

        @ParamAnnotation(paramType="query", paramName="part_number_marker")
        public Integer getPartNumberMarker() {
            return this.partNumberMarker;
        }

        public void setUploadID(String uploadID) {
            this.uploadID = uploadID;
        }

        @ParamAnnotation(paramType="query", paramName="upload_id")
        public String getUploadID() {
            return this.uploadID;
        }

        @Override
        public String validateParam() {
            if (QSStringUtil.isEmpty(this.getUploadID())) {
                return QSStringUtil.getParameterRequired("UploadID", "ListMultipartInput");
            }
            return null;
        }
    }

    public static class InitiateMultipartUploadOutput
    extends OutputModel {
        private String bucket;
        private String key;
        private String uploadID;
        private String xQSEncryptionCustomerAlgorithm;

        public void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @ParamAnnotation(paramType="query", paramName="bucket")
        public String getBucket() {
            return this.bucket;
        }

        public void setKey(String key) {
            this.key = key;
        }

        @ParamAnnotation(paramType="query", paramName="key")
        public String getKey() {
            return this.key;
        }

        public void setUploadID(String uploadID) {
            this.uploadID = uploadID;
        }

        @ParamAnnotation(paramType="query", paramName="upload_id")
        public String getUploadID() {
            return this.uploadID;
        }

        public void setXQSEncryptionCustomerAlgorithm(String xQSEncryptionCustomerAlgorithm) {
            this.xQSEncryptionCustomerAlgorithm = xQSEncryptionCustomerAlgorithm;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Encryption-Customer-Algorithm")
        public String getXQSEncryptionCustomerAlgorithm() {
            return this.xQSEncryptionCustomerAlgorithm;
        }
    }

    public static class InitiateMultipartUploadInput
    extends RequestInputModel {
        private String contentType;
        private String xQSEncryptionCustomerAlgorithm;
        private String xQSEncryptionCustomerKey;
        private String xQSEncryptionCustomerKeyMD5;
        private String xQSStorageClass;

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @ParamAnnotation(paramType="header", paramName="Content-Type")
        public String getContentType() {
            return this.contentType;
        }

        public void setXQSEncryptionCustomerAlgorithm(String xQSEncryptionCustomerAlgorithm) {
            this.xQSEncryptionCustomerAlgorithm = xQSEncryptionCustomerAlgorithm;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Encryption-Customer-Algorithm")
        public String getXQSEncryptionCustomerAlgorithm() {
            return this.xQSEncryptionCustomerAlgorithm;
        }

        public void setXQSEncryptionCustomerKey(String xQSEncryptionCustomerKey) {
            this.xQSEncryptionCustomerKey = xQSEncryptionCustomerKey;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Encryption-Customer-Key")
        public String getXQSEncryptionCustomerKey() {
            return this.xQSEncryptionCustomerKey;
        }

        public void setXQSEncryptionCustomerKeyMD5(String xQSEncryptionCustomerKeyMD5) {
            this.xQSEncryptionCustomerKeyMD5 = xQSEncryptionCustomerKeyMD5;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Encryption-Customer-Key-MD5")
        public String getXQSEncryptionCustomerKeyMD5() {
            return this.xQSEncryptionCustomerKeyMD5;
        }

        public void setXQSStorageClass(String xQSStorageClass) {
            this.xQSStorageClass = xQSStorageClass;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Storage-Class")
        public String getXQSStorageClass() {
            return this.xQSStorageClass;
        }

        @Override
        public String validateParam() {
            String[] xQSStorageClassValidValues = new String[]{"STANDARD", "STANDARD_IA"};
            boolean xQSStorageClassIsValid = false;
            String value = this.getXQSStorageClass();
            if (null == value || "".equals(value)) {
                xQSStorageClassIsValid = true;
            } else {
                for (String v : xQSStorageClassValidValues) {
                    if (!v.equals(value)) continue;
                    xQSStorageClassIsValid = true;
                }
            }
            if (!xQSStorageClassIsValid) {
                return QSStringUtil.getParameterValueNotAllowedError("XQSStorageClass", this.getXQSStorageClass() + "", xQSStorageClassValidValues);
            }
            return null;
        }
    }

    public static class ImageProcessOutput
    extends OutputModel {
        private InputStream bodyInputStream;
        private Long contentLength;

        @ParamAnnotation(paramType="body", paramName="BodyInputStream")
        public InputStream getBodyInputStream() {
            return this.bodyInputStream;
        }

        public void setBodyInputStream(InputStream bodyInputStream) {
            this.bodyInputStream = bodyInputStream;
        }

        public void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        @ParamAnnotation(paramType="header", paramName="Content-Length")
        public Long getContentLength() {
            return this.contentLength;
        }
    }

    public static class ImageProcessInput
    extends RequestInputModel {
        private String action;
        private String responseCacheControl;
        private String responseContentDisposition;
        private String responseContentEncoding;
        private String responseContentLanguage;
        private String responseContentType;
        private String responseExpires;
        private String ifModifiedSince;

        public void setAction(String action) {
            this.action = action;
        }

        @ParamAnnotation(paramType="query", paramName="action")
        public String getAction() {
            return this.action;
        }

        public void setResponseCacheControl(String responseCacheControl) {
            this.responseCacheControl = responseCacheControl;
        }

        @ParamAnnotation(paramType="query", paramName="response-cache-control")
        public String getResponseCacheControl() {
            return this.responseCacheControl;
        }

        public void setResponseContentDisposition(String responseContentDisposition) {
            this.responseContentDisposition = responseContentDisposition;
        }

        @ParamAnnotation(paramType="query", paramName="response-content-disposition")
        public String getResponseContentDisposition() {
            return this.responseContentDisposition;
        }

        public void setResponseContentEncoding(String responseContentEncoding) {
            this.responseContentEncoding = responseContentEncoding;
        }

        @ParamAnnotation(paramType="query", paramName="response-content-encoding")
        public String getResponseContentEncoding() {
            return this.responseContentEncoding;
        }

        public void setResponseContentLanguage(String responseContentLanguage) {
            this.responseContentLanguage = responseContentLanguage;
        }

        @ParamAnnotation(paramType="query", paramName="response-content-language")
        public String getResponseContentLanguage() {
            return this.responseContentLanguage;
        }

        public void setResponseContentType(String responseContentType) {
            this.responseContentType = responseContentType;
        }

        @ParamAnnotation(paramType="query", paramName="response-content-type")
        public String getResponseContentType() {
            return this.responseContentType;
        }

        public void setResponseExpires(String responseExpires) {
            this.responseExpires = responseExpires;
        }

        @ParamAnnotation(paramType="query", paramName="response-expires")
        public String getResponseExpires() {
            return this.responseExpires;
        }

        public void setIfModifiedSince(String ifModifiedSince) {
            this.ifModifiedSince = ifModifiedSince;
        }

        @ParamAnnotation(paramType="header", paramName="If-Modified-Since")
        public String getIfModifiedSince() {
            return this.ifModifiedSince;
        }

        @Override
        public String validateParam() {
            if (QSStringUtil.isEmpty(this.getAction())) {
                return QSStringUtil.getParameterRequired("Action", "ImageProcessInput");
            }
            return null;
        }
    }

    public static class HeadObjectOutput
    extends OutputModel {
        private Long contentLength;
        private String contentType;
        private String eTag;
        private String lastModified;
        private String xQSEncryptionCustomerAlgorithm;
        private String xQSStorageClass;

        public void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        @ParamAnnotation(paramType="header", paramName="Content-Length")
        public Long getContentLength() {
            return this.contentLength;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @ParamAnnotation(paramType="header", paramName="Content-Type")
        public String getContentType() {
            return this.contentType;
        }

        public void setETag(String eTag) {
            this.eTag = eTag;
        }

        @ParamAnnotation(paramType="header", paramName="ETag")
        public String getETag() {
            return this.eTag;
        }

        public void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        @ParamAnnotation(paramType="header", paramName="Last-Modified")
        public String getLastModified() {
            return this.lastModified;
        }

        public void setXQSEncryptionCustomerAlgorithm(String xQSEncryptionCustomerAlgorithm) {
            this.xQSEncryptionCustomerAlgorithm = xQSEncryptionCustomerAlgorithm;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Encryption-Customer-Algorithm")
        public String getXQSEncryptionCustomerAlgorithm() {
            return this.xQSEncryptionCustomerAlgorithm;
        }

        public void setXQSStorageClass(String xQSStorageClass) {
            this.xQSStorageClass = xQSStorageClass;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Storage-Class")
        public String getXQSStorageClass() {
            return this.xQSStorageClass;
        }
    }

    public static class HeadObjectInput
    extends RequestInputModel {
        private String ifMatch;
        private String ifModifiedSince;
        private String ifNoneMatch;
        private String ifUnmodifiedSince;
        private String xQSEncryptionCustomerAlgorithm;
        private String xQSEncryptionCustomerKey;
        private String xQSEncryptionCustomerKeyMD5;

        public void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @ParamAnnotation(paramType="header", paramName="If-Match")
        public String getIfMatch() {
            return this.ifMatch;
        }

        public void setIfModifiedSince(String ifModifiedSince) {
            this.ifModifiedSince = ifModifiedSince;
        }

        @ParamAnnotation(paramType="header", paramName="If-Modified-Since")
        public String getIfModifiedSince() {
            return this.ifModifiedSince;
        }

        public void setIfNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
        }

        @ParamAnnotation(paramType="header", paramName="If-None-Match")
        public String getIfNoneMatch() {
            return this.ifNoneMatch;
        }

        public void setIfUnmodifiedSince(String ifUnmodifiedSince) {
            this.ifUnmodifiedSince = ifUnmodifiedSince;
        }

        @ParamAnnotation(paramType="header", paramName="If-Unmodified-Since")
        public String getIfUnmodifiedSince() {
            return this.ifUnmodifiedSince;
        }

        public void setXQSEncryptionCustomerAlgorithm(String xQSEncryptionCustomerAlgorithm) {
            this.xQSEncryptionCustomerAlgorithm = xQSEncryptionCustomerAlgorithm;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Encryption-Customer-Algorithm")
        public String getXQSEncryptionCustomerAlgorithm() {
            return this.xQSEncryptionCustomerAlgorithm;
        }

        public void setXQSEncryptionCustomerKey(String xQSEncryptionCustomerKey) {
            this.xQSEncryptionCustomerKey = xQSEncryptionCustomerKey;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Encryption-Customer-Key")
        public String getXQSEncryptionCustomerKey() {
            return this.xQSEncryptionCustomerKey;
        }

        public void setXQSEncryptionCustomerKeyMD5(String xQSEncryptionCustomerKeyMD5) {
            this.xQSEncryptionCustomerKeyMD5 = xQSEncryptionCustomerKeyMD5;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Encryption-Customer-Key-MD5")
        public String getXQSEncryptionCustomerKeyMD5() {
            return this.xQSEncryptionCustomerKeyMD5;
        }

        @Override
        public String validateParam() {
            return null;
        }
    }

    public static class GetObjectOutput
    extends OutputModel {
        private InputStream bodyInputStream;
        private String cacheControl;
        private String contentDisposition;
        private String contentEncoding;
        private String contentLanguage;
        private Long contentLength;
        private String contentRange;
        private String contentType;
        private String eTag;
        private String expires;
        private String lastModified;
        private String xQSEncryptionCustomerAlgorithm;
        private String xQSStorageClass;

        @Deprecated
        public void setResponseCacheControl(String responseCacheControl) {
            this.cacheControl = responseCacheControl;
        }

        @Deprecated
        public String getResponseCacheControl() {
            return this.cacheControl;
        }

        @Deprecated
        public void setResponseContentDisposition(String responseContentDisposition) {
            this.contentDisposition = responseContentDisposition;
        }

        @Deprecated
        public String getResponseContentDisposition() {
            return this.contentDisposition;
        }

        @Deprecated
        public void setResponseContentEncoding(String responseContentEncoding) {
            this.contentEncoding = responseContentEncoding;
        }

        @Deprecated
        public String getResponseContentEncoding() {
            return this.contentEncoding;
        }

        @Deprecated
        public void setResponseContentLanguage(String responseContentLanguage) {
            this.contentLanguage = responseContentLanguage;
        }

        @Deprecated
        public String getResponseContentLanguage() {
            return this.contentLanguage;
        }

        @Deprecated
        public void setResponseContentType(String responseContentType) {
            this.contentType = responseContentType;
        }

        @Deprecated
        public String getResponseContentType() {
            return this.contentType;
        }

        @Deprecated
        public void setResponseExpires(String responseExpires) {
            this.expires = responseExpires;
        }

        @Deprecated
        public String getResponseExpires() {
            return this.expires;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInputStream")
        public InputStream getBodyInputStream() {
            return this.bodyInputStream;
        }

        public void setBodyInputStream(InputStream bodyInputStream) {
            this.bodyInputStream = bodyInputStream;
        }

        public void setCacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
        }

        @ParamAnnotation(paramType="header", paramName="Cache-Control")
        public String getCacheControl() {
            return this.cacheControl;
        }

        public void setContentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
        }

        @ParamAnnotation(paramType="header", paramName="Content-Disposition")
        public String getContentDisposition() {
            return this.contentDisposition;
        }

        public void setContentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
        }

        @ParamAnnotation(paramType="header", paramName="Content-Encoding")
        public String getContentEncoding() {
            return this.contentEncoding;
        }

        public void setContentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
        }

        @ParamAnnotation(paramType="header", paramName="Content-Language")
        public String getContentLanguage() {
            return this.contentLanguage;
        }

        public void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        @ParamAnnotation(paramType="header", paramName="Content-Length")
        public Long getContentLength() {
            return this.contentLength;
        }

        public void setContentRange(String contentRange) {
            this.contentRange = contentRange;
        }

        @ParamAnnotation(paramType="header", paramName="Content-Range")
        public String getContentRange() {
            return this.contentRange;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @ParamAnnotation(paramType="header", paramName="Content-Type")
        public String getContentType() {
            return this.contentType;
        }

        public void setETag(String eTag) {
            this.eTag = eTag;
        }

        @ParamAnnotation(paramType="header", paramName="ETag")
        public String getETag() {
            return this.eTag;
        }

        public void setExpires(String expires) {
            this.expires = expires;
        }

        @ParamAnnotation(paramType="header", paramName="Expires")
        public String getExpires() {
            return this.expires;
        }

        public void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        @ParamAnnotation(paramType="header", paramName="Last-Modified")
        public String getLastModified() {
            return this.lastModified;
        }

        public void setXQSEncryptionCustomerAlgorithm(String xQSEncryptionCustomerAlgorithm) {
            this.xQSEncryptionCustomerAlgorithm = xQSEncryptionCustomerAlgorithm;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Encryption-Customer-Algorithm")
        public String getXQSEncryptionCustomerAlgorithm() {
            return this.xQSEncryptionCustomerAlgorithm;
        }

        public void setXQSStorageClass(String xQSStorageClass) {
            this.xQSStorageClass = xQSStorageClass;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Storage-Class")
        public String getXQSStorageClass() {
            return this.xQSStorageClass;
        }
    }

    public static class GetObjectInput
    extends RequestInputModel {
        private String responseCacheControl;
        private String responseContentDisposition;
        private String responseContentEncoding;
        private String responseContentLanguage;
        private String responseContentType;
        private String responseExpires;
        private String ifMatch;
        private String ifModifiedSince;
        private String ifNoneMatch;
        private String ifUnmodifiedSince;
        private String range;
        private String xQSEncryptionCustomerAlgorithm;
        private String xQSEncryptionCustomerKey;
        private String xQSEncryptionCustomerKeyMD5;

        public void setResponseCacheControl(String responseCacheControl) {
            this.responseCacheControl = responseCacheControl;
        }

        @ParamAnnotation(paramType="query", paramName="response-cache-control")
        public String getResponseCacheControl() {
            return this.responseCacheControl;
        }

        public void setResponseContentDisposition(String responseContentDisposition) {
            this.responseContentDisposition = responseContentDisposition;
        }

        @ParamAnnotation(paramType="query", paramName="response-content-disposition")
        public String getResponseContentDisposition() {
            return this.responseContentDisposition;
        }

        public void setResponseContentEncoding(String responseContentEncoding) {
            this.responseContentEncoding = responseContentEncoding;
        }

        @ParamAnnotation(paramType="query", paramName="response-content-encoding")
        public String getResponseContentEncoding() {
            return this.responseContentEncoding;
        }

        public void setResponseContentLanguage(String responseContentLanguage) {
            this.responseContentLanguage = responseContentLanguage;
        }

        @ParamAnnotation(paramType="query", paramName="response-content-language")
        public String getResponseContentLanguage() {
            return this.responseContentLanguage;
        }

        public void setResponseContentType(String responseContentType) {
            this.responseContentType = responseContentType;
        }

        @ParamAnnotation(paramType="query", paramName="response-content-type")
        public String getResponseContentType() {
            return this.responseContentType;
        }

        public void setResponseExpires(String responseExpires) {
            this.responseExpires = responseExpires;
        }

        @ParamAnnotation(paramType="query", paramName="response-expires")
        public String getResponseExpires() {
            return this.responseExpires;
        }

        public void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @ParamAnnotation(paramType="header", paramName="If-Match")
        public String getIfMatch() {
            return this.ifMatch;
        }

        public void setIfModifiedSince(String ifModifiedSince) {
            this.ifModifiedSince = ifModifiedSince;
        }

        @ParamAnnotation(paramType="header", paramName="If-Modified-Since")
        public String getIfModifiedSince() {
            return this.ifModifiedSince;
        }

        public void setIfNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
        }

        @ParamAnnotation(paramType="header", paramName="If-None-Match")
        public String getIfNoneMatch() {
            return this.ifNoneMatch;
        }

        public void setIfUnmodifiedSince(String ifUnmodifiedSince) {
            this.ifUnmodifiedSince = ifUnmodifiedSince;
        }

        @ParamAnnotation(paramType="header", paramName="If-Unmodified-Since")
        public String getIfUnmodifiedSince() {
            return this.ifUnmodifiedSince;
        }

        public void setRange(String range) {
            this.range = range;
        }

        @ParamAnnotation(paramType="header", paramName="Range")
        public String getRange() {
            return this.range;
        }

        public void setXQSEncryptionCustomerAlgorithm(String xQSEncryptionCustomerAlgorithm) {
            this.xQSEncryptionCustomerAlgorithm = xQSEncryptionCustomerAlgorithm;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Encryption-Customer-Algorithm")
        public String getXQSEncryptionCustomerAlgorithm() {
            return this.xQSEncryptionCustomerAlgorithm;
        }

        public void setXQSEncryptionCustomerKey(String xQSEncryptionCustomerKey) {
            this.xQSEncryptionCustomerKey = xQSEncryptionCustomerKey;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Encryption-Customer-Key")
        public String getXQSEncryptionCustomerKey() {
            return this.xQSEncryptionCustomerKey;
        }

        public void setXQSEncryptionCustomerKeyMD5(String xQSEncryptionCustomerKeyMD5) {
            this.xQSEncryptionCustomerKeyMD5 = xQSEncryptionCustomerKeyMD5;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Encryption-Customer-Key-MD5")
        public String getXQSEncryptionCustomerKeyMD5() {
            return this.xQSEncryptionCustomerKeyMD5;
        }

        @Override
        public String validateParam() {
            return null;
        }
    }

    public static class DeleteObjectOutput
    extends OutputModel {
    }

    public static class CompleteMultipartUploadOutput
    extends OutputModel {
        private String xQSEncryptionCustomerAlgorithm;

        public void setXQSEncryptionCustomerAlgorithm(String xQSEncryptionCustomerAlgorithm) {
            this.xQSEncryptionCustomerAlgorithm = xQSEncryptionCustomerAlgorithm;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Encryption-Customer-Algorithm")
        public String getXQSEncryptionCustomerAlgorithm() {
            return this.xQSEncryptionCustomerAlgorithm;
        }
    }

    public static class CompleteMultipartUploadInput
    extends RequestInputModel {
        private String uploadID;
        private String eTag;
        private String xQSEncryptionCustomerAlgorithm;
        private String xQSEncryptionCustomerKey;
        private String xQSEncryptionCustomerKeyMD5;
        private String bodyInput;
        private List<Types.ObjectPartModel> objectParts;

        public void setUploadID(String uploadID) {
            this.uploadID = uploadID;
        }

        @ParamAnnotation(paramType="query", paramName="upload_id")
        public String getUploadID() {
            return this.uploadID;
        }

        public CompleteMultipartUploadInput() {
        }

        public CompleteMultipartUploadInput(String multipart_upload_id, int partsCount, int startIndex) {
            this.setUploadID(multipart_upload_id);
            this.setBodyInput(this.getCompleteMultipartUploadContent(partsCount, startIndex));
        }

        public String getCompleteMultipartUploadContent(int partsCount, int startIndex) {
            if (partsCount < 1 || startIndex < 0) {
                return null;
            }
            StringBuilder uploadJson = new StringBuilder("{\"object_parts\":[");
            for (int i = 0; i < partsCount; ++i) {
                uploadJson.append("{\"part_number\":").append(startIndex++).append("}");
                if (i < partsCount - 1) {
                    uploadJson.append(",");
                    continue;
                }
                uploadJson.append("]}");
            }
            return uploadJson.toString();
        }

        public void setETag(String eTag) {
            this.eTag = eTag;
        }

        @ParamAnnotation(paramType="header", paramName="ETag")
        public String getETag() {
            return this.eTag;
        }

        public void setXQSEncryptionCustomerAlgorithm(String xQSEncryptionCustomerAlgorithm) {
            this.xQSEncryptionCustomerAlgorithm = xQSEncryptionCustomerAlgorithm;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Encryption-Customer-Algorithm")
        public String getXQSEncryptionCustomerAlgorithm() {
            return this.xQSEncryptionCustomerAlgorithm;
        }

        public void setXQSEncryptionCustomerKey(String xQSEncryptionCustomerKey) {
            this.xQSEncryptionCustomerKey = xQSEncryptionCustomerKey;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Encryption-Customer-Key")
        public String getXQSEncryptionCustomerKey() {
            return this.xQSEncryptionCustomerKey;
        }

        public void setXQSEncryptionCustomerKeyMD5(String xQSEncryptionCustomerKeyMD5) {
            this.xQSEncryptionCustomerKeyMD5 = xQSEncryptionCustomerKeyMD5;
        }

        @ParamAnnotation(paramType="header", paramName="X-QS-Encryption-Customer-Key-MD5")
        public String getXQSEncryptionCustomerKeyMD5() {
            return this.xQSEncryptionCustomerKeyMD5;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInput")
        public String getBodyInput() {
            return this.bodyInput;
        }

        public void setBodyInput(String bodyInput) {
            this.bodyInput = bodyInput;
        }

        public void setObjectParts(List<Types.ObjectPartModel> objectParts) {
            this.objectParts = objectParts;
        }

        @ParamAnnotation(paramType="body", paramName="object_parts")
        public List<Types.ObjectPartModel> getObjectParts() {
            return this.objectParts;
        }

        @Override
        public String validateParam() {
            if (QSStringUtil.isEmpty(this.getUploadID())) {
                return QSStringUtil.getParameterRequired("UploadID", "CompleteMultipartUploadInput");
            }
            if (this.getObjectParts() != null && this.getObjectParts().size() > 0) {
                for (int i = 0; i < this.getObjectParts().size(); ++i) {
                    String vValidate = this.getObjectParts().get(i).validateParam();
                    if (QSStringUtil.isEmpty(vValidate)) continue;
                    return vValidate;
                }
            }
            return null;
        }
    }

    public static class AbortMultipartUploadOutput
    extends OutputModel {
    }

    public static class AbortMultipartUploadInput
    extends RequestInputModel {
        private String uploadID;

        public void setUploadID(String uploadID) {
            this.uploadID = uploadID;
        }

        @ParamAnnotation(paramType="query", paramName="upload_id")
        public String getUploadID() {
            return this.uploadID;
        }

        @Override
        public String validateParam() {
            if (QSStringUtil.isEmpty(this.getUploadID())) {
                return QSStringUtil.getParameterRequired("UploadID", "AbortMultipartUploadInput");
            }
            return null;
        }
    }

    public static class PutBucketPolicyOutput
    extends OutputModel {
    }

    public static class PutBucketPolicyInput
    extends RequestInputModel {
        private String bodyInput;
        private List<Types.StatementModel> statement;

        @ParamAnnotation(paramType="body", paramName="BodyInput")
        public String getBodyInput() {
            return this.bodyInput;
        }

        public void setBodyInput(String bodyInput) {
            this.bodyInput = bodyInput;
        }

        public void setStatement(List<Types.StatementModel> statement) {
            this.statement = statement;
        }

        @ParamAnnotation(paramType="body", paramName="statement")
        public List<Types.StatementModel> getStatement() {
            return this.statement;
        }

        @Override
        public String validateParam() {
            if (this.getStatement() != null && this.getStatement().size() > 0) {
                for (int i = 0; i < this.getStatement().size(); ++i) {
                    String vValidate = this.getStatement().get(i).validateParam();
                    if (QSStringUtil.isEmpty(vValidate)) continue;
                    return vValidate;
                }
            }
            return null;
        }
    }

    public static class PutBucketNotificationOutput
    extends OutputModel {
    }

    public static class PutBucketNotificationInput
    extends RequestInputModel {
        private String bodyInput;
        private List<Types.NotificationModel> notifications;

        @ParamAnnotation(paramType="body", paramName="BodyInput")
        public String getBodyInput() {
            return this.bodyInput;
        }

        public void setBodyInput(String bodyInput) {
            this.bodyInput = bodyInput;
        }

        public void setNotifications(List<Types.NotificationModel> notifications) {
            this.notifications = notifications;
        }

        @ParamAnnotation(paramType="body", paramName="notifications")
        public List<Types.NotificationModel> getNotifications() {
            return this.notifications;
        }

        @Override
        public String validateParam() {
            if (this.getNotifications() != null && this.getNotifications().size() > 0) {
                for (int i = 0; i < this.getNotifications().size(); ++i) {
                    String vValidate = this.getNotifications().get(i).validateParam();
                    if (QSStringUtil.isEmpty(vValidate)) continue;
                    return vValidate;
                }
            }
            return null;
        }
    }

    public static class PutBucketLifecycleOutput
    extends OutputModel {
    }

    public static class PutBucketLifecycleInput
    extends RequestInputModel {
        private String bodyInput;
        private List<Types.RuleModel> rule;

        @ParamAnnotation(paramType="body", paramName="BodyInput")
        public String getBodyInput() {
            return this.bodyInput;
        }

        public void setBodyInput(String bodyInput) {
            this.bodyInput = bodyInput;
        }

        public void setRule(List<Types.RuleModel> rule) {
            this.rule = rule;
        }

        @ParamAnnotation(paramType="body", paramName="rule")
        public List<Types.RuleModel> getRule() {
            return this.rule;
        }

        @Override
        public String validateParam() {
            if (this.getRule() != null && this.getRule().size() > 0) {
                for (int i = 0; i < this.getRule().size(); ++i) {
                    String vValidate = this.getRule().get(i).validateParam();
                    if (QSStringUtil.isEmpty(vValidate)) continue;
                    return vValidate;
                }
            }
            return null;
        }
    }

    public static class PutBucketExternalMirrorOutput
    extends OutputModel {
    }

    public static class PutBucketExternalMirrorInput
    extends RequestInputModel {
        private String bodyInput;
        private String sourceSite;

        @ParamAnnotation(paramType="body", paramName="BodyInput")
        public String getBodyInput() {
            return this.bodyInput;
        }

        public void setBodyInput(String bodyInput) {
            this.bodyInput = bodyInput;
        }

        public void setSourceSite(String sourceSite) {
            this.sourceSite = sourceSite;
        }

        @ParamAnnotation(paramType="body", paramName="source_site")
        public String getSourceSite() {
            return this.sourceSite;
        }

        @Override
        public String validateParam() {
            if (QSStringUtil.isEmpty(this.getSourceSite())) {
                return QSStringUtil.getParameterRequired("SourceSite", "PutBucketExternalMirrorInput");
            }
            return null;
        }
    }

    public static class PutBucketCORSOutput
    extends OutputModel {
    }

    public static class PutBucketCORSInput
    extends RequestInputModel {
        private String bodyInput;
        private List<Types.CORSRuleModel> cORSRules;

        @ParamAnnotation(paramType="body", paramName="BodyInput")
        public String getBodyInput() {
            return this.bodyInput;
        }

        public void setBodyInput(String bodyInput) {
            this.bodyInput = bodyInput;
        }

        public void setCORSRules(List<Types.CORSRuleModel> cORSRules) {
            this.cORSRules = cORSRules;
        }

        @ParamAnnotation(paramType="body", paramName="cors_rules")
        public List<Types.CORSRuleModel> getCORSRules() {
            return this.cORSRules;
        }

        @Override
        public String validateParam() {
            if (this.getCORSRules() != null && this.getCORSRules().size() > 0) {
                for (int i = 0; i < this.getCORSRules().size(); ++i) {
                    String vValidate = this.getCORSRules().get(i).validateParam();
                    if (QSStringUtil.isEmpty(vValidate)) continue;
                    return vValidate;
                }
            }
            return null;
        }
    }

    public static class PutBucketACLOutput
    extends OutputModel {
    }

    public static class PutBucketACLInput
    extends RequestInputModel {
        private String bodyInput;
        private List<Types.ACLModel> aCL;

        @ParamAnnotation(paramType="body", paramName="BodyInput")
        public String getBodyInput() {
            return this.bodyInput;
        }

        public void setBodyInput(String bodyInput) {
            this.bodyInput = bodyInput;
        }

        public void setACL(List<Types.ACLModel> aCL) {
            this.aCL = aCL;
        }

        @ParamAnnotation(paramType="body", paramName="acl")
        public List<Types.ACLModel> getACL() {
            return this.aCL;
        }

        @Override
        public String validateParam() {
            if (this.getACL() != null && this.getACL().size() > 0) {
                for (int i = 0; i < this.getACL().size(); ++i) {
                    String vValidate = this.getACL().get(i).validateParam();
                    if (QSStringUtil.isEmpty(vValidate)) continue;
                    return vValidate;
                }
            }
            return null;
        }
    }

    public static class PutBucketOutput
    extends OutputModel {
    }

    public static class ListObjectsOutput
    extends OutputModel {
        private List<String> commonPrefixes;
        private String delimiter;
        private Boolean hasMore;
        private List<Types.KeyModel> keys;
        private Integer limit;
        private String marker;
        private String name;
        private String nextMarker;
        private Types.OwnerModel owner;
        private String prefix;

        public void setCommonPrefixes(List<String> commonPrefixes) {
            this.commonPrefixes = commonPrefixes;
        }

        @ParamAnnotation(paramType="query", paramName="common_prefixes")
        public List<String> getCommonPrefixes() {
            return this.commonPrefixes;
        }

        public void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        @ParamAnnotation(paramType="query", paramName="delimiter")
        public String getDelimiter() {
            return this.delimiter;
        }

        public void setHasMore(Boolean hasMore) {
            this.hasMore = hasMore;
        }

        @ParamAnnotation(paramType="query", paramName="has_more")
        public Boolean getHasMore() {
            return this.hasMore;
        }

        public void setKeys(List<Types.KeyModel> keys) {
            this.keys = keys;
        }

        @ParamAnnotation(paramType="query", paramName="keys")
        public List<Types.KeyModel> getKeys() {
            return this.keys;
        }

        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @ParamAnnotation(paramType="query", paramName="limit")
        public Integer getLimit() {
            return this.limit;
        }

        public void setMarker(String marker) {
            this.marker = marker;
        }

        @ParamAnnotation(paramType="query", paramName="marker")
        public String getMarker() {
            return this.marker;
        }

        public void setName(String name) {
            this.name = name;
        }

        @ParamAnnotation(paramType="query", paramName="name")
        public String getName() {
            return this.name;
        }

        public void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @ParamAnnotation(paramType="query", paramName="next_marker")
        public String getNextMarker() {
            return this.nextMarker;
        }

        public void setOwner(Types.OwnerModel owner) {
            this.owner = owner;
        }

        @ParamAnnotation(paramType="query", paramName="owner")
        public Types.OwnerModel getOwner() {
            return this.owner;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @ParamAnnotation(paramType="query", paramName="prefix")
        public String getPrefix() {
            return this.prefix;
        }
    }

    public static class ListObjectsInput
    extends RequestInputModel {
        private String delimiter;
        private Integer limit;
        private String marker;
        private String prefix;

        public void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        @ParamAnnotation(paramType="query", paramName="delimiter")
        public String getDelimiter() {
            return this.delimiter;
        }

        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @ParamAnnotation(paramType="query", paramName="limit")
        public Integer getLimit() {
            return this.limit;
        }

        public void setMarker(String marker) {
            this.marker = marker;
        }

        @ParamAnnotation(paramType="query", paramName="marker")
        public String getMarker() {
            return this.marker;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @ParamAnnotation(paramType="query", paramName="prefix")
        public String getPrefix() {
            return this.prefix;
        }

        @Override
        public String validateParam() {
            return null;
        }
    }

    public static class ListMultipartUploadsOutput
    extends OutputModel {
        private List<String> commonPrefixes;
        private String delimiter;
        private Integer limit;
        private String marker;
        private String name;
        private String nextKeyMarker;
        private String nextUploadIDMarker;
        private String prefix;
        private List<Types.UploadsModel> uploads;

        public void setCommonPrefixes(List<String> commonPrefixes) {
            this.commonPrefixes = commonPrefixes;
        }

        @ParamAnnotation(paramType="query", paramName="common_prefixes")
        public List<String> getCommonPrefixes() {
            return this.commonPrefixes;
        }

        public void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        @ParamAnnotation(paramType="query", paramName="delimiter")
        public String getDelimiter() {
            return this.delimiter;
        }

        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @ParamAnnotation(paramType="query", paramName="limit")
        public Integer getLimit() {
            return this.limit;
        }

        public void setMarker(String marker) {
            this.marker = marker;
        }

        @ParamAnnotation(paramType="query", paramName="marker")
        public String getMarker() {
            return this.marker;
        }

        public void setName(String name) {
            this.name = name;
        }

        @ParamAnnotation(paramType="query", paramName="name")
        public String getName() {
            return this.name;
        }

        public void setNextKeyMarker(String nextKeyMarker) {
            this.nextKeyMarker = nextKeyMarker;
        }

        @ParamAnnotation(paramType="query", paramName="next_key_marker")
        public String getNextKeyMarker() {
            return this.nextKeyMarker;
        }

        public void setNextUploadIDMarker(String nextUploadIDMarker) {
            this.nextUploadIDMarker = nextUploadIDMarker;
        }

        @ParamAnnotation(paramType="query", paramName="next_upload_id_marker")
        public String getNextUploadIDMarker() {
            return this.nextUploadIDMarker;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @ParamAnnotation(paramType="query", paramName="prefix")
        public String getPrefix() {
            return this.prefix;
        }

        public void setUploads(List<Types.UploadsModel> uploads) {
            this.uploads = uploads;
        }

        @ParamAnnotation(paramType="query", paramName="uploads")
        public List<Types.UploadsModel> getUploads() {
            return this.uploads;
        }
    }

    public static class ListMultipartUploadsInput
    extends RequestInputModel {
        private String delimiter;
        private String keyMarker;
        private Integer limit;
        private String prefix;
        private String uploadIDMarker;

        public void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        @ParamAnnotation(paramType="query", paramName="delimiter")
        public String getDelimiter() {
            return this.delimiter;
        }

        public void setKeyMarker(String keyMarker) {
            this.keyMarker = keyMarker;
        }

        @ParamAnnotation(paramType="query", paramName="key_marker")
        public String getKeyMarker() {
            return this.keyMarker;
        }

        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        @ParamAnnotation(paramType="query", paramName="limit")
        public Integer getLimit() {
            return this.limit;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @ParamAnnotation(paramType="query", paramName="prefix")
        public String getPrefix() {
            return this.prefix;
        }

        public void setUploadIDMarker(String uploadIDMarker) {
            this.uploadIDMarker = uploadIDMarker;
        }

        @ParamAnnotation(paramType="query", paramName="upload_id_marker")
        public String getUploadIDMarker() {
            return this.uploadIDMarker;
        }

        @Override
        public String validateParam() {
            return null;
        }
    }

    public static class HeadBucketOutput
    extends OutputModel {
    }

    public static class GetBucketStatisticsOutput
    extends OutputModel {
        private Long count;
        private String created;
        private String location;
        private String name;
        private Long size;
        private String status;
        private String uRL;

        public void setCount(Long count) {
            this.count = count;
        }

        @ParamAnnotation(paramType="query", paramName="count")
        public Long getCount() {
            return this.count;
        }

        public void setCreated(String created) {
            this.created = created;
        }

        @ParamAnnotation(paramType="query", paramName="created")
        public String getCreated() {
            return this.created;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        @ParamAnnotation(paramType="query", paramName="location")
        public String getLocation() {
            return this.location;
        }

        public void setName(String name) {
            this.name = name;
        }

        @ParamAnnotation(paramType="query", paramName="name")
        public String getName() {
            return this.name;
        }

        public void setSize(Long size) {
            this.size = size;
        }

        @ParamAnnotation(paramType="query", paramName="size")
        public Long getSize() {
            return this.size;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        @ParamAnnotation(paramType="query", paramName="status")
        public String getStatus() {
            return this.status;
        }

        public void setURL(String uRL) {
            this.uRL = uRL;
        }

        @ParamAnnotation(paramType="query", paramName="url")
        public String getURL() {
            return this.uRL;
        }
    }

    public static class GetBucketPolicyOutput
    extends OutputModel {
        private List<Types.StatementModel> statement;

        public void setStatement(List<Types.StatementModel> statement) {
            this.statement = statement;
        }

        @ParamAnnotation(paramType="query", paramName="statement")
        public List<Types.StatementModel> getStatement() {
            return this.statement;
        }
    }

    public static class GetBucketNotificationOutput
    extends OutputModel {
        private List<Types.NotificationModel> notifications;

        public void setNotifications(List<Types.NotificationModel> notifications) {
            this.notifications = notifications;
        }

        @ParamAnnotation(paramType="query", paramName="notifications")
        public List<Types.NotificationModel> getNotifications() {
            return this.notifications;
        }
    }

    public static class GetBucketLifecycleOutput
    extends OutputModel {
        private List<Types.RuleModel> rule;

        public void setRule(List<Types.RuleModel> rule) {
            this.rule = rule;
        }

        @ParamAnnotation(paramType="query", paramName="rule")
        public List<Types.RuleModel> getRule() {
            return this.rule;
        }
    }

    public static class GetBucketExternalMirrorOutput
    extends OutputModel {
        private String sourceSite;

        public void setSourceSite(String sourceSite) {
            this.sourceSite = sourceSite;
        }

        @ParamAnnotation(paramType="query", paramName="source_site")
        public String getSourceSite() {
            return this.sourceSite;
        }
    }

    public static class GetBucketCORSOutput
    extends OutputModel {
        private List<Types.CORSRuleModel> cORSRules;

        public void setCORSRules(List<Types.CORSRuleModel> cORSRules) {
            this.cORSRules = cORSRules;
        }

        @ParamAnnotation(paramType="query", paramName="cors_rules")
        public List<Types.CORSRuleModel> getCORSRules() {
            return this.cORSRules;
        }
    }

    public static class GetBucketACLOutput
    extends OutputModel {
        private List<Types.ACLModel> aCL;
        private Types.OwnerModel owner;

        public void setACL(List<Types.ACLModel> aCL) {
            this.aCL = aCL;
        }

        @ParamAnnotation(paramType="query", paramName="acl")
        public List<Types.ACLModel> getACL() {
            return this.aCL;
        }

        public void setOwner(Types.OwnerModel owner) {
            this.owner = owner;
        }

        @ParamAnnotation(paramType="query", paramName="owner")
        public Types.OwnerModel getOwner() {
            return this.owner;
        }
    }

    public static class DeleteMultipleObjectsOutput
    extends OutputModel {
        private List<Types.KeyModel> deleted;
        private List<Types.KeyDeleteErrorModel> errors;

        public void setDeleted(List<Types.KeyModel> deleted) {
            this.deleted = deleted;
        }

        @ParamAnnotation(paramType="query", paramName="deleted")
        public List<Types.KeyModel> getDeleted() {
            return this.deleted;
        }

        public void setErrors(List<Types.KeyDeleteErrorModel> errors) {
            this.errors = errors;
        }

        @ParamAnnotation(paramType="query", paramName="errors")
        public List<Types.KeyDeleteErrorModel> getErrors() {
            return this.errors;
        }
    }

    public static class DeleteMultipleObjectsInput
    extends RequestInputModel {
        private String contentMD5;
        private String bodyInput;
        private List<Types.KeyModel> objects;
        private Boolean quiet;

        public void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        @ParamAnnotation(paramType="header", paramName="Content-MD5")
        public String getContentMD5() {
            return this.contentMD5;
        }

        @ParamAnnotation(paramType="body", paramName="BodyInput")
        public String getBodyInput() {
            return this.bodyInput;
        }

        public void setBodyInput(String bodyInput) {
            this.bodyInput = bodyInput;
        }

        public void setObjects(List<Types.KeyModel> objects) {
            this.objects = objects;
        }

        @ParamAnnotation(paramType="body", paramName="objects")
        public List<Types.KeyModel> getObjects() {
            return this.objects;
        }

        public void setQuiet(Boolean quiet) {
            this.quiet = quiet;
        }

        @ParamAnnotation(paramType="body", paramName="quiet")
        public Boolean getQuiet() {
            return this.quiet;
        }

        @Override
        public String validateParam() {
            if (this.getObjects() != null && this.getObjects().size() > 0) {
                for (int i = 0; i < this.getObjects().size(); ++i) {
                    String vValidate = this.getObjects().get(i).validateParam();
                    if (QSStringUtil.isEmpty(vValidate)) continue;
                    return vValidate;
                }
            }
            return null;
        }
    }

    public static class DeleteBucketPolicyOutput
    extends OutputModel {
    }

    public static class DeleteBucketNotificationOutput
    extends OutputModel {
    }

    public static class DeleteBucketLifecycleOutput
    extends OutputModel {
    }

    public static class DeleteBucketExternalMirrorOutput
    extends OutputModel {
    }

    public static class DeleteBucketCORSOutput
    extends OutputModel {
    }

    public static class DeleteBucketOutput
    extends OutputModel {
    }
}

