/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.request.impl;

import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.request.QSRequestBody;
import com.qingstor.sdk.request.impl.EmptyRequestBody;
import com.qingstor.sdk.request.impl.InputStreamUploadBody;
import com.qingstor.sdk.utils.QSLoggerUtil;
import com.qingstor.sdk.utils.QSStringUtil;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Logger;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.http.HttpMethod;

public class QSNormalRequestBody
implements QSRequestBody {
    private static Logger logger = QSLoggerUtil.setLoggerHanlder(QSNormalRequestBody.class.getName());

    @Override
    public RequestBody getRequestBody(String contentType, long contentLength, String method, Map<String, Object> bodyParams, Map<String, Object> queryParams) throws QSException {
        logger.info("----QSNormalRequestBody----");
        MediaType mediaType = MediaType.parse(contentType);
        if (bodyParams != null && bodyParams.size() > 0) {
            RequestBody body = null;
            Object bodyObj = QSNormalRequestBody.getBodyContent(bodyParams);
            if (bodyObj instanceof String) {
                body = RequestBody.create(mediaType, bodyObj.toString());
            } else if (bodyObj instanceof File) {
                body = RequestBody.create(mediaType, (File)bodyObj);
            } else if (bodyObj instanceof InputStream) {
                body = new InputStreamUploadBody(contentType, (InputStream)bodyObj, contentLength);
            }
            return body;
        }
        if (HttpMethod.permitsRequestBody(method)) {
            return new EmptyRequestBody(contentType);
        }
        return null;
    }

    public static Object getBodyContent(Map bodyContent) throws QSException {
        for (Map.Entry entry : bodyContent.entrySet()) {
            String key = (String)entry.getKey();
            Object bodyObj = bodyContent.get(key);
            if (!"BodyInputFile".equals(key) && !"BodyInputStream".equals(key) && !"BodyInput".equals(key)) continue;
            return bodyObj;
        }
        return QSStringUtil.getMapToJson(bodyContent).toString();
    }
}

