/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.request.impl;

import com.qingstor.sdk.utils.QSLoggerUtil;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Logger;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;

public class MultiFileuploadRequestBody
extends RequestBody {
    private static Logger logger = QSLoggerUtil.setLoggerHanlder(MultiFileuploadRequestBody.class.getName());
    private String contentType;
    private long contentLength;
    private RandomAccessFile file;

    public MultiFileuploadRequestBody(String contentType, RandomAccessFile rFile, long contentLength) {
        logger.info("----InputStreamUploadBody----");
        this.contentLength = contentLength;
        this.contentType = contentType;
        this.file = rFile;
    }

    @Override
    public long contentLength() {
        return this.contentLength;
    }

    @Override
    public MediaType contentType() {
        return MediaType.parse(this.contentType);
    }

    @Override
    public void writeTo(BufferedSink sink) throws IOException {
        int count;
        int readSize = 1024;
        int bytes = 0;
        byte[] bufferOut = new byte[readSize];
        int leftCount = (int)(this.contentLength % (long)readSize);
        for (count = (int)(this.contentLength / (long)readSize); count > 0 && (bytes = this.file.read(bufferOut)) != -1; --count) {
            sink.write(bufferOut, 0, bytes);
        }
        if (count >= 0 && leftCount > 0 && (bytes = this.file.read(bufferOut = new byte[leftCount])) != -1) {
            sink.write(bufferOut, 0, bytes);
        }
    }
}

