/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.request.impl;

import com.qingstor.sdk.utils.QSLoggerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.BufferedSink;

public class InputStreamUploadBody
extends RequestBody {
    private static Logger logger = QSLoggerUtil.setLoggerHanlder(InputStreamUploadBody.class.getName());
    private String contentType;
    private long contentLength;
    private InputStream file;
    private long offset;

    public InputStreamUploadBody(String contentType, InputStream rFile, long contentLength) {
        this(contentType, rFile, contentLength, 0L);
    }

    public InputStreamUploadBody(String contentType, InputStream rFile, long contentLength, long offset) {
        logger.info("----InputStreamUploadBody----");
        this.contentLength = contentLength;
        this.contentType = contentType;
        this.file = rFile;
        this.offset = offset;
    }

    @Override
    public MediaType contentType() {
        return MediaType.parse(this.contentType);
    }

    @Override
    public void writeTo(BufferedSink sink) throws IOException {
        if (this.contentLength > 0L) {
            this.writeWithContentLength(sink, this.offset);
        } else {
            this.writeAll(sink);
        }
        sink.flush();
        Util.closeQuietly(this.file);
    }

    private void writeWithContentLength(BufferedSink sink, long offset) throws IOException {
        logger.log(Level.INFO, "---writeWithContentLength----");
        int readSize = 1024;
        int bytes = 0;
        byte[] bufferOut = new byte[readSize];
        long count = this.contentLength / (long)readSize;
        long leftCount = this.contentLength % (long)readSize;
        long iReadLength = 0L;
        if (offset > 0L) {
            this.file.skip(offset);
        }
        while (count > 0L && (bytes = this.file.read(bufferOut)) != -1) {
            sink.write(bufferOut, 0, bytes);
            --count;
            iReadLength += (long)bytes;
            if (bytes == readSize) continue;
            count = (this.contentLength - iReadLength) / (long)readSize;
            leftCount = (this.contentLength - iReadLength) % (long)readSize;
        }
        if (count == 0L && leftCount > 0L && (bytes = this.file.read(bufferOut = new byte[(int)leftCount])) != -1) {
            sink.write(bufferOut, 0, bytes);
        }
    }

    private void writeAll(BufferedSink sink) throws IOException {
        logger.log(Level.INFO, "---writeAll----");
        int readSize = 1024;
        int bytes = 0;
        byte[] bufferOut = new byte[readSize];
        while ((bytes = this.file.read(bufferOut)) != -1) {
            sink.write(bufferOut, 0, bytes);
        }
    }
}

