/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.request;

import com.qingstor.sdk.annotation.ParamAnnotation;
import com.qingstor.sdk.config.EnvContext;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.model.OutputModel;
import com.qingstor.sdk.model.RequestInputModel;
import com.qingstor.sdk.request.BodyProgressListener;
import com.qingstor.sdk.request.CancellationHandler;
import com.qingstor.sdk.request.QSBuilder;
import com.qingstor.sdk.request.QSOkHttpRequestClient;
import com.qingstor.sdk.request.QSRequestBody;
import com.qingstor.sdk.request.ResponseCallBack;
import com.qingstor.sdk.request.impl.ProgressRequestBody;
import com.qingstor.sdk.utils.QSLoggerUtil;
import com.qingstor.sdk.utils.QSParamInvokeUtil;
import com.qingstor.sdk.utils.QSStringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Request;
import okhttp3.RequestBody;

public class RequestHandler {
    private static Logger logger = QSLoggerUtil.setLoggerHanlder(RequestHandler.class.getName());
    private Map contextParam;
    private RequestInputModel paramBean;
    private Class outputClass;
    private ResponseCallBack asyncCallback;
    private QSBuilder builder;
    private BodyProgressListener progressListener;
    private CancellationHandler cancellationHandler;
    private QSRequestBody qsRequestBody;

    public RequestHandler(Map context, RequestInputModel paramBean, Class outputClass) throws QSException {
        this.contextParam = context;
        this.paramBean = paramBean;
        this.outputClass = outputClass;
        this.builder = new QSBuilder(context, paramBean);
    }

    public RequestHandler(Map context, RequestInputModel paramBean, ResponseCallBack asyncCallback) throws QSException {
        this.contextParam = context;
        this.paramBean = paramBean;
        this.asyncCallback = asyncCallback;
        this.builder = new QSBuilder(context, paramBean);
    }

    public void sendAsync() throws QSException {
        String validate = this.check();
        if (!QSStringUtil.isEmpty(validate)) {
            OutputModel out = QSParamInvokeUtil.getOutputModel(this.asyncCallback);
            QSOkHttpRequestClient.fillResponseCallbackModel(10000, validate, out);
            this.asyncCallback.onAPIResponse(out);
        } else {
            EnvContext envContext = (EnvContext)this.contextParam.get("evnContext");
            Request request = this.getRequest();
            QSOkHttpRequestClient.getInstance().requestActionAsync(request, envContext.isSafeOkHttp(), this.asyncCallback);
        }
    }

    public OutputModel send() throws QSException {
        String validate = this.check();
        if (!QSStringUtil.isEmpty(validate)) {
            try {
                OutputModel model = (OutputModel)this.outputClass.newInstance();
                QSOkHttpRequestClient.fillResponseCallbackModel(10000, validate, model);
                return model;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage());
                throw new QSException(e.getMessage());
            }
        }
        EnvContext envContext = (EnvContext)this.contextParam.get("evnContext");
        Request request = this.getRequest();
        return QSOkHttpRequestClient.getInstance().requestAction(request, envContext.isSafeOkHttp(), this.outputClass);
    }

    private Request getRequest() throws QSException {
        this.checkDownloadRequest();
        RequestBody body = this.builder.getRequestBody(this.getQsRequestBody());
        if (this.getProgressListener() != null) {
            return this.builder.getRequest(new ProgressRequestBody(body, this.progressListener, this.getCancellationHandler()));
        }
        return this.builder.getRequest(body);
    }

    private void checkDownloadRequest() {
        Field[] declaredField;
        if (this.outputClass == null) {
            return;
        }
        boolean isDownloadRequest = false;
        block0: for (Field field : declaredField = this.outputClass.getDeclaredFields()) {
            Method[] methods;
            String methodName = "get" + QSParamInvokeUtil.capitalize(field.getName());
            for (Method m : methods = this.outputClass.getDeclaredMethods()) {
                ParamAnnotation annotation;
                if (!m.getName().equalsIgnoreCase(methodName) || (annotation = m.getAnnotation(ParamAnnotation.class)) == null || !"BodyInputStream".equals(annotation.paramName())) continue;
                isDownloadRequest = true;
                continue block0;
            }
        }
        if (isDownloadRequest) {
            this.getBuilder().setHeader("Accept-Encoding", "identity");
        }
    }

    public String getStringToSignature() throws QSException {
        return this.builder.getStringToSignature();
    }

    public void setSignature(String accessKey, String signature) throws QSException {
        this.builder.setSignature(accessKey, signature);
    }

    public void setSignature(String accessKey, String signature, String gmtTime) throws QSException {
        this.builder.setHeader("Date", gmtTime);
        this.setSignature(accessKey, signature);
    }

    public String getExpiresRequestUrl() throws QSException {
        return this.builder.getExpiresRequestUrl();
    }

    public String check() {
        String validate = this.paramBean != null ? this.paramBean.validateParam() : "";
        EnvContext envContext = (EnvContext)this.contextParam.get("evnContext");
        String envValidate = envContext.validateParam();
        if (!QSStringUtil.isEmpty(validate) || !QSStringUtil.isEmpty(envValidate)) {
            if (QSStringUtil.isEmpty(validate)) {
                validate = envValidate;
            }
            return validate;
        }
        return null;
    }

    public QSBuilder getBuilder() {
        return this.builder;
    }

    public BodyProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setProgressListener(BodyProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public QSRequestBody getQsRequestBody() {
        return this.qsRequestBody;
    }

    public void setQsRequestBody(QSRequestBody qsRequestBody) {
        this.qsRequestBody = qsRequestBody;
    }

    public CancellationHandler getCancellationHandler() {
        return this.cancellationHandler;
    }

    public void setCancellationHandler(CancellationHandler cancellationHandler) {
        this.cancellationHandler = cancellationHandler;
    }
}

