/*
 * Decompiled with CFR 0.152.
 */
package com.truthbean.logger.util;

import com.truthbean.logger.util.DateTimeHelper;

public class MessageHelper {
    private MessageHelper() {
    }

    public static String format(Object message, Object ... params) {
        if (message == null) {
            return "null";
        }
        return MessageHelper.format(message.toString(), params);
    }

    public static String format(String message, Object ... params) {
        int i;
        if (params == null || params.length == 0) {
            return message;
        }
        int length = message.length();
        char[] chars = new char[length];
        for (i = 0; i < length; ++i) {
            chars[i] = message.charAt(i);
        }
        i = 0;
        StringBuilder sb = new StringBuilder();
        int j = 0;
        while (j < chars.length) {
            char js = chars[j];
            if ('{' == js && j + 1 < chars.length && '}' == chars[j + 1]) {
                if (i < params.length) {
                    sb.append(params[i]);
                    ++i;
                }
                j += 2;
                continue;
            }
            sb.append(js);
            ++j;
        }
        return sb.toString();
    }

    public static String toString(Object message) {
        if (message == null) {
            return "null";
        }
        return message.toString();
    }

    public static StringBuilder buildMessage(String level, String threadName, String location) {
        StringBuilder logger = new StringBuilder();
        logger.append("\u001b[98;1m").append(DateTimeHelper.nowStr()).append("\u001b[0m ");
        switch (level) {
            case "OFF": 
            case "FATAL": {
                logger.append("\u001b[31;1m").append("FATAL").append("\u001b[0m ").append("[\u001b[30;1m").append(threadName).append("\u001b[0m] ").append("\u001b[31;4m").append(location).append("\u001b[0m \u001b[97;1m:\u001b[0m \u001b[39;1m");
                break;
            }
            case "SEVERE": 
            case "ERROR": {
                logger.append("\u001b[91;1m").append("ERROR").append("\u001b[0m ").append("[\u001b[30;1m").append(threadName).append("\u001b[0m] ").append("\u001b[91;4m").append(location).append("\u001b[0m \u001b[97;1m:\u001b[0m \u001b[39;1m");
                break;
            }
            case "WARNING": 
            case "WARN": {
                logger.append("\u001b[93;1m").append("WARN").append(" \u001b[0m ").append("[\u001b[30;1m").append(threadName).append("\u001b[0m] ").append("\u001b[93;4m").append(location).append("\u001b[0m \u001b[97;1m:\u001b[0m \u001b[39;1m");
                break;
            }
            case "INFO": {
                logger.append("\u001b[36;1m").append("INFO").append(" \u001b[0m ").append("[\u001b[30;1m").append(threadName).append("\u001b[0m] ").append("\u001b[36;4m").append(location).append("\u001b[0m \u001b[97;1m:\u001b[0m \u001b[39;1m");
                break;
            }
            case "DEBUG": 
            case "CONFIG": 
            case "FINE": {
                logger.append("\u001b[94;1m").append("DEBUG").append("\u001b[0m ").append("[\u001b[30;1m").append(threadName).append("\u001b[0m] ").append("\u001b[94;4m").append(location).append("\u001b[0m \u001b[97;1m:\u001b[0m \u001b[39;1m");
                break;
            }
            case "TRACE": 
            case "FINER": 
            case "FINEST": {
                logger.append("\u001b[35;1m").append("TRACE").append("\u001b[0m ").append("[\u001b[30;1m").append(threadName).append("\u001b[0m] ").append("\u001b[35;4m").append(location).append("\u001b[0m \u001b[97;1m:\u001b[0m \u001b[39;1m");
                break;
            }
        }
        return logger;
    }
}

