/*
 * Decompiled with CFR 0.152.
 */
package com.truthbean.logger;

import com.truthbean.Logger;
import com.truthbean.logger.ConfigurableLogger;
import com.truthbean.logger.LogLevel;
import com.truthbean.logger.LoggerConfig;
import com.truthbean.logger.LoggerFactory;
import com.truthbean.logger.LoggerLocation;
import com.truthbean.logger.util.MessageHelper;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class SystemOutLogger
implements ConfigurableLogger {
    private String loggerName;
    private LogLevel level;
    private boolean useName;

    public static Logger getLogger(Class<?> tracedClass) {
        return new SystemOutLogger().setClass(tracedClass).setDefaultLevel(LogLevel.WARN);
    }

    public static Logger getLogger(LoggerConfig loggerConfig, Class<?> tracedClass) {
        SystemOutLogger logger = new SystemOutLogger();
        logger.setClass(tracedClass);
        logger.setDefaultLevel(LogLevel.WARN);
        logger.level = logger.getLevel(loggerConfig);
        return logger;
    }

    public static void err(String message, Throwable e) {
        new SystemOutLogger().logging(LogLevel.ERROR, e, message, new Object[0]);
    }

    @Override
    public ConfigurableLogger setClass(Class<?> tracedClass) {
        this.loggerName = tracedClass.getName();
        return this;
    }

    @Override
    public ConfigurableLogger setName(String name) {
        this.loggerName = name;
        return this;
    }

    @Override
    public ConfigurableLogger setUseName(boolean useName) {
        this.useName = useName;
        return this;
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public ConfigurableLogger setName(CharSequence name) {
        this.loggerName = name.toString();
        return this;
    }

    @Override
    public ConfigurableLogger setDefaultLevel(LogLevel level) {
        this.level = level;
        return this;
    }

    @Override
    public LogLevel getDefaultLevel() {
        return this.level;
    }

    @Override
    public LogLevel getLevel() {
        LoggerConfig config = LoggerFactory.getConfig();
        if (config == null) {
            return LogLevel.ERROR;
        }
        Optional<LogLevel> level = config.getLevel(this.getLoggerName());
        return level.orElseGet(() -> Objects.requireNonNullElse(this.getDefaultLevel(), LogLevel.ERROR));
    }

    public LogLevel getLevel(LoggerConfig config) {
        Optional<LogLevel> level = config.getLevel(this.getLoggerName());
        return level.orElseGet(() -> Objects.requireNonNullElse(this.getDefaultLevel(), LogLevel.ERROR));
    }

    @Override
    public Logger logger() {
        this.level = this.getLevel();
        return this;
    }

    @Override
    public boolean isLoggable(LogLevel level) {
        return this.level.compareTo(level) >= 0;
    }

    @Override
    public void log(LogLevel level, Object message) {
        if (this.isLoggable(level)) {
            this.logging(level, null, MessageHelper.toString(message), new Object[0]);
        }
    }

    @Override
    public void log(LogLevel level, String message) {
        if (this.isLoggable(level)) {
            this.logging(level, null, message, new Object[0]);
        }
    }

    @Override
    public void log(LogLevel level, Supplier<String> supplier) {
        if (this.isLoggable(level)) {
            this.logging(level, null, supplier.get(), new Object[0]);
        }
    }

    @Override
    public void log(LogLevel level, Object message, Object ... params) {
        if (this.isLoggable(level)) {
            this.logging(level, null, MessageHelper.toString(message), params);
        }
    }

    @Override
    public void log(LogLevel level, String message, Object ... params) {
        if (this.isLoggable(level)) {
            this.logging(level, null, message, params);
        }
    }

    @Override
    public void log(LogLevel level, Object message, Throwable e) {
        if (this.isLoggable(level)) {
            this.logging(level, e, MessageHelper.toString(message), new Object[0]);
        }
    }

    @Override
    public void log(LogLevel level, String message, Throwable e) {
        if (this.isLoggable(level)) {
            this.logging(level, e, message, new Object[0]);
        }
    }

    @Override
    public void log(LogLevel level, Supplier<String> supplier, Throwable e) {
        if (this.isLoggable(level)) {
            this.logging(level, e, supplier.get(), new Object[0]);
        }
    }

    @Override
    public void log(LogLevel level, Object message, Throwable e, Object ... params) {
        if (this.isLoggable(level)) {
            this.logging(level, e, MessageHelper.toString(message), params);
        }
    }

    @Override
    public void log(LogLevel level, String message, Throwable e, Object ... params) {
        if (this.isLoggable(level)) {
            this.logging(level, e, message, params);
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isLoggable(LogLevel.TRACE);
    }

    @Override
    public void trace(Object message) {
        if (this.isTraceEnabled()) {
            this.logging(LogLevel.TRACE, null, MessageHelper.toString(message), new Object[0]);
        }
    }

    @Override
    public void trace(String message) {
        if (this.isTraceEnabled()) {
            this.logging(LogLevel.TRACE, null, message, new Object[0]);
        }
    }

    @Override
    public void trace(Supplier<String> supplier) {
        if (this.isTraceEnabled()) {
            this.logging(LogLevel.TRACE, null, supplier.get(), new Object[0]);
        }
    }

    @Override
    public void trace(Object message, Object ... params) {
        if (this.isTraceEnabled()) {
            this.logging(LogLevel.TRACE, null, MessageHelper.toString(message), new Object[0]);
        }
    }

    @Override
    public void trace(String message, Object ... params) {
        if (this.isTraceEnabled()) {
            this.logging(LogLevel.TRACE, null, message, params);
        }
    }

    @Override
    public void trace(Object message, Throwable e) {
        if (this.isTraceEnabled()) {
            this.logging(LogLevel.TRACE, e, MessageHelper.toString(message), new Object[0]);
        }
    }

    @Override
    public void trace(String message, Throwable e) {
        if (this.isTraceEnabled()) {
            this.logging(LogLevel.TRACE, e, message, new Object[0]);
        }
    }

    @Override
    public void trace(Supplier<String> supplier, Throwable e) {
        if (this.isTraceEnabled()) {
            this.logging(LogLevel.TRACE, e, supplier.get(), new Object[0]);
        }
    }

    @Override
    public void trace(Object message, Throwable e, Object ... params) {
        if (this.isTraceEnabled()) {
            this.logging(LogLevel.TRACE, e, MessageHelper.toString(message), params);
        }
    }

    @Override
    public void trace(String message, Throwable e, Object ... params) {
        if (this.isTraceEnabled()) {
            this.logging(LogLevel.TRACE, e, message, params);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isLoggable(LogLevel.DEBUG);
    }

    @Override
    public void debug(Object message) {
        if (this.isDebugEnabled()) {
            this.logging(LogLevel.DEBUG, null, MessageHelper.toString(message), new Object[0]);
        }
    }

    @Override
    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.logging(LogLevel.DEBUG, null, message, new Object[0]);
        }
    }

    @Override
    public void debug(Supplier<String> supplier) {
        if (this.isDebugEnabled()) {
            this.logging(LogLevel.DEBUG, null, supplier.get(), new Object[0]);
        }
    }

    @Override
    public void debug(Object message, Object ... params) {
        if (this.isDebugEnabled()) {
            this.logging(LogLevel.DEBUG, null, MessageHelper.toString(message), params);
        }
    }

    @Override
    public void debug(String message, Object ... params) {
        if (this.isDebugEnabled()) {
            this.logging(LogLevel.DEBUG, null, message, params);
        }
    }

    @Override
    public void debug(Object message, Throwable e) {
        if (this.isDebugEnabled()) {
            this.logging(LogLevel.DEBUG, e, MessageHelper.toString(message), new Object[0]);
        }
    }

    @Override
    public void debug(String message, Throwable e) {
        if (this.isDebugEnabled()) {
            this.logging(LogLevel.DEBUG, e, message, new Object[0]);
        }
    }

    @Override
    public void debug(Supplier<String> supplier, Throwable e) {
        if (this.isDebugEnabled()) {
            this.logging(LogLevel.DEBUG, e, supplier.get(), new Object[0]);
        }
    }

    @Override
    public void debug(Object message, Throwable e, Object ... params) {
        if (this.isDebugEnabled()) {
            this.logging(LogLevel.DEBUG, e, MessageHelper.toString(message), params);
        }
    }

    @Override
    public void debug(String message, Throwable e, Object ... params) {
        if (this.isDebugEnabled()) {
            this.logging(LogLevel.DEBUG, e, message, params);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isLoggable(LogLevel.INFO);
    }

    @Override
    public void info(Object message) {
        if (this.isInfoEnabled()) {
            this.logging(LogLevel.INFO, null, MessageHelper.toString(message), new Object[0]);
        }
    }

    @Override
    public void info(String message) {
        if (this.isInfoEnabled()) {
            this.logging(LogLevel.INFO, null, message, new Object[0]);
        }
    }

    @Override
    public void info(Supplier<String> supplier) {
        if (this.isInfoEnabled()) {
            this.logging(LogLevel.INFO, null, supplier.get(), new Object[0]);
        }
    }

    @Override
    public void info(Object message, Object ... params) {
        if (this.isInfoEnabled()) {
            this.logging(LogLevel.INFO, null, MessageHelper.toString(message), params);
        }
    }

    @Override
    public void info(String message, Object ... params) {
        if (this.isInfoEnabled()) {
            this.logging(LogLevel.INFO, null, message, params);
        }
    }

    @Override
    public void info(Object message, Throwable e) {
        if (this.isInfoEnabled()) {
            this.logging(LogLevel.INFO, e, MessageHelper.toString(message), new Object[0]);
        }
    }

    @Override
    public void info(String message, Throwable e) {
        if (this.isInfoEnabled()) {
            this.logging(LogLevel.INFO, e, message, new Object[0]);
        }
    }

    @Override
    public void info(Supplier<String> supplier, Throwable e) {
        if (this.isInfoEnabled()) {
            this.logging(LogLevel.INFO, e, supplier.get(), new Object[0]);
        }
    }

    @Override
    public void info(Object message, Throwable e, Object ... params) {
        if (this.isInfoEnabled()) {
            this.logging(LogLevel.INFO, e, MessageHelper.toString(message), params);
        }
    }

    @Override
    public void info(String message, Throwable e, Object ... params) {
        if (this.isInfoEnabled()) {
            this.logging(LogLevel.INFO, e, message, params);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isLoggable(LogLevel.WARN);
    }

    @Override
    public void warn(Object message) {
        if (this.isWarnEnabled()) {
            this.logging(LogLevel.WARN, null, MessageHelper.toString(message), new Object[0]);
        }
    }

    @Override
    public void warn(String message) {
        if (this.isWarnEnabled()) {
            this.logging(LogLevel.WARN, null, message, new Object[0]);
        }
    }

    @Override
    public void warn(Supplier<String> supplier) {
        if (this.isWarnEnabled()) {
            this.logging(LogLevel.WARN, null, supplier.get(), new Object[0]);
        }
    }

    @Override
    public void warn(Object message, Object ... params) {
        if (this.isWarnEnabled()) {
            this.logging(LogLevel.WARN, null, MessageHelper.toString(message), params);
        }
    }

    @Override
    public void warn(String message, Object ... params) {
        if (this.isWarnEnabled()) {
            this.logging(LogLevel.WARN, null, message, params);
        }
    }

    @Override
    public void warn(Object message, Throwable e) {
        if (this.isWarnEnabled()) {
            this.logging(LogLevel.WARN, e, MessageHelper.toString(message), new Object[0]);
        }
    }

    @Override
    public void warn(String message, Throwable e) {
        if (this.isWarnEnabled()) {
            this.logging(LogLevel.WARN, e, message, new Object[0]);
        }
    }

    @Override
    public void warn(Supplier<String> supplier, Throwable e) {
        if (this.isWarnEnabled()) {
            this.logging(LogLevel.WARN, e, supplier.get(), new Object[0]);
        }
    }

    @Override
    public void warn(Object message, Throwable e, Object ... params) {
        if (this.isWarnEnabled()) {
            this.logging(LogLevel.WARN, e, MessageHelper.toString(message), params);
        }
    }

    @Override
    public void warn(String message, Throwable e, Object ... params) {
        if (this.isWarnEnabled()) {
            this.logging(LogLevel.WARN, e, message, params);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isLoggable(LogLevel.ERROR);
    }

    @Override
    public void error(Object message) {
        if (this.isErrorEnabled()) {
            this.logging(LogLevel.ERROR, null, MessageHelper.toString(message), new Object[0]);
        }
    }

    @Override
    public void error(String message) {
        if (this.isErrorEnabled()) {
            this.logging(LogLevel.ERROR, null, message, new Object[0]);
        }
    }

    @Override
    public void error(Supplier<String> supplier) {
        if (this.isErrorEnabled()) {
            this.logging(LogLevel.ERROR, null, supplier.get(), new Object[0]);
        }
    }

    @Override
    public void error(Object message, Object ... params) {
        if (this.isErrorEnabled()) {
            this.logging(LogLevel.ERROR, null, MessageHelper.toString(message), params);
        }
    }

    @Override
    public void error(String message, Object ... params) {
        this.logging(LogLevel.ERROR, null, message, params);
    }

    @Override
    public void error(Object message, Throwable e) {
        if (this.isErrorEnabled()) {
            this.logging(LogLevel.ERROR, e, MessageHelper.toString(message), new Object[0]);
        }
    }

    @Override
    public void error(String message, Throwable e) {
        if (this.isErrorEnabled()) {
            this.logging(LogLevel.ERROR, e, message, new Object[0]);
        }
    }

    @Override
    public void error(Supplier<String> supplier, Throwable e) {
        if (this.isErrorEnabled()) {
            this.logging(LogLevel.ERROR, e, supplier.get(), new Object[0]);
        }
    }

    @Override
    public void error(Object message, Throwable e, Object ... params) {
        if (this.isErrorEnabled()) {
            this.logging(LogLevel.ERROR, e, MessageHelper.toString(message), params);
        }
    }

    @Override
    public void error(String message, Throwable e, Object ... params) {
        if (this.isErrorEnabled()) {
            this.logging(LogLevel.ERROR, e, message, params);
        }
    }

    @Override
    public boolean isFatalEnabled() {
        return this.isLoggable(LogLevel.FATAL);
    }

    @Override
    public void fatal(Object message) {
        if (this.isErrorEnabled()) {
            this.logging(LogLevel.FATAL, null, MessageHelper.toString(message), new Object[0]);
        }
    }

    @Override
    public void fatal(String message) {
        if (this.isFatalEnabled()) {
            this.logging(LogLevel.FATAL, null, message, new Object[0]);
        }
    }

    @Override
    public void fatal(Supplier<String> supplier) {
        if (this.isFatalEnabled()) {
            this.logging(LogLevel.FATAL, null, supplier.get(), new Object[0]);
        }
    }

    @Override
    public void fatal(Object message, Object ... params) {
        if (this.isErrorEnabled()) {
            this.logging(LogLevel.FATAL, null, MessageHelper.toString(message), params);
        }
    }

    @Override
    public void fatal(String message, Object ... params) {
        if (this.isFatalEnabled()) {
            this.logging(LogLevel.FATAL, null, message, params);
        }
    }

    @Override
    public void fatal(Object message, Throwable e) {
        if (this.isErrorEnabled()) {
            this.logging(LogLevel.FATAL, e, MessageHelper.toString(message), new Object[0]);
        }
    }

    @Override
    public void fatal(String message, Throwable e) {
        if (this.isFatalEnabled()) {
            this.logging(LogLevel.FATAL, e, message, new Object[0]);
        }
    }

    @Override
    public void fatal(Supplier<String> supplier, Throwable e) {
        if (this.isFatalEnabled()) {
            this.logging(LogLevel.FATAL, e, supplier.get(), new Object[0]);
        }
    }

    @Override
    public void fatal(Object message, Throwable e, Object ... params) {
        if (this.isErrorEnabled()) {
            this.logging(LogLevel.FATAL, e, MessageHelper.toString(message), params);
        }
    }

    @Override
    public void fatal(String message, Throwable e, Object ... params) {
        if (this.isFatalEnabled()) {
            this.logging(LogLevel.FATAL, e, message, params);
        }
    }

    public void logging(LogLevel level, Throwable ex, String message, Object ... params) {
        LoggerLocation location;
        if (!this.useName) {
            location = ConfigurableLogger.getLoggerMethod(this.getLoggerName());
        } else {
            location = new LoggerLocation();
            location.setLoggerName(this.getLoggerName());
        }
        String threadName = Thread.currentThread().getName();
        StringBuilder logger = MessageHelper.buildMessage(level.name(), threadName, location.toString());
        String newMessage = MessageHelper.format(message, params) + "\u001b[0m";
        logger.append(newMessage);
        System.out.println(logger.toString());
        if (ex != null) {
            ex.printStackTrace();
        }
    }
}

