/*
 * Decompiled with CFR 0.152.
 */
package com.truthbean.logger;

import com.truthbean.Logger;
import com.truthbean.logger.ConfigurableLogger;
import com.truthbean.logger.DefaultLoggerConfig;
import com.truthbean.logger.LogLevel;
import com.truthbean.logger.LoggerConfig;
import com.truthbean.logger.LoggerInitiation;
import com.truthbean.logger.NoLogger;
import com.truthbean.logger.SystemOutLogger;
import com.truthbean.logger.exception.NoLoggerProviderException;
import java.util.Optional;
import java.util.ServiceLoader;

public class LoggerFactory {
    public static final String NO_LOGGER = "com.truthbean.logger.no";
    public static final String STD_OUT = "com.truthbean.logger.system-out";
    private static volatile LoggerConfig config;

    public static synchronized LoggerConfig getConfig() {
        return config;
    }

    public static void flushConfig() {
        ServiceLoader<LoggerInitiation> serviceLoader = ServiceLoader.load(LoggerInitiation.class);
        serviceLoader.forEach(LoggerInitiation::flush);
    }

    public static void destroy() {
        ServiceLoader<LoggerInitiation> serviceLoader = ServiceLoader.load(LoggerInitiation.class);
        serviceLoader.forEach(LoggerInitiation::destroy);
        System.runFinalization();
        System.gc();
    }

    public static Logger getLogger(LogLevel defaultLevel, Class<?> clazz) {
        Logger logger = LoggerFactory.getLogger();
        if (logger.getClass() != NoLogger.class && ConfigurableLogger.class.isAssignableFrom(logger.getClass())) {
            return ((ConfigurableLogger)logger).setClass(clazz).setDefaultLevel(defaultLevel).setUseName(config.useName()).logger();
        }
        return logger;
    }

    public static Logger getLogger(Class<?> clazz) {
        Logger logger = LoggerFactory.getLogger();
        if (logger.getClass() != NoLogger.class && ConfigurableLogger.class.isAssignableFrom(logger.getClass())) {
            return ((ConfigurableLogger)logger).setClass(clazz).setDefaultLevel(LogLevel.ERROR).setUseName(config.useName()).logger();
        }
        return logger;
    }

    public static Logger getLogger(LogLevel defaultLevel, String loggerName) {
        Logger logger = LoggerFactory.getLogger();
        if (logger.getClass() != NoLogger.class && ConfigurableLogger.class.isAssignableFrom(logger.getClass())) {
            return ((ConfigurableLogger)logger).setName(loggerName).setDefaultLevel(defaultLevel).setUseName(config.useName()).logger();
        }
        return logger;
    }

    public static Logger getLogger(String loggerName) {
        Logger logger = LoggerFactory.getLogger();
        if (logger.getClass() != NoLogger.class && ConfigurableLogger.class.isAssignableFrom(logger.getClass())) {
            return ((ConfigurableLogger)logger).setName(loggerName).setDefaultLevel(LogLevel.ERROR).setUseName(config.useName()).logger();
        }
        return logger;
    }

    private static Optional<ConfigurableLogger> getBaseLogger() {
        Logger logger = LoggerFactory.getLogger();
        if (ConfigurableLogger.class.isAssignableFrom(logger.getClass())) {
            return Optional.of((ConfigurableLogger)logger);
        }
        return Optional.empty();
    }

    private static Logger getLogger() {
        Optional<Object> first;
        boolean noLog;
        boolean doStdOut;
        block6: {
            String out = System.getProperty(STD_OUT, "false");
            doStdOut = "true".equalsIgnoreCase(out) || "yes".equalsIgnoreCase(out) || "y".equalsIgnoreCase(out) || "ok".equalsIgnoreCase(out) || "\u662f".equalsIgnoreCase(out) || "\u597d".equalsIgnoreCase(out) || "\u786e\u5b9a".equalsIgnoreCase(out) || "\u965b\u4e0b\u82f1\u660e".equalsIgnoreCase(out);
            String no = System.getProperty(NO_LOGGER, "false");
            noLog = "false".equalsIgnoreCase(no) || "no".equalsIgnoreCase(no) || "y".equalsIgnoreCase(no) || "\u4e0d".equalsIgnoreCase(no) || "\u6eda".equalsIgnoreCase(no) || "\u5426".equalsIgnoreCase(no) || "\u9762\u5bf9\u75be\u98ce\u5427".equalsIgnoreCase(no);
            first = Optional.empty();
            try {
                ServiceLoader<Logger> serviceLoader = ServiceLoader.load(Logger.class);
                first = serviceLoader.findFirst();
            }
            catch (Throwable e) {
                if (doStdOut) {
                    SystemOutLogger.err("load logger error.", e);
                }
                if (!noLog) break block6;
                throw new NoLoggerProviderException("load logger error.", e);
            }
        }
        if (first.isEmpty()) {
            if (!doStdOut) {
                if (noLog) {
                    throw new NoLoggerProviderException();
                }
                return new NoLogger();
            }
            return new SystemOutLogger();
        }
        return (Logger)first.get();
    }

    static {
        try {
            ServiceLoader<LoggerConfig> loggerConfigs = ServiceLoader.load(LoggerConfig.class);
            Optional<LoggerConfig> loggerConfig = loggerConfigs.findFirst();
            config = loggerConfig.orElseGet(DefaultLoggerConfig::getInstance);
            ServiceLoader<LoggerInitiation> serviceLoader = ServiceLoader.load(LoggerInitiation.class);
            serviceLoader.forEach(LoggerInitiation::init);
        }
        catch (Throwable e) {
            config = DefaultLoggerConfig.getInstance();
            Logger logger = LoggerFactory.getLogger();
            if (ConfigurableLogger.class.isAssignableFrom(logger.getClass())) {
                ((ConfigurableLogger)logger).setName("com.truthbean.logger.LoggerFactory").setDefaultLevel(LogLevel.ERROR).setUseName(config.useName()).logger().error("", e);
            }
            logger.error("", e);
        }
    }
}

