/*
 * Decompiled with CFR 0.152.
 */
package com.truthbean.logger;

import com.truthbean.logger.LogLevel;
import com.truthbean.logger.LoggerConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;

public class DefaultLoggerConfig
implements LoggerConfig {
    private final ConcurrentMap<String, LogLevel> levelMap = new ConcurrentHashMap<String, LogLevel>();
    private static volatile DefaultLoggerConfig config;

    private DefaultLoggerConfig() {
        Runtime.getRuntime().addShutdownHook(new Thread(this.levelMap::clear));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultLoggerConfig getInstance() {
        if (config != null) return config;
        Class<DefaultLoggerConfig> clazz = DefaultLoggerConfig.class;
        synchronized (DefaultLoggerConfig.class) {
            if (config != null) return config;
            config = new DefaultLoggerConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return config;
        }
    }

    @Override
    public void setLogLevel(String loggerName, LogLevel level) {
        this.levelMap.put(loggerName, level);
    }

    @Override
    public boolean useName() {
        Properties properties = System.getProperties();
        String useName = properties.getProperty("com.truthbean.logger.use-name", "false");
        return Boolean.parseBoolean(useName);
    }

    @Override
    public Map<String, LogLevel> getLoggers() {
        HashMap map = new HashMap();
        Properties properties = System.getProperties();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String name = (String)key;
            if (name.startsWith("logging.level.")) {
                String level = (String)value;
                Optional<LogLevel> l = LogLevel.of(level);
                l.ifPresent(logLevel -> map.put(name.substring(14), logLevel));
            }
        }));
        if (!map.isEmpty()) {
            this.levelMap.putAll(map);
        }
        return new HashMap<String, LogLevel>(this.levelMap);
    }

    @Override
    public Optional<LogLevel> getLevel(String name) {
        LogLevel level;
        if (this.levelMap.isEmpty()) {
            this.getLoggers();
        }
        if (!this.levelMap.isEmpty()) {
            for (Map.Entry entry : this.levelMap.entrySet()) {
                String key = (String)entry.getKey();
                LogLevel level2 = (LogLevel)((Object)entry.getValue());
                if (!key.equals(name)) continue;
                return Optional.ofNullable(level2);
            }
            LogLevel result = null;
            for (Map.Entry entry : this.levelMap.entrySet()) {
                String key = (String)entry.getKey();
                LogLevel level3 = (LogLevel)((Object)entry.getValue());
                if (!name.startsWith(key + ".")) continue;
                result = level3;
                break;
            }
            if (result != null) {
                this.levelMap.put(name, result);
                return Optional.of(result);
            }
        }
        if (this.levelMap.containsKey("ROOT")) {
            level = (LogLevel)((Object)this.levelMap.get("ROOT"));
            return Optional.ofNullable(level);
        }
        if (this.levelMap.containsKey("root")) {
            level = (LogLevel)((Object)this.levelMap.get("root"));
            return Optional.ofNullable(level);
        }
        return Optional.empty();
    }

    @Override
    public void clear() {
        this.levelMap.clear();
    }
}

