/*
 * Decompiled with CFR 0.152.
 */
package com.truthbean.logger;

import com.truthbean.Logger;
import com.truthbean.logger.LogLevel;
import com.truthbean.logger.LoggerLocation;
import java.time.Duration;
import java.time.Instant;

public interface ConfigurableLogger
extends Logger {
    public static final String LOCATION_TIME = "com.truthbean.logger.location-time";

    public ConfigurableLogger setClass(Class<?> var1);

    public ConfigurableLogger setName(CharSequence var1);

    public ConfigurableLogger setName(String var1);

    public String getLoggerName();

    public ConfigurableLogger setDefaultLevel(LogLevel var1);

    default public ConfigurableLogger setUseName(boolean useName) {
        return this;
    }

    public LogLevel getDefaultLevel();

    public LogLevel getLevel();

    public Logger logger();

    public static LoggerLocation getLoggerMethod(String loggerName) {
        Instant start = Instant.now();
        LoggerLocation result = new LoggerLocation();
        result.setLoggerName(loggerName);
        Throwable dummyException = new Throwable();
        StackTraceElement[] locations = dummyException.getStackTrace();
        int nextN = 0;
        if (locations != null && locations.length > nextN) {
            String locationTime;
            boolean bool;
            int deep = locations.length;
            StackTraceElement caller = locations[nextN];
            String moduleName = caller.getModuleName();
            String moduleVersion = caller.getModuleVersion();
            String className = caller.getClassName();
            String methodName = caller.getMethodName();
            int lineNumber = caller.getLineNumber();
            boolean isLoggerClass = ConfigurableLogger.checkLoggerClass(className);
            while (deep > nextN && isLoggerClass) {
                caller = locations[nextN++];
                moduleName = caller.getModuleName();
                moduleVersion = caller.getModuleVersion();
                className = caller.getClassName();
                methodName = caller.getMethodName();
                lineNumber = caller.getLineNumber();
                isLoggerClass = ConfigurableLogger.checkLoggerClass(className);
            }
            if (!isLoggerClass) {
                result.setClassName(className);
                result.setModuleName(moduleName);
                result.setMethodName(methodName);
                result.setLineNumber(lineNumber);
                result.setModuleVersion(moduleVersion);
            }
            if (bool = Boolean.parseBoolean(locationTime = System.getProperty(LOCATION_TIME, "false"))) {
                Instant end = Instant.now();
                Duration between = Duration.between(start, end);
                System.err.println("\u8bf7\u6c42\u65e5\u5fd7\u4f4d\u7f6e\u4fe1\u606f\u82b1\u8d39\u65f6\u95f4\uff1a" + between.toNanos() + "\u7eb3\u79d2\uff1b\u7ea6" + between.toMillis() + "\u6beb\u79d2");
            }
        }
        return result;
    }

    public static boolean checkLoggerClass(String className) {
        return "java.util.Optional".equals(className) || "com.truthbean.Logger".equals(className) || "com.truthbean.logger.BaseLogger".equals(className) || "com.truthbean.logger.DefaultBaseLogger".equals(className) || "com.truthbean.logger.ConfigurableLogger".equals(className) || "com.truthbean.logger.SystemOutLogger".equals(className) || "com.truthbean.logger.StdOutImpl".equals(className) || "com.truthbean.logger.juli.JuliLogger".equals(className) || "com.truthbean.logger.jcl.JclLogger".equals(className) || "com.truthbean.logger.jul.JulLoggerImpl".equals(className) || "com.truthbean.logger.jdk9.JdkSystemLogger".equals(className) || "com.truthbean.logger.slf4j.TruthBeanLogger".equals(className) || "com.truthbean.logger.slf4j.Slf4jImpl".equals(className) || "com.truthbean.logger.slf4j.Slf4jLocationAwareLoggerImpl".equals(className) || "com.truthbean.logger.slf4j.Slf4jLoggerImpl".equals(className) || "com.truthbean.logger.log4j2.TruthBeanLogger".equals(className) || "com.truthbean.logger.log4j2.Log4j2ExtendedLoggerWrapperImpl".equals(className) || "com.truthbean.logger.log4j2.Log4j2Impl".equals(className) || "com.truthbean.logger.log4j2.Log4j2LoggerImpl".equals(className) || "com.truthbean.logger.jul.bridge.JulBridgeLoggerHandler".equals(className) || "java.util.logging.Logger".equals(className) || "java.lang.System.Logger".equals(className) || "sun.util.logging.internal.LoggingProviderImpl$JULWrapper".equals(className) || "sun.rmi.runtime.Log$LoggerLog".equals(className) || "com.sun.jmx.remote.util.ClassLogger".equals(className) || "jdk.internal.logger.AbstractLoggerWrapper".equals(className) || "jdk.internal.net.http.common.Logger".equals(className) || "jdk.internal.net.http.common.Log".equals(className) || "jdk.internal.net.http.common.DebugLogger".equals(className) || "jdk.internal.net.http.hpack.HPACK.Logger".equals(className) || "jdk.internal.net.http.hpack.HPACK.RootLogger".equals(className) || className.startsWith("org.apache.commons.logging") || className.startsWith("org.apache.ibatis.logging") || className.startsWith("org.jboss.logging") || className.startsWith("com.sun.proxy.$Proxy") || className.startsWith("org.springframework.core.log") || className.startsWith("com.alibaba.druid.support.logging") || "org.mybatis.logging.Logger".equals(className) || "org.springframework.boot.logging.DeferredLog".equals(className) || "ch.qos.logback.classic.Logger".equals(className) || "org.apache.kafka.common.utils.LogContext.LocationAwareKafkaLogger".equals(className) || "org.apache.kafka.common.utils.LogContext$LocationAwareKafkaLogger".equals(className) || "org.apache.kafka.common.utils.LogContext.LocationIgnorantKafkaLogger".equals(className) || "org.apache.kafka.common.utils.LogContext$LocationIgnorantKafkaLogger".equals(className) || "org.apache.logging.log4j.spi.AbstractLogger".equals(className) || className.contains(".logging.");
    }
}

