/*
 * Decompiled with CFR 0.152.
 */
package com.truthbean.logger;

import com.truthbean.logger.ConfigurableLogger;
import com.truthbean.logger.LogLevel;
import com.truthbean.logger.LoggerConfig;
import com.truthbean.logger.LoggerFactory;
import com.truthbean.logger.util.MessageHelper;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public interface BaseLogger
extends ConfigurableLogger {
    @Override
    default public LogLevel getLevel() {
        LoggerConfig config = LoggerFactory.getConfig();
        Optional<LogLevel> level = config.getLevel(this.getLoggerName());
        return level.orElseGet(() -> Objects.requireNonNullElse(this.getDefaultLevel(), LogLevel.ERROR));
    }

    @Override
    default public void log(LogLevel level, Object message) {
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), (Throwable)null, (Object[])null);
        }
    }

    @Override
    default public void log(LogLevel level, String message) {
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), (Throwable)null, (Object[])null);
        }
    }

    @Override
    default public void log(LogLevel level, Supplier<String> supplier) {
        if (this.isLoggable(level)) {
            this.log(level, supplier.get(), (Throwable)null, (Object[])null);
        }
    }

    @Override
    default public void log(LogLevel level, Object message, Object ... params) {
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), params, null);
        }
    }

    @Override
    default public void log(LogLevel level, String message, Object ... params) {
        if (this.isLoggable(level)) {
            this.log(level, message, (Throwable)null, params);
        }
    }

    @Override
    default public void log(LogLevel level, Object message, Throwable e) {
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), e, (Object[])null);
        }
    }

    @Override
    default public void log(LogLevel level, String message, Throwable e) {
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), e, (Object[])null);
        }
    }

    @Override
    default public void log(LogLevel level, Supplier<String> supplier, Throwable e) {
        if (this.isLoggable(level)) {
            this.log(level, supplier.get(), e, (Object[])null);
        }
    }

    @Override
    default public void log(LogLevel level, Object message, Throwable e, Object ... params) {
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), e, params);
        }
    }

    @Override
    default public boolean isTraceEnabled() {
        return this.isLoggable(LogLevel.TRACE);
    }

    @Override
    default public void trace(Object message) {
        LogLevel level = LogLevel.TRACE;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), (Throwable)null, (Object[])null);
        }
    }

    @Override
    default public void trace(String message) {
        LogLevel level = LogLevel.TRACE;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), (Throwable)null, (Object[])null);
        }
    }

    @Override
    default public void trace(Supplier<String> supplier) {
        LogLevel level = LogLevel.TRACE;
        if (this.isLoggable(level)) {
            this.log(level, supplier.get(), (Throwable)null, (Object[])null);
        }
    }

    @Override
    default public void trace(Object message, Object ... params) {
        LogLevel level = LogLevel.TRACE;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), params, null);
        }
    }

    @Override
    default public void trace(String message, Object ... params) {
        LogLevel level = LogLevel.TRACE;
        if (this.isLoggable(level)) {
            this.log(level, message, (Throwable)null, params);
        }
    }

    @Override
    default public void trace(Object message, Throwable e) {
        LogLevel level = LogLevel.TRACE;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), e, (Object[])null);
        }
    }

    @Override
    default public void trace(String message, Throwable e) {
        LogLevel level = LogLevel.TRACE;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), e, (Object[])null);
        }
    }

    @Override
    default public void trace(Supplier<String> supplier, Throwable e) {
        LogLevel level = LogLevel.TRACE;
        if (this.isLoggable(level)) {
            this.log(level, supplier.get(), e, (Object[])null);
        }
    }

    @Override
    default public void trace(Object message, Throwable e, Object ... params) {
        LogLevel level = LogLevel.TRACE;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), e, params);
        }
    }

    @Override
    default public void trace(String message, Throwable e, Object ... params) {
        LogLevel level = LogLevel.TRACE;
        if (this.isLoggable(level)) {
            this.log(level, message, e, params);
        }
    }

    @Override
    default public boolean isDebugEnabled() {
        return this.isLoggable(LogLevel.DEBUG);
    }

    @Override
    default public void debug(Object message) {
        LogLevel level = LogLevel.DEBUG;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), (Throwable)null, (Object[])null);
        }
    }

    @Override
    default public void debug(String message) {
        LogLevel level = LogLevel.DEBUG;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), (Throwable)null, (Object[])null);
        }
    }

    @Override
    default public void debug(Supplier<String> supplier) {
        LogLevel level = LogLevel.DEBUG;
        if (this.isLoggable(level)) {
            this.log(level, supplier.get(), (Throwable)null, (Object[])null);
        }
    }

    @Override
    default public void debug(Object message, Object ... params) {
        LogLevel level = LogLevel.DEBUG;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), params, null);
        }
    }

    @Override
    default public void debug(String message, Object ... params) {
        LogLevel level = LogLevel.DEBUG;
        if (this.isLoggable(level)) {
            this.log(level, message, (Throwable)null, params);
        }
    }

    @Override
    default public void debug(Object message, Throwable e) {
        LogLevel level = LogLevel.DEBUG;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), e, (Object[])null);
        }
    }

    @Override
    default public void debug(String message, Throwable e) {
        LogLevel level = LogLevel.DEBUG;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), e, (Object[])null);
        }
    }

    @Override
    default public void debug(Supplier<String> supplier, Throwable e) {
        LogLevel level = LogLevel.DEBUG;
        if (this.isLoggable(level)) {
            this.log(level, supplier.get(), e, (Object[])null);
        }
    }

    @Override
    default public void debug(Object message, Throwable e, Object ... params) {
        LogLevel level = LogLevel.DEBUG;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), e, params);
        }
    }

    @Override
    default public void debug(String message, Throwable e, Object ... params) {
        LogLevel level = LogLevel.DEBUG;
        if (this.isLoggable(level)) {
            this.log(level, message, e, params);
        }
    }

    @Override
    default public boolean isInfoEnabled() {
        return this.isLoggable(LogLevel.INFO);
    }

    @Override
    default public void info(Object message) {
        LogLevel level = LogLevel.INFO;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), (Throwable)null, (Object[])null);
        }
    }

    @Override
    default public void info(String message) {
        LogLevel level = LogLevel.INFO;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), (Throwable)null, (Object[])null);
        }
    }

    @Override
    default public void info(Supplier<String> supplier) {
        LogLevel level = LogLevel.INFO;
        if (this.isLoggable(level)) {
            this.log(level, supplier.get(), (Throwable)null, (Object[])null);
        }
    }

    @Override
    default public void info(Object message, Object ... params) {
        LogLevel level = LogLevel.INFO;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), params, null);
        }
    }

    @Override
    default public void info(String message, Object ... params) {
        LogLevel level = LogLevel.INFO;
        if (this.isLoggable(level)) {
            this.log(level, message, (Throwable)null, params);
        }
    }

    @Override
    default public void info(Object message, Throwable e) {
        LogLevel level = LogLevel.INFO;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), e, (Object[])null);
        }
    }

    @Override
    default public void info(String message, Throwable e) {
        LogLevel level = LogLevel.INFO;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), e, (Object[])null);
        }
    }

    @Override
    default public void info(Supplier<String> supplier, Throwable e) {
        LogLevel level = LogLevel.INFO;
        if (this.isLoggable(level)) {
            this.log(level, supplier.get(), e, (Object[])null);
        }
    }

    @Override
    default public void info(Object message, Throwable e, Object ... params) {
        LogLevel level = LogLevel.INFO;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), e, params);
        }
    }

    @Override
    default public void info(String message, Throwable e, Object ... params) {
        LogLevel level = LogLevel.INFO;
        if (this.isLoggable(level)) {
            this.log(level, message, e, params);
        }
    }

    @Override
    default public boolean isWarnEnabled() {
        return this.isLoggable(LogLevel.WARN);
    }

    @Override
    default public void warn(Object message) {
        LogLevel level = LogLevel.WARN;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), (Throwable)null, (Object[])null);
        }
    }

    @Override
    default public void warn(String message) {
        LogLevel level = LogLevel.WARN;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), (Throwable)null, (Object[])null);
        }
    }

    @Override
    default public void warn(Supplier<String> supplier) {
        LogLevel level = LogLevel.WARN;
        if (this.isLoggable(level)) {
            this.log(level, supplier.get(), (Throwable)null, (Object[])null);
        }
    }

    @Override
    default public void warn(Object message, Object ... params) {
        LogLevel level = LogLevel.WARN;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), params, null);
        }
    }

    @Override
    default public void warn(String message, Object ... params) {
        LogLevel level = LogLevel.WARN;
        if (this.isLoggable(level)) {
            this.log(level, message, (Throwable)null, params);
        }
    }

    @Override
    default public void warn(Object message, Throwable e) {
        LogLevel level = LogLevel.WARN;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), e, (Object[])null);
        }
    }

    @Override
    default public void warn(String message, Throwable e) {
        LogLevel level = LogLevel.WARN;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), e, (Object[])null);
        }
    }

    @Override
    default public void warn(Supplier<String> supplier, Throwable e) {
        LogLevel level = LogLevel.WARN;
        if (this.isLoggable(level)) {
            this.log(level, supplier.get(), e, (Object[])null);
        }
    }

    @Override
    default public void warn(Object message, Throwable e, Object ... params) {
        LogLevel level = LogLevel.WARN;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), e, params);
        }
    }

    @Override
    default public void warn(String message, Throwable e, Object ... params) {
        LogLevel level = LogLevel.WARN;
        if (this.isLoggable(level)) {
            this.log(level, message, e, params);
        }
    }

    @Override
    default public boolean isErrorEnabled() {
        return this.isLoggable(LogLevel.ERROR);
    }

    @Override
    default public void error(Object message) {
        LogLevel level = LogLevel.ERROR;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), (Throwable)null, (Object[])null);
        }
    }

    @Override
    default public void error(String message) {
        LogLevel level = LogLevel.ERROR;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), (Throwable)null, (Object[])null);
        }
    }

    @Override
    default public void error(Supplier<String> supplier) {
        LogLevel level = LogLevel.ERROR;
        if (this.isLoggable(level)) {
            this.log(level, supplier.get(), (Throwable)null, (Object[])null);
        }
    }

    @Override
    default public void error(Object message, Object ... params) {
        LogLevel level = LogLevel.ERROR;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), params, null);
        }
    }

    @Override
    default public void error(String message, Object ... params) {
        LogLevel level = LogLevel.ERROR;
        if (this.isLoggable(level)) {
            this.log(level, message, (Throwable)null, params);
        }
    }

    @Override
    default public void error(Object message, Throwable e) {
        LogLevel level = LogLevel.ERROR;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), e, (Object[])null);
        }
    }

    @Override
    default public void error(String message, Throwable e) {
        LogLevel level = LogLevel.ERROR;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), e, (Object[])null);
        }
    }

    @Override
    default public void error(Supplier<String> supplier, Throwable e) {
        LogLevel level = LogLevel.ERROR;
        if (this.isLoggable(level)) {
            this.log(level, supplier.get(), e, (Object[])null);
        }
    }

    @Override
    default public void error(Object message, Throwable e, Object ... params) {
        LogLevel level = LogLevel.ERROR;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), e, params);
        }
    }

    @Override
    default public void error(String message, Throwable e, Object ... params) {
        LogLevel level = LogLevel.ERROR;
        if (this.isLoggable(level)) {
            this.log(level, message, e, params);
        }
    }

    @Override
    default public boolean isFatalEnabled() {
        return this.isLoggable(LogLevel.FATAL);
    }

    @Override
    default public void fatal(Object message) {
        LogLevel level = LogLevel.FATAL;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), (Throwable)null, (Object[])null);
        }
    }

    @Override
    default public void fatal(String message) {
        LogLevel level = LogLevel.FATAL;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), (Throwable)null, (Object[])null);
        }
    }

    @Override
    default public void fatal(Supplier<String> supplier) {
        LogLevel level = LogLevel.FATAL;
        if (this.isLoggable(level)) {
            this.log(level, supplier.get(), (Throwable)null, (Object[])null);
        }
    }

    @Override
    default public void fatal(Object message, Object ... params) {
        LogLevel level = LogLevel.FATAL;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), params, null);
        }
    }

    @Override
    default public void fatal(String message, Object ... params) {
        LogLevel level = LogLevel.FATAL;
        if (this.isLoggable(level)) {
            this.log(level, message, (Throwable)null, params);
        }
    }

    @Override
    default public void fatal(Object message, Throwable e) {
        LogLevel level = LogLevel.FATAL;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), e, (Object[])null);
        }
    }

    @Override
    default public void fatal(String message, Throwable e) {
        LogLevel level = LogLevel.FATAL;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), e, (Object[])null);
        }
    }

    @Override
    default public void fatal(Supplier<String> supplier, Throwable e) {
        LogLevel level = LogLevel.FATAL;
        if (this.isLoggable(level)) {
            this.log(level, supplier.get(), e, (Object[])null);
        }
    }

    @Override
    default public void fatal(Object message, Throwable e, Object ... params) {
        LogLevel level = LogLevel.FATAL;
        if (this.isLoggable(level)) {
            this.log(level, MessageHelper.toString(message), e, params);
        }
    }

    @Override
    default public void fatal(String message, Throwable e, Object ... params) {
        LogLevel level = LogLevel.FATAL;
        if (this.isLoggable(level)) {
            this.log(level, message, e, params);
        }
    }
}

