/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.json.impl;

import com.sun.jersey.api.json.JSONConfiguration;
import com.sun.jersey.json.impl.JSONUnmarshallerImpl;
import com.sun.jersey.json.impl.reader.Jackson2StaxReader;
import com.sun.jersey.json.impl.reader.JacksonRootAddingParser;
import com.sun.jersey.json.impl.reader.JsonXmlStreamReader;
import com.sun.jersey.json.impl.writer.JacksonArrayWrapperGenerator;
import com.sun.jersey.json.impl.writer.JacksonRootStrippingGenerator;
import com.sun.jersey.json.impl.writer.JsonXmlStreamWriter;
import com.sun.jersey.json.impl.writer.Stax2JacksonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jettison.badgerfish.BadgerFishXMLStreamReader;
import org.codehaus.jettison.badgerfish.BadgerFishXMLStreamWriter;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONTokener;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.codehaus.jettison.mapped.MappedXMLStreamReader;
import org.codehaus.jettison.mapped.MappedXMLStreamWriter;

public class Stax2JsonFactory {
    private Stax2JsonFactory() {
    }

    public static XMLStreamWriter createWriter(Writer writer, JSONConfiguration config) throws IOException {
        return Stax2JsonFactory.createWriter(writer, config, false);
    }

    public static XMLStreamWriter createWriter(Writer writer, JSONConfiguration config, boolean writingList) throws IOException {
        switch (config.getNotation()) {
            case NATURAL: {
                JsonGenerator bodyGenerator;
                JsonGenerator rawGenerator = new JsonFactory().createJsonGenerator(writer);
                if (config.isHumanReadableFormatting()) {
                    rawGenerator.useDefaultPrettyPrinter();
                }
                JsonGenerator jsonGenerator = bodyGenerator = writingList ? JacksonArrayWrapperGenerator.createArrayWrapperGenerator(rawGenerator) : rawGenerator;
                if (config.isRootUnwrapping()) {
                    return new Stax2JacksonWriter(JacksonRootStrippingGenerator.createRootStrippingGenerator(bodyGenerator), config);
                }
                return new Stax2JacksonWriter(bodyGenerator, config);
            }
            case MAPPED: {
                return JsonXmlStreamWriter.createWriter(writer, config);
            }
            case BADGERFISH: {
                return new BadgerFishXMLStreamWriter(writer);
            }
            case MAPPED_JETTISON: {
                Configuration jmConfig = null == config.getXml2JsonNs() ? new Configuration() : new Configuration(config.getXml2JsonNs());
                return new MappedXMLStreamWriter(new MappedNamespaceConvention(jmConfig), writer);
            }
        }
        return null;
    }

    public static XMLStreamReader createReader(Reader reader, JSONConfiguration config, String rootName) {
        return Stax2JsonFactory.createReader(reader, config, rootName, false);
    }

    public static XMLStreamReader createReader(Reader reader, JSONConfiguration config, String rootName, boolean readingList) {
        switch (config.getNotation()) {
            case NATURAL: {
                try {
                    JsonParser nonListParser;
                    JsonParser rawParser = new JsonFactory().createJsonParser(reader);
                    JsonParser jsonParser = nonListParser = config.isRootUnwrapping() ? JacksonRootAddingParser.createRootAddingParser(rawParser, rootName) : rawParser;
                    if (!readingList) {
                        return new Jackson2StaxReader(nonListParser, config);
                    }
                    return new Jackson2StaxReader(JacksonRootAddingParser.createRootAddingParser(nonListParser, "jsonArrayRootElement"), config);
                }
                catch (Exception ex) {
                    Logger.getLogger(JSONUnmarshallerImpl.class.getName()).log(Level.SEVERE, null, ex);
                    break;
                }
            }
            case MAPPED: {
                try {
                    return new JsonXmlStreamReader(reader, rootName, config);
                }
                catch (IOException ex) {
                    Logger.getLogger(JSONUnmarshallerImpl.class.getName()).log(Level.SEVERE, null, ex);
                    break;
                }
            }
            case MAPPED_JETTISON: {
                try {
                    Configuration jmConfig = null == config.getXml2JsonNs() ? new Configuration() : new Configuration(config.getXml2JsonNs());
                    return new MappedXMLStreamReader(new JSONObject(new JSONTokener(Stax2JsonFactory.readFromAsString(reader))), new MappedNamespaceConvention(jmConfig));
                }
                catch (Exception ex) {
                    Logger.getLogger(JSONUnmarshallerImpl.class.getName()).log(Level.SEVERE, null, ex);
                    break;
                }
            }
            case BADGERFISH: {
                try {
                    return new BadgerFishXMLStreamReader(new JSONObject(new JSONTokener(Stax2JsonFactory.readFromAsString(reader))));
                }
                catch (Exception ex) {
                    Logger.getLogger(JSONUnmarshallerImpl.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return null;
    }

    private static String readFromAsString(Reader reader) throws IOException {
        int l;
        StringBuilder sb = new StringBuilder();
        char[] c = new char[1024];
        while ((l = reader.read(c)) != -1) {
            sb.append(c, 0, l);
        }
        return sb.toString();
    }
}

