/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.AbstractCommand;
import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixExecutable;
import com.netflix.hystrix.HystrixInvokableInfo;
import com.netflix.hystrix.HystrixObservable;
import com.netflix.hystrix.HystrixThreadPool;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import com.netflix.hystrix.strategy.executionhook.HystrixCommandExecutionHook;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Func0;

public abstract class HystrixCommand<R>
extends AbstractCommand<R>
implements HystrixExecutable<R>,
HystrixInvokableInfo<R>,
HystrixObservable<R> {
    private final AtomicReference<Thread> executionThread = new AtomicReference();
    private final AtomicBoolean interruptOnFutureCancel = new AtomicBoolean(false);

    protected HystrixCommand(HystrixCommandGroupKey group) {
        super(group, null, null, null, null, null, null, null, null, null, null, null);
    }

    protected HystrixCommand(HystrixCommandGroupKey group, HystrixThreadPoolKey threadPool) {
        super(group, null, threadPool, null, null, null, null, null, null, null, null, null);
    }

    protected HystrixCommand(HystrixCommandGroupKey group, int executionIsolationThreadTimeoutInMilliseconds) {
        super(group, null, null, null, null, HystrixCommandProperties.Setter().withExecutionTimeoutInMilliseconds(executionIsolationThreadTimeoutInMilliseconds), null, null, null, null, null, null);
    }

    protected HystrixCommand(HystrixCommandGroupKey group, HystrixThreadPoolKey threadPool, int executionIsolationThreadTimeoutInMilliseconds) {
        super(group, null, threadPool, null, null, HystrixCommandProperties.Setter().withExecutionTimeoutInMilliseconds(executionIsolationThreadTimeoutInMilliseconds), null, null, null, null, null, null);
    }

    protected HystrixCommand(Setter setter) {
        this(setter.groupKey, setter.commandKey, setter.threadPoolKey, null, null, setter.commandPropertiesDefaults, setter.threadPoolPropertiesDefaults, null, null, null, null, null);
    }

    HystrixCommand(HystrixCommandGroupKey group, HystrixCommandKey key, HystrixThreadPoolKey threadPoolKey, HystrixCircuitBreaker circuitBreaker, HystrixThreadPool threadPool, HystrixCommandProperties.Setter commandPropertiesDefaults, HystrixThreadPoolProperties.Setter threadPoolPropertiesDefaults, HystrixCommandMetrics metrics, AbstractCommand.TryableSemaphore fallbackSemaphore, AbstractCommand.TryableSemaphore executionSemaphore, HystrixPropertiesStrategy propertiesStrategy, HystrixCommandExecutionHook executionHook) {
        super(group, key, threadPoolKey, circuitBreaker, threadPool, commandPropertiesDefaults, threadPoolPropertiesDefaults, metrics, fallbackSemaphore, executionSemaphore, propertiesStrategy, executionHook);
    }

    protected abstract R run() throws Exception;

    protected R getFallback() {
        throw new UnsupportedOperationException("No fallback available.");
    }

    @Override
    protected final Observable<R> getExecutionObservable() {
        return Observable.defer((Func0)new Func0<Observable<R>>(){

            public Observable<R> call() {
                try {
                    return Observable.just(HystrixCommand.this.run());
                }
                catch (Throwable ex) {
                    return Observable.error((Throwable)ex);
                }
            }
        }).doOnSubscribe(new Action0(){

            public void call() {
                HystrixCommand.this.executionThread.set(Thread.currentThread());
            }
        });
    }

    @Override
    protected final Observable<R> getFallbackObservable() {
        return Observable.defer((Func0)new Func0<Observable<R>>(){

            public Observable<R> call() {
                try {
                    return Observable.just(HystrixCommand.this.getFallback());
                }
                catch (Throwable ex) {
                    return Observable.error((Throwable)ex);
                }
            }
        });
    }

    @Override
    public R execute() {
        try {
            return this.queue().get();
        }
        catch (Exception e) {
            throw this.decomposeException(e);
        }
    }

    @Override
    public Future<R> queue() {
        final Future delegate = this.toObservable().toBlocking().toFuture();
        Future f = new Future<R>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                Thread t;
                if (delegate.isCancelled()) {
                    return false;
                }
                if (HystrixCommand.this.getProperties().executionIsolationThreadInterruptOnFutureCancel().get().booleanValue()) {
                    HystrixCommand.this.interruptOnFutureCancel.compareAndSet(false, mayInterruptIfRunning);
                }
                boolean res = delegate.cancel(HystrixCommand.this.interruptOnFutureCancel.get());
                if (!HystrixCommand.this.isExecutionComplete() && HystrixCommand.this.interruptOnFutureCancel.get() && (t = (Thread)HystrixCommand.this.executionThread.get()) != null && !t.equals(Thread.currentThread())) {
                    t.interrupt();
                }
                return res;
            }

            @Override
            public boolean isCancelled() {
                return delegate.isCancelled();
            }

            @Override
            public boolean isDone() {
                return delegate.isDone();
            }

            @Override
            public R get() throws InterruptedException, ExecutionException {
                return delegate.get();
            }

            @Override
            public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return delegate.get(timeout, unit);
            }
        };
        if (f.isDone()) {
            try {
                f.get();
                return f;
            }
            catch (Exception e) {
                RuntimeException re = this.decomposeException(e);
                if (re instanceof HystrixBadRequestException) {
                    return f;
                }
                if (re instanceof HystrixRuntimeException) {
                    HystrixRuntimeException hre = (HystrixRuntimeException)re;
                    switch (hre.getFailureType()) {
                        case COMMAND_EXCEPTION: 
                        case TIMEOUT: {
                            return f;
                        }
                    }
                    throw hre;
                }
                throw re;
            }
        }
        return f;
    }

    @Override
    protected String getFallbackMethodName() {
        return "getFallback";
    }

    @Override
    protected boolean isFallbackUserDefined() {
        Boolean toInsertIntoMap;
        Boolean containsFromMap = (Boolean)commandContainsFallback.get(this.commandKey);
        if (containsFromMap != null) {
            return containsFromMap;
        }
        try {
            this.getClass().getDeclaredMethod("getFallback", new Class[0]);
            toInsertIntoMap = true;
        }
        catch (NoSuchMethodException nsme) {
            toInsertIntoMap = false;
        }
        commandContainsFallback.put(this.commandKey, toInsertIntoMap);
        return toInsertIntoMap;
    }

    @Override
    protected boolean commandIsScalar() {
        return true;
    }

    public static final class Setter {
        protected final HystrixCommandGroupKey groupKey;
        protected HystrixCommandKey commandKey;
        protected HystrixThreadPoolKey threadPoolKey;
        protected HystrixCommandProperties.Setter commandPropertiesDefaults;
        protected HystrixThreadPoolProperties.Setter threadPoolPropertiesDefaults;

        protected Setter(HystrixCommandGroupKey groupKey) {
            this.groupKey = groupKey;
        }

        public static Setter withGroupKey(HystrixCommandGroupKey groupKey) {
            return new Setter(groupKey);
        }

        public Setter andCommandKey(HystrixCommandKey commandKey) {
            this.commandKey = commandKey;
            return this;
        }

        public Setter andThreadPoolKey(HystrixThreadPoolKey threadPoolKey) {
            this.threadPoolKey = threadPoolKey;
            return this;
        }

        public Setter andCommandPropertiesDefaults(HystrixCommandProperties.Setter commandPropertiesDefaults) {
            this.commandPropertiesDefaults = commandPropertiesDefaults;
            return this;
        }

        public Setter andThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter threadPoolPropertiesDefaults) {
            this.threadPoolPropertiesDefaults = threadPoolPropertiesDefaults;
            return this;
        }
    }
}

