/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import java.util.function.Supplier;
import oshi.hardware.common.AbstractFirmware;
import oshi.util.Memoizer;
import oshi.util.Util;
import oshi.util.platform.windows.WmiQueryHandler;
import oshi.util.platform.windows.WmiUtil;

final class WindowsFirmware
extends AbstractFirmware {
    private final Supplier<WmiStrings> wmi = Memoizer.memoize(this::queryWmi);

    WindowsFirmware() {
    }

    @Override
    public String getManufacturer() {
        return this.wmi.get().manufacturer;
    }

    @Override
    public String getName() {
        return this.wmi.get().name;
    }

    @Override
    public String getDescription() {
        return this.wmi.get().description;
    }

    @Override
    public String getVersion() {
        return this.wmi.get().version;
    }

    @Override
    public String getReleaseDate() {
        return this.wmi.get().releaseDate;
    }

    private WmiStrings queryWmi() {
        WbemcliUtil.WmiQuery biosQuery = new WbemcliUtil.WmiQuery("Win32_BIOS where PrimaryBIOS=true", BiosProperty.class);
        WbemcliUtil.WmiResult win32BIOS = WmiQueryHandler.createInstance().queryWMI(biosQuery);
        if (win32BIOS.getResultCount() > 0) {
            return new WmiStrings(WmiUtil.getString(win32BIOS, BiosProperty.MANUFACTURER, 0), WmiUtil.getString(win32BIOS, BiosProperty.NAME, 0), WmiUtil.getString(win32BIOS, BiosProperty.DESCRIPTION, 0), WmiUtil.getString(win32BIOS, BiosProperty.VERSION, 0), WmiUtil.getDateString(win32BIOS, BiosProperty.RELEASEDATE, 0));
        }
        return new WmiStrings("unknown", "unknown", "unknown", "unknown", "unknown");
    }

    private static final class WmiStrings {
        private final String releaseDate;
        private final String manufacturer;
        private final String version;
        private final String name;
        private final String description;

        private WmiStrings(String releaseDate, String manufacturer, String version, String name, String description) {
            this.releaseDate = Util.isBlank(releaseDate) ? "unknown" : releaseDate;
            this.manufacturer = Util.isBlank(manufacturer) ? "unknown" : manufacturer;
            this.version = Util.isBlank(version) ? "unknown" : version;
            this.name = Util.isBlank(name) ? "unknown" : name;
            this.description = Util.isBlank(description) ? "unknown" : description;
        }
    }

    static enum BiosProperty {
        MANUFACTURER,
        NAME,
        DESCRIPTION,
        VERSION,
        RELEASEDATE;

    }
}

