/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oshi.hardware.Disks;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HWPartition;
import oshi.jna.platform.windows.Kernel32;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsDisks
implements Disks {
    private static final long serialVersionUID = 1L;
    private static Map<String, Long> readMap = new HashMap<String, Long>();
    private static Map<String, Long> readByteMap = new HashMap<String, Long>();
    private static Map<String, Long> writeMap = new HashMap<String, Long>();
    private static Map<String, Long> writeByteMap = new HashMap<String, Long>();
    private static Map<String, Long> xferTimeMap = new HashMap<String, Long>();
    private static Map<String, Long> timeStampMap = new HashMap<String, Long>();
    private static Map<String, List<String>> driveToPartitionMap = new HashMap<String, List<String>>();
    private static Map<String, String> partitionToLogicalDriveMap = new HashMap<String, String>();
    private static Map<String, HWPartition> partitionMap = new HashMap<String, HWPartition>();
    private static final WmiUtil.ValueType[] DRIVE_TYPES = new WmiUtil.ValueType[]{WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.UINT32};
    private static final WmiUtil.ValueType[] READ_WRITE_TYPES = new WmiUtil.ValueType[]{WmiUtil.ValueType.STRING, WmiUtil.ValueType.UINT32, WmiUtil.ValueType.STRING, WmiUtil.ValueType.UINT32, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING};
    private static final WmiUtil.ValueType[] PARTITION_TYPES = new WmiUtil.ValueType[]{WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.UINT32, WmiUtil.ValueType.UINT32};
    private static final Pattern DEVICE_ID = Pattern.compile(".*\\.DeviceID=\"(.*)\"");
    private static final int BUFSIZE = 255;

    @Override
    public HWDiskStore[] getDisks() {
        ArrayList<HWDiskStore> result = new ArrayList<HWDiskStore>();
        this.populateReadWriteMaps();
        this.populatePartitionMaps();
        Map<String, List<Object>> vals = WmiUtil.selectObjectsFrom(null, "Win32_DiskDrive", "Name,Manufacturer,Model,SerialNumber,Size,Index", null, DRIVE_TYPES);
        for (int i = 0; i < vals.get("Name").size(); ++i) {
            HWDiskStore ds = new HWDiskStore();
            ds.setName((String)vals.get("Name").get(i));
            ds.setModel(String.format("%s %s", vals.get("Model").get(i), vals.get("Manufacturer").get(i)).trim());
            ds.setSerial(ParseUtil.hexStringToString((String)vals.get("SerialNumber").get(i)));
            String index = vals.get("Index").get(i).toString();
            ds.setReads(readMap.getOrDefault(index, 0L));
            ds.setReadBytes(readByteMap.getOrDefault(index, 0L));
            ds.setWrites(writeMap.getOrDefault(index, 0L));
            ds.setWriteBytes(writeByteMap.getOrDefault(index, 0L));
            ds.setTransferTime(xferTimeMap.getOrDefault(index, 0L));
            ds.setTimeStamp(timeStampMap.getOrDefault(index, 0L));
            ds.setSize(ParseUtil.parseLongOrDefault((String)vals.get("Size").get(i), 0L));
            ArrayList<HWPartition> partitions = new ArrayList<HWPartition>();
            List<String> partList = driveToPartitionMap.get(ds.getName());
            if (partList != null && !partList.isEmpty()) {
                for (String part : partList) {
                    partitions.add(partitionMap.get(part));
                }
            }
            ds.setPartitions(partitions.toArray(new HWPartition[partitions.size()]));
            result.add(ds);
        }
        return result.toArray(new HWDiskStore[result.size()]);
    }

    private void populateReadWriteMaps() {
        readMap.clear();
        readByteMap.clear();
        writeMap.clear();
        writeByteMap.clear();
        xferTimeMap.clear();
        timeStampMap.clear();
        Map<String, List<Object>> vals = WmiUtil.selectObjectsFrom(null, "Win32_PerfRawData_PerfDisk_PhysicalDisk", "Name,DiskReadsPerSec,DiskReadBytesPerSec,DiskWritesPerSec,DiskWriteBytesPerSec,PercentDiskTime,Timestamp_Sys100NS", null, READ_WRITE_TYPES);
        for (int i = 0; i < vals.get("Name").size(); ++i) {
            String name = ((String)vals.get("Name").get(i)).split("\\s+")[0];
            readMap.put(name, (long)((Long)vals.get("DiskReadsPerSec").get(i)));
            readByteMap.put(name, ParseUtil.parseLongOrDefault((String)vals.get("DiskReadBytesPerSec").get(i), 0L));
            writeMap.put(name, (long)((Long)vals.get("DiskWritesPerSec").get(i)));
            writeByteMap.put(name, ParseUtil.parseLongOrDefault((String)vals.get("DiskWriteBytesPerSec").get(i), 0L));
            xferTimeMap.put(name, ParseUtil.parseLongOrDefault((String)vals.get("PercentDiskTime").get(i), 0L) / 10000L);
            timeStampMap.put(name, ParseUtil.parseLongOrDefault((String)vals.get("Timestamp_Sys100NS").get(i), 0L) / 10000L);
        }
    }

    private void populatePartitionMaps() {
        Matcher mDep;
        Matcher mAnt;
        int i;
        driveToPartitionMap.clear();
        partitionToLogicalDriveMap.clear();
        partitionMap.clear();
        Map<String, List<String>> partitionQueryMap = WmiUtil.selectStringsFrom(null, "Win32_DiskDriveToDiskPartition", "Antecedent,Dependent", null);
        for (i = 0; i < partitionQueryMap.get("Antecedent").size(); ++i) {
            mAnt = DEVICE_ID.matcher(partitionQueryMap.get("Antecedent").get(i));
            mDep = DEVICE_ID.matcher(partitionQueryMap.get("Dependent").get(i));
            if (!mAnt.matches() || !mDep.matches()) continue;
            driveToPartitionMap.computeIfAbsent(mAnt.group(1).replaceAll("\\\\\\\\", "\\\\"), k -> new ArrayList()).add(mDep.group(1));
        }
        partitionQueryMap = WmiUtil.selectStringsFrom(null, "Win32_LogicalDiskToPartition", "Antecedent,Dependent", null);
        for (i = 0; i < partitionQueryMap.get("Antecedent").size(); ++i) {
            mAnt = DEVICE_ID.matcher(partitionQueryMap.get("Antecedent").get(i));
            mDep = DEVICE_ID.matcher(partitionQueryMap.get("Dependent").get(i));
            if (!mAnt.matches() || !mDep.matches()) continue;
            partitionToLogicalDriveMap.put(mAnt.group(1), mDep.group(1) + "\\");
        }
        Map<String, List<Object>> hwPartitionQueryMap = WmiUtil.selectObjectsFrom(null, "Win32_DiskPartition", "Name,Type,Description,DeviceID,Size,DiskIndex,Index", null, PARTITION_TYPES);
        for (int i2 = 0; i2 < hwPartitionQueryMap.get("Name").size(); ++i2) {
            String deviceID = (String)hwPartitionQueryMap.get("DeviceID").get(i2);
            String logicalDrive = partitionToLogicalDriveMap.getOrDefault(deviceID, "");
            String uuid = "";
            if (!logicalDrive.isEmpty()) {
                char[] volumeChr = new char[255];
                Kernel32.INSTANCE.GetVolumeNameForVolumeMountPoint(logicalDrive, volumeChr, 255);
                uuid = ParseUtil.parseUuidOrDefault(new String(volumeChr).trim(), "");
            }
            partitionMap.put(deviceID, new HWPartition((String)hwPartitionQueryMap.get("Name").get(i2), (String)hwPartitionQueryMap.get("Type").get(i2), (String)hwPartitionQueryMap.get("Description").get(i2), uuid, ParseUtil.parseLongOrDefault((String)hwPartitionQueryMap.get("Size").get(i2), 0L), ((Long)hwPartitionQueryMap.get("DiskIndex").get(i2)).intValue(), ((Long)hwPartitionQueryMap.get("Index").get(i2)).intValue(), logicalDrive));
        }
    }
}

