/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.converts;

import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.ITypeConvert;
import com.baomidou.mybatisplus.generator.config.rules.DbColumnType;
import com.baomidou.mybatisplus.generator.config.rules.IColumnType;

public class DmTypeConvert
implements ITypeConvert {
    @Override
    public IColumnType processTypeConvert(GlobalConfig globalConfig, String fieldType) {
        String t = fieldType.toLowerCase();
        return new BasicDataTypeHandler().getDbColumnType(t);
    }

    class MultimediaDataTypeHandler
    implements Handler {
        MultimediaDataTypeHandler() {
        }

        @Override
        public DbColumnType getDbColumnType(String fieldType) {
            if (fieldType.contains("text") || fieldType.contains("longvarchar")) {
                return DbColumnType.STRING;
            }
            if (fieldType.contains("clob")) {
                return DbColumnType.CLOB;
            }
            if (fieldType.contains("blob")) {
                return DbColumnType.BLOB;
            }
            if (fieldType.contains("image")) {
                return DbColumnType.BYTE_ARRAY;
            }
            return DbColumnType.STRING;
        }
    }

    class DateTimeDataTypeHandler
    implements Handler {
        DateTimeDataTypeHandler() {
        }

        @Override
        public DbColumnType getDbColumnType(String fieldType) {
            if (fieldType.contains("date") || fieldType.contains("time") || fieldType.contains("timestamp")) {
                return DbColumnType.DATE;
            }
            return new MultimediaDataTypeHandler().getDbColumnType(fieldType);
        }
    }

    class BasicDataTypeHandler
    implements Handler {
        BasicDataTypeHandler() {
        }

        @Override
        public DbColumnType getDbColumnType(String fieldType) {
            if (fieldType.contains("char")) {
                return DbColumnType.STRING;
            }
            if (fieldType.contains("numeric") || fieldType.contains("decimal") || fieldType.contains("dec") || fieldType.contains("money")) {
                return DbColumnType.BIG_DECIMAL;
            }
            if (fieldType.contains("bit") || fieldType.contains("bool") || fieldType.contains("boolean")) {
                return DbColumnType.BOOLEAN;
            }
            if (fieldType.contains("integer") || fieldType.contains("int")) {
                return DbColumnType.INTEGER;
            }
            if (fieldType.contains("bigint")) {
                return DbColumnType.BIG_INTEGER;
            }
            if (fieldType.contains("tinyint") || fieldType.contains("byte") || fieldType.contains("smallint")) {
                return DbColumnType.INTEGER;
            }
            if (fieldType.contains("binary") || fieldType.contains("varbinary")) {
                return DbColumnType.BYTE_ARRAY;
            }
            if (fieldType.contains("float")) {
                return DbColumnType.FLOAT;
            }
            if (fieldType.contains("double") || fieldType.contains("real")) {
                return DbColumnType.DOUBLE;
            }
            return new DateTimeDataTypeHandler().getDbColumnType(fieldType);
        }
    }

    static interface Handler {
        public DbColumnType getDbColumnType(String var1);
    }
}

