/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.handlers;

import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class BlobTypeHandler
extends BaseTypeHandler<String> {
    public void setNonNullParameter(PreparedStatement ps, int i, String parameter, JdbcType jdbcType) throws SQLException {
        try {
            ps.setBinaryStream(i, (InputStream)new ByteArrayInputStream(parameter.getBytes("UTF-8")), parameter.length());
        }
        catch (UnsupportedEncodingException e) {
            throw new MybatisPlusException("Blob Encoding Error!");
        }
    }

    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return StringUtils.blob2String((Blob)rs.getBlob(columnName));
    }

    public String getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return StringUtils.blob2String((Blob)cs.getBlob(columnIndex));
    }

    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return null;
    }
}

