/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.security;

import com.alibaba.schedulerx.common.domain.JSONResult;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.HttpResponse;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.JsonNode;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.Unirest;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.exceptions.UnirestException;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.Configuration;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.worker.exception.AuthenticateException;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.security.Authenticator;
import java.util.HashMap;
import java.util.Set;

public class AliyunAuthenticator
implements Authenticator {
    private static final String AUTHENTICATE_DAUTH = "authenticate_dauth";
    private static final String AUTHENTICATE_RAM = "authenticate_ram";
    private static final String AUTHENTICATE_STS = "authenticate_sts";
    private static final String AUTHENTICATE_URL = "/worker/v1/appgroup/authenticate";
    private static final Logger LOGGER = LogFactory.getLogger(AliyunAuthenticator.class);

    @Override
    public void authenticate(Configuration conf, Set<String> groupIds) throws AuthenticateException {
        String acessKey = "";
        String secretKey = "";
        String secretToken = "";
        String authenticateType = "";
        if (StringUtils.isNotBlank(conf.getString("dauth.accessKey"))) {
            acessKey = conf.getString("dauth.accessKey");
            secretKey = conf.getString("dauth.secretKey");
            authenticateType = AUTHENTICATE_DAUTH;
            conf.setProperty("schedulerx.worker.source", "edas");
        } else if (StringUtils.isNotBlank(conf.getString("sts.accessKey"))) {
            acessKey = conf.getString("sts.accessKey");
            secretKey = conf.getString("sts.secretKey");
            secretToken = conf.getString("sts.token");
            authenticateType = AUTHENTICATE_STS;
        } else {
            acessKey = conf.getString("aliyun.accessKey");
            secretKey = conf.getString("aliyun.secretKey");
            authenticateType = AUTHENTICATE_RAM;
        }
        if (StringUtils.isBlank(acessKey)) {
            throw new AuthenticateException("ak is blank");
        }
        if (StringUtils.isBlank(secretKey)) {
            throw new AuthenticateException("sk is blank");
        }
        JSONResult result = this.authenticateFromConsole(acessKey, secretKey, secretToken, authenticateType, conf.getString("schedulerx.namespace"), conf.getString("schedulerx.namespace.source"), StringUtils.join(groupIds, ","));
        if (result != null) {
            if (!result.isSuccess() || !((Boolean)result.getData()).booleanValue()) {
                throw new AuthenticateException(result.getMessage());
            }
        } else {
            throw new AuthenticateException("authenticate result is null");
        }
    }

    private JSONResult authenticateFromConsole(String accessKey, String secretKey, String secretToken, String authenticateType, String namespace, String namespaceSource, String groups) {
        String domain;
        JSONResult result = JSONResult.geneFailResult();
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put("groups", groups);
        parameterMap.put("accessKey", accessKey);
        parameterMap.put("secretKey", secretKey);
        parameterMap.put("secretToken", secretToken);
        parameterMap.put("namespace", namespace);
        LOGGER.info("ak:{} sk:{} type:{}", accessKey, secretKey, authenticateType);
        parameterMap.put("type", authenticateType);
        if (StringUtils.isNotBlank(namespaceSource)) {
            parameterMap.put("namespaceSource", namespaceSource);
        }
        if (StringUtils.isNotBlank(domain = ConfigUtil.getWorkerConfig().getString("domainName"))) {
            String url = "http://" + domain + AUTHENTICATE_URL;
            try {
                HttpResponse<JsonNode> jsonResponse = Unirest.post(url).fields(parameterMap).asJson();
                if (jsonResponse != null) {
                    result = JsonUtil.fromJson(jsonResponse.getBody().toString(), JSONResult.class);
                }
            }
            catch (UnirestException e) {
                LOGGER.error("groupIds: {} authenticate error, url={}", groups, url, e);
            }
        }
        return result;
    }
}

