/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.processor;

import com.alibaba.schedulerx.shade.com.google.common.io.Files;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.worker.domain.JobContext;
import com.alibaba.schedulerx.worker.processor.ShellProcessor;
import java.io.File;
import java.io.IOException;

public class PythonProcessor
extends ShellProcessor {
    public static final String PYTHON_SCRIPT_PREFIX = System.getProperties().getProperty("user.home") + "/script/python/";
    private String fileName;

    @Override
    public void preProcess(JobContext context) throws Exception {
        super.preProcess(context);
        File dir = new File(PYTHON_SCRIPT_PREFIX);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.fileName = this.writePythonScript(context);
    }

    @Override
    protected String[] getContent(JobContext context) {
        String[] parameters = StringUtils.isNotEmpty(context.getShardingParameter()) ? new String[]{String.valueOf(context.getShardingId()), context.getShardingParameter()} : (StringUtils.isNotEmpty(context.getInstanceParameters()) ? context.getInstanceParameters().trim().split(" ") : context.getJobParameters().trim().split(" "));
        String[] contents = new String[2 + parameters.length];
        contents[0] = "python";
        contents[1] = this.fileName;
        for (int i = 0; i < parameters.length; ++i) {
            contents[2 + i] = parameters[i];
        }
        return contents;
    }

    private String writePythonScript(JobContext context) throws IOException {
        long jobId = context.getJobId();
        String fileName = PYTHON_SCRIPT_PREFIX + "python_" + jobId + ".py";
        String content = "# -*- coding: utf-8 -*-" + System.lineSeparator() + context.getContent();
        Files.write(content.getBytes(), new File(fileName));
        return fileName;
    }
}

