/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.master.persistence;

import com.alibaba.schedulerx.protocol.Worker;
import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.shade.com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PersistenceUtil {
    public static Map<Integer, Map<String, List<Long>>> getTaskStatusMap(List<Worker.ContainerReportTaskStatusRequest> taskStatusInfos) {
        HashMap<Integer, Map<String, List<Long>>> status2WorkIdAddr2TaskIds = Maps.newHashMap();
        for (Worker.ContainerReportTaskStatusRequest e : taskStatusInfos) {
            Integer status = e.getStatus();
            String workerIdAddr = e.getWorkerId() + "@" + e.getWorkerAddr();
            Long taskId = e.getTaskId();
            PersistenceUtil.addTaskStatusInfo(status2WorkIdAddr2TaskIds, status, workerIdAddr, taskId);
        }
        return status2WorkIdAddr2TaskIds;
    }

    public static void addTaskStatusInfo(Map<Integer, Map<String, List<Long>>> status2WorkIdAddr2TaskIds, Integer status, String workerIdAddr, Long taskId) {
        if (!status2WorkIdAddr2TaskIds.containsKey(status)) {
            HashMap<String, ArrayList<Long>> workerAddr2TaskIds = Maps.newHashMap();
            workerAddr2TaskIds.put(workerIdAddr, Lists.newArrayList(taskId));
            status2WorkIdAddr2TaskIds.put(status, workerAddr2TaskIds);
        } else {
            Map<String, List<Long>> workerIdAddr2TaskIds = status2WorkIdAddr2TaskIds.get(status);
            if (!workerIdAddr2TaskIds.containsKey(workerIdAddr)) {
                workerIdAddr2TaskIds.put(workerIdAddr, Lists.newArrayList(taskId));
            } else {
                workerIdAddr2TaskIds.get(workerIdAddr).add(taskId);
            }
        }
    }
}

