/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.master.persistence;

import com.alibaba.schedulerx.common.domain.InstanceStatus;
import com.alibaba.schedulerx.common.domain.TaskStatus;
import com.alibaba.schedulerx.protocol.Worker;
import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.shade.org.apache.commons.collections.CollectionUtils;
import com.alibaba.schedulerx.worker.domain.TaskInfo;
import com.alibaba.schedulerx.worker.domain.TaskStatistics;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.master.persistence.H2ConnectionPool;
import com.alibaba.schedulerx.worker.master.persistence.TaskDao;
import com.alibaba.schedulerx.worker.master.persistence.TaskPersistence;
import com.alibaba.schedulerx.worker.master.persistence.TaskSnapshot;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;

public abstract class H2Persistence
implements TaskPersistence {
    private static final Logger LOGGER = LogFactory.getLogger(H2Persistence.class);
    protected H2ConnectionPool h2CP;
    protected TaskDao taskDao;
    private volatile boolean inited = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initTable() throws Exception {
        if (!this.inited) {
            H2Persistence h2Persistence = this;
            synchronized (h2Persistence) {
                if (!this.inited) {
                    this.taskDao.dropTable();
                    this.taskDao.createTable();
                    this.inited = true;
                }
            }
        }
    }

    @Override
    public int updateTaskStatus(long jobInstanceId, List<Long> taskIds, TaskStatus status, String workerId, String workerAddr) throws Exception {
        int res = -1;
        if (CollectionUtils.isEmpty(taskIds)) {
            return res;
        }
        try {
            res = this.taskDao.updateStatus(jobInstanceId, taskIds, status.getValue(), workerId, workerAddr);
        }
        catch (Throwable e) {
            LOGGER.error("jobInstanceId={}, updateTaskStatus error", jobInstanceId, e);
        }
        return res;
    }

    @Override
    public void updateTaskStatues(List<Worker.ContainerReportTaskStatusRequest> taskStatusInfos) throws Exception {
        if (CollectionUtils.isEmpty(taskStatusInfos)) {
            return;
        }
        long jobInstanceId = taskStatusInfos.get(0).getJobInstanceId();
        ArrayList<Long> taskIds = Lists.newArrayList();
        for (Worker.ContainerReportTaskStatusRequest taskStatusInfo : taskStatusInfos) {
            TaskStatus taskStatus = TaskStatus.parseValue(taskStatusInfo.getStatus());
            if (!taskStatus.isFinish()) continue;
            taskIds.add(taskStatusInfo.getTaskId());
        }
        this.taskDao.batchDeleteTasks(jobInstanceId, taskIds);
    }

    @Override
    public void clearTasks(long jobInstanceId) throws Exception {
        this.taskDao.deleteByJobInstanceId(jobInstanceId);
    }

    @Override
    public void createTask(long jobId, long jobInstanceId, long taskId, String taskName, ByteString taskBody) throws Exception {
        this.taskDao.insert(jobId, jobInstanceId, taskId, taskName, taskBody);
    }

    @Override
    public void createTasks(List<Worker.MasterStartContainerRequest> containers, String workerId, String workerAddr) throws Exception {
        this.taskDao.batchInsert(containers, workerId, workerAddr);
    }

    @Override
    public List<TaskInfo> pull(long jobInstanceId, int pageSize) throws Exception {
        ArrayList<TaskInfo> taskInfoList = Lists.newArrayList();
        List<TaskSnapshot> taskSnapshots = this.taskDao.queryTaskList(jobInstanceId, TaskStatus.INIT.getValue(), pageSize);
        if (!taskSnapshots.isEmpty()) {
            ArrayList<Long> taskIdList = Lists.newArrayList();
            for (TaskSnapshot taskSnapshot : taskSnapshots) {
                taskIdList.add(taskSnapshot.getTask_id());
                taskInfoList.add(this.convert2TaskInfo(taskSnapshot));
            }
            this.taskDao.batchUpdateStatus(jobInstanceId, taskIdList, TaskStatus.PULLED.getValue());
        }
        return taskInfoList;
    }

    @Override
    public InstanceStatus checkInstanceStatus(long jobInstanceId) throws Exception {
        boolean exist = this.taskDao.exist(jobInstanceId);
        InstanceStatus instanceStatus = exist ? InstanceStatus.RUNNING : InstanceStatus.SUCCESS;
        return instanceStatus;
    }

    private TaskInfo convert2TaskInfo(TaskSnapshot taskSnapshot) {
        return TaskInfo.newBuilder().setTaskId(taskSnapshot.getTask_id()).setTaskName(taskSnapshot.getTask_name()).setTaskBody(taskSnapshot.getTask_body()).setJobId(taskSnapshot.getJob_id()).setJobInstanceId(taskSnapshot.getJob_instance_id()).build();
    }

    private TaskSnapshot convert2TaskSnapshot(TaskInfo taskInfo) {
        TaskSnapshot taskSnapshot = new TaskSnapshot();
        taskSnapshot.setJob_id(taskInfo.getJobId());
        taskSnapshot.setJob_instance_id(taskInfo.getJobInstanceId());
        taskSnapshot.setTask_id(taskInfo.getTaskId());
        taskSnapshot.setTask_name(taskInfo.getTaskName());
        taskSnapshot.setTask_body(taskInfo.getTaskBody());
        return taskSnapshot;
    }

    @Override
    public int batchUpdateTaskStatus(long jobInstanceId, TaskStatus status, String workerId, String workerAddr) {
        int res = -1;
        try {
            res = this.taskDao.batchUpdateStatus(jobInstanceId, status.getValue(), workerId, workerAddr);
        }
        catch (Throwable e) {
            LOGGER.error("batchUpdateTaskStatus error.", e);
        }
        return res;
    }

    public TaskStatistics getTaskStatistics() throws Exception {
        return this.taskDao.getTaskStatistics();
    }

    public List<Long> getDistinctInstanceIds() throws Exception {
        return this.taskDao.getDistinctInstanceIds();
    }

    public boolean isInited() {
        return this.inited;
    }
}

