/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.actor;

import akka.actor.UntypedActor;
import com.alibaba.schedulerx.common.domain.TaskDispatchMode;
import com.alibaba.schedulerx.protocol.Worker;
import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.worker.master.TaskMasterPool;
import com.alibaba.schedulerx.worker.pull.PullManager;
import java.util.ArrayList;

public class WorkerHeartbeatActor
extends UntypedActor {
    private TaskMasterPool taskMasterPool = TaskMasterPool.INSTANCE;

    public void onReceive(Object obj) throws Throwable {
        if (obj instanceof Worker.MasterCheckWorkerAliveRequest) {
            this.handleCheckWorkerAlive((Worker.MasterCheckWorkerAliveRequest)obj);
        } else if (obj instanceof Worker.ContainerCheckZombieRequest) {
            this.handleCheckZombie((Worker.ContainerCheckZombieRequest)obj);
        }
    }

    private void handleCheckWorkerAlive(Worker.MasterCheckWorkerAliveRequest request) {
        long jobInstanceId = request.getJobInstanceId();
        Worker.MasterCheckWorkerAliveResponse response = request.hasDispatchMode() && request.getDispatchMode().equals(TaskDispatchMode.PULL.getValue()) && PullManager.INSTANCE.contains(jobInstanceId) && PullManager.INSTANCE.isCrashed(jobInstanceId) ? Worker.MasterCheckWorkerAliveResponse.newBuilder().setSuccess(false).setMessage(request.getJobInstanceId() + "  is crashed in PullMananger").build() : Worker.MasterCheckWorkerAliveResponse.newBuilder().setSuccess(true).build();
        this.getSender().tell((Object)response, this.getSelf());
    }

    private void handleCheckZombie(Worker.ContainerCheckZombieRequest request) {
        ArrayList<Long> zombieJobInstanceIds = Lists.newArrayList();
        for (Long jobInstanceId : request.getJobInstanceIdList()) {
            if (this.taskMasterPool.contains(jobInstanceId)) continue;
            zombieJobInstanceIds.add(jobInstanceId);
        }
        Worker.ContainerCheckZombieResponse response = Worker.ContainerCheckZombieResponse.newBuilder().addAllZombieJobInstanceId(zombieJobInstanceIds).build();
        this.getSender().tell((Object)response, this.getSelf());
    }
}

