/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.table;

import com.alibaba.schedulerx.shade.org.h2.command.ddl.CreateTableData;
import com.alibaba.schedulerx.shade.org.h2.engine.Database;
import com.alibaba.schedulerx.shade.org.h2.engine.DbSettings;
import com.alibaba.schedulerx.shade.org.h2.mvstore.db.MVTableEngine;
import com.alibaba.schedulerx.shade.org.h2.table.Column;
import com.alibaba.schedulerx.shade.org.h2.table.Table;
import com.alibaba.schedulerx.shade.org.h2.util.StatementBuilder;
import com.alibaba.schedulerx.shade.org.h2.util.StringUtils;
import java.util.Collections;
import java.util.List;

public abstract class TableBase
extends Table {
    private final String tableEngine;
    private final List<String> tableEngineParams;
    private final boolean globalTemporary;

    public TableBase(CreateTableData createTableData) {
        super(createTableData.schema, createTableData.id, createTableData.tableName, createTableData.persistIndexes, createTableData.persistData);
        this.tableEngine = createTableData.tableEngine;
        this.globalTemporary = createTableData.globalTemporary;
        this.tableEngineParams = createTableData.tableEngineParams != null ? createTableData.tableEngineParams : Collections.emptyList();
        this.setTemporary(createTableData.temporary);
        Column[] columnArray = createTableData.columns.toArray(new Column[0]);
        this.setColumns(columnArray);
    }

    @Override
    public String getDropSQL() {
        return "DROP TABLE IF EXISTS " + this.getSQL() + " CASCADE";
    }

    @Override
    public String getCreateSQL() {
        Database database = this.getDatabase();
        if (database == null) {
            return null;
        }
        StatementBuilder statementBuilder = new StatementBuilder("CREATE ");
        if (this.isTemporary()) {
            if (this.isGlobalTemporary()) {
                statementBuilder.append("GLOBAL ");
            } else {
                statementBuilder.append("LOCAL ");
            }
            statementBuilder.append("TEMPORARY ");
        } else if (this.isPersistIndexes()) {
            statementBuilder.append("CACHED ");
        } else {
            statementBuilder.append("MEMORY ");
        }
        statementBuilder.append("TABLE ");
        if (this.isHidden) {
            statementBuilder.append("IF NOT EXISTS ");
        }
        statementBuilder.append(this.getSQL());
        if (this.comment != null) {
            statementBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        statementBuilder.append("(\n    ");
        for (Column column : this.columns) {
            statementBuilder.appendExceptFirst(",\n    ");
            statementBuilder.append(column.getCreateSQL());
        }
        statementBuilder.append("\n)");
        if (this.tableEngine != null) {
            DbSettings dbSettings = database.getSettings();
            String string = dbSettings.defaultTableEngine;
            if (string == null && dbSettings.mvStore) {
                string = MVTableEngine.class.getName();
            }
            if (string == null || !this.tableEngine.endsWith(string)) {
                statementBuilder.append("\nENGINE ");
                statementBuilder.append(StringUtils.quoteIdentifier(this.tableEngine));
            }
        }
        if (!this.tableEngineParams.isEmpty()) {
            statementBuilder.append("\nWITH ");
            statementBuilder.resetCount();
            for (String string : this.tableEngineParams) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(StringUtils.quoteIdentifier(string));
            }
        }
        if (!this.isPersistIndexes() && !this.isPersistData()) {
            statementBuilder.append("\nNOT PERSISTENT");
        }
        if (this.isHidden) {
            statementBuilder.append("\nHIDDEN");
        }
        return statementBuilder.toString();
    }

    @Override
    public boolean isGlobalTemporary() {
        return this.globalTemporary;
    }
}

