/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.result;

import com.alibaba.schedulerx.shade.org.h2.result.Row;
import com.alibaba.schedulerx.shade.org.h2.result.SearchRow;
import com.alibaba.schedulerx.shade.org.h2.store.Data;
import com.alibaba.schedulerx.shade.org.h2.util.StatementBuilder;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import com.alibaba.schedulerx.shade.org.h2.value.ValueLong;
import java.util.Arrays;

public class RowImpl
implements Row {
    private long key;
    private final Value[] data;
    private int memory;
    private int version;
    private boolean deleted;
    private int sessionId;

    public RowImpl(Value[] valueArray, int n) {
        this.data = valueArray;
        this.memory = n;
    }

    @Override
    public Row getCopy() {
        Value[] valueArray = Arrays.copyOf(this.data, this.data.length);
        RowImpl rowImpl = new RowImpl(valueArray, this.memory);
        rowImpl.key = this.key;
        rowImpl.version = this.version + 1;
        rowImpl.sessionId = this.sessionId;
        return rowImpl;
    }

    @Override
    public void setKeyAndVersion(SearchRow searchRow) {
        this.setKey(searchRow.getKey());
        this.setVersion(searchRow.getVersion());
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int n) {
        this.version = n;
    }

    @Override
    public long getKey() {
        return this.key;
    }

    @Override
    public void setKey(long l) {
        this.key = l;
    }

    @Override
    public Value getValue(int n) {
        return n == -1 ? ValueLong.get(this.key) : this.data[n];
    }

    @Override
    public int getByteCount(Data data) {
        int n = 0;
        for (Value value : this.data) {
            n += data.getValueLen(value);
        }
        return n;
    }

    @Override
    public void setValue(int n, Value value) {
        if (n == -1) {
            this.key = value.getLong();
        } else {
            this.data[n] = value;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.data == null;
    }

    @Override
    public int getColumnCount() {
        return this.data.length;
    }

    @Override
    public int getMemory() {
        if (this.memory != -1) {
            return this.memory;
        }
        int n = 40;
        if (this.data != null) {
            int n2 = this.data.length;
            n += 24 + n2 * 8;
            for (Value value : this.data) {
                if (value == null) continue;
                n += value.getMemory();
            }
        }
        this.memory = n;
        return n;
    }

    public String toString() {
        StatementBuilder statementBuilder = new StatementBuilder("( /* key:");
        statementBuilder.append(this.getKey());
        if (this.version != 0) {
            statementBuilder.append(" v:").append(this.version);
        }
        if (this.isDeleted()) {
            statementBuilder.append(" deleted");
        }
        statementBuilder.append(" */ ");
        if (this.data != null) {
            for (Value value : this.data) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(value == null ? "null" : value.getTraceSQL());
            }
        }
        return statementBuilder.append(')').toString();
    }

    @Override
    public void setDeleted(boolean bl) {
        this.deleted = bl;
    }

    @Override
    public void setSessionId(int n) {
        this.sessionId = n;
    }

    @Override
    public int getSessionId() {
        return this.sessionId;
    }

    @Override
    public void commit() {
        this.sessionId = 0;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public Value[] getValueList() {
        return this.data;
    }
}

