/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.command.dml;

import com.alibaba.schedulerx.shade.org.h2.command.ddl.SchemaCommand;
import com.alibaba.schedulerx.shade.org.h2.engine.Database;
import com.alibaba.schedulerx.shade.org.h2.engine.Session;
import com.alibaba.schedulerx.shade.org.h2.expression.Expression;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.schema.Schema;
import com.alibaba.schedulerx.shade.org.h2.schema.Sequence;
import com.alibaba.schedulerx.shade.org.h2.table.Column;
import com.alibaba.schedulerx.shade.org.h2.table.Table;

public class AlterSequence
extends SchemaCommand {
    private boolean ifExists;
    private Table table;
    private String sequenceName;
    private Sequence sequence;
    private Expression start;
    private Expression increment;
    private Boolean cycle;
    private Expression minValue;
    private Expression maxValue;
    private Expression cacheSize;

    public AlterSequence(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }

    public void setSequenceName(String string) {
        this.sequenceName = string;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public void setColumn(Column column) {
        this.table = column.getTable();
        this.sequence = column.getSequence();
        if (this.sequence == null && !this.ifExists) {
            throw DbException.get(90036, column.getSQL());
        }
    }

    public void setStartWith(Expression expression) {
        this.start = expression;
    }

    public void setIncrement(Expression expression) {
        this.increment = expression;
    }

    public void setCycle(Boolean bl) {
        this.cycle = bl;
    }

    public void setMinValue(Expression expression) {
        this.minValue = expression;
    }

    public void setMaxValue(Expression expression) {
        this.maxValue = expression;
    }

    public void setCacheSize(Expression expression) {
        this.cacheSize = expression;
    }

    @Override
    public int update() {
        Database database = this.session.getDatabase();
        if (this.sequence == null) {
            this.sequence = this.getSchema().findSequence(this.sequenceName);
            if (this.sequence == null) {
                if (!this.ifExists) {
                    throw DbException.get(90036, this.sequenceName);
                }
                return 0;
            }
        }
        if (this.table != null) {
            this.session.getUser().checkRight(this.table, 15);
        }
        if (this.cycle != null) {
            this.sequence.setCycle(this.cycle);
        }
        if (this.cacheSize != null) {
            long l = this.cacheSize.optimize(this.session).getValue(this.session).getLong();
            this.sequence.setCacheSize(l);
        }
        if (this.start != null || this.minValue != null || this.maxValue != null || this.increment != null) {
            Long l = this.getLong(this.start);
            Long l2 = this.getLong(this.minValue);
            Long l3 = this.getLong(this.maxValue);
            Long l4 = this.getLong(this.increment);
            this.sequence.modify(l, l2, l3, l4);
        }
        database.updateMeta(this.session, this.sequence);
        return 0;
    }

    private Long getLong(Expression expression) {
        if (expression == null) {
            return null;
        }
        return expression.optimize(this.session).getValue(this.session).getLong();
    }

    @Override
    public int getType() {
        return 54;
    }
}

