/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.http.protocol;

import com.alibaba.schedulerx.shade.org.apache.http.HttpConnection;
import com.alibaba.schedulerx.shade.org.apache.http.HttpException;
import com.alibaba.schedulerx.shade.org.apache.http.HttpHost;
import com.alibaba.schedulerx.shade.org.apache.http.HttpInetConnection;
import com.alibaba.schedulerx.shade.org.apache.http.HttpRequest;
import com.alibaba.schedulerx.shade.org.apache.http.HttpRequestInterceptor;
import com.alibaba.schedulerx.shade.org.apache.http.HttpVersion;
import com.alibaba.schedulerx.shade.org.apache.http.ProtocolException;
import com.alibaba.schedulerx.shade.org.apache.http.ProtocolVersion;
import com.alibaba.schedulerx.shade.org.apache.http.annotation.Contract;
import com.alibaba.schedulerx.shade.org.apache.http.annotation.ThreadingBehavior;
import com.alibaba.schedulerx.shade.org.apache.http.protocol.HttpContext;
import com.alibaba.schedulerx.shade.org.apache.http.protocol.HttpCoreContext;
import com.alibaba.schedulerx.shade.org.apache.http.util.Args;
import java.io.IOException;
import java.net.InetAddress;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext corecontext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targethost = corecontext.getTargetHost();
            if (targethost == null) {
                HttpConnection conn = corecontext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targethost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targethost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targethost.toHostString());
        }
    }
}

