/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.http.nio.protocol;

import com.alibaba.schedulerx.shade.org.apache.http.HttpRequest;
import com.alibaba.schedulerx.shade.org.apache.http.nio.ContentDecoder;
import com.alibaba.schedulerx.shade.org.apache.http.nio.IOControl;
import com.alibaba.schedulerx.shade.org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import com.alibaba.schedulerx.shade.org.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NullRequestConsumer
implements HttpAsyncRequestConsumer<Object> {
    private final ByteBuffer buffer = ByteBuffer.allocate(2048);
    private volatile boolean completed;

    NullRequestConsumer() {
    }

    @Override
    public void requestReceived(HttpRequest request) {
    }

    @Override
    public void consumeContent(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        int lastRead;
        do {
            this.buffer.clear();
        } while ((lastRead = decoder.read(this.buffer)) > 0);
    }

    @Override
    public void requestCompleted(HttpContext context) {
        this.completed = true;
    }

    @Override
    public void failed(Exception ex) {
        this.completed = true;
    }

    @Override
    public Object getResult() {
        return this.completed;
    }

    @Override
    public Exception getException() {
        return null;
    }

    @Override
    public void close() throws IOException {
        this.completed = true;
    }

    @Override
    public boolean isDone() {
        return this.completed;
    }
}

