/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.commons.validator.routines.checkdigit;

import com.alibaba.schedulerx.shade.org.apache.commons.validator.routines.checkdigit.CheckDigit;
import com.alibaba.schedulerx.shade.org.apache.commons.validator.routines.checkdigit.CheckDigitException;
import com.alibaba.schedulerx.shade.org.apache.commons.validator.routines.checkdigit.ModulusCheckDigit;

public final class SedolCheckDigit
extends ModulusCheckDigit {
    private static final long serialVersionUID = -8976881621148878443L;
    public static final CheckDigit SEDOL_CHECK_DIGIT = new SedolCheckDigit();
    private static final int[] POSITION_WEIGHT = new int[]{1, 3, 1, 7, 3, 9, 1};

    public SedolCheckDigit() {
        super(10);
    }

    protected int calculateModulus(String code, boolean includesCheckDigit) throws CheckDigitException {
        if (code.length() > 7) {
            throw new CheckDigitException("Invalid Code Length = " + code.length());
        }
        return super.calculateModulus(code, includesCheckDigit);
    }

    protected int weightedValue(int charValue, int leftPos, int rightPos) {
        return charValue * POSITION_WEIGHT[leftPos - 1];
    }

    protected int toInt(char character, int leftPos, int rightPos) throws CheckDigitException {
        int charValue = Character.getNumericValue(character);
        if (charValue < 0 || charValue > 35) {
            throw new CheckDigitException("Invalid Character[" + leftPos + "] = '" + charValue + "'");
        }
        return charValue;
    }
}

