/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.commons.validator.routines.checkdigit;

import com.alibaba.schedulerx.shade.org.apache.commons.validator.routines.checkdigit.CheckDigit;
import com.alibaba.schedulerx.shade.org.apache.commons.validator.routines.checkdigit.CheckDigitException;
import com.alibaba.schedulerx.shade.org.apache.commons.validator.routines.checkdigit.ModulusCheckDigit;

public final class CUSIPCheckDigit
extends ModulusCheckDigit {
    private static final long serialVersionUID = 666941918490152456L;
    public static final CheckDigit CUSIP_CHECK_DIGIT = new CUSIPCheckDigit();
    private static final int[] POSITION_WEIGHT = new int[]{2, 1};

    public CUSIPCheckDigit() {
        super(10);
    }

    protected int toInt(char character, int leftPos, int rightPos) throws CheckDigitException {
        int charValue = Character.getNumericValue(character);
        if (charValue < 0 || charValue > 35) {
            throw new CheckDigitException("Invalid Character[" + leftPos + "] = '" + charValue + "'");
        }
        return charValue;
    }

    protected int weightedValue(int charValue, int leftPos, int rightPos) {
        int weight = POSITION_WEIGHT[rightPos % 2];
        int weightedValue = charValue * weight;
        return ModulusCheckDigit.sumDigits(weightedValue);
    }
}

