/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.commons.configuration;

import com.alibaba.schedulerx.shade.org.apache.commons.configuration.CompositeConfiguration;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.Configuration;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.ConfigurationException;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.ConfigurationUtils;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.FileConfiguration;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.HierarchicalConfiguration;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.JNDIConfiguration;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.PropertiesConfiguration;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.PropertyConverter;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.SystemConfiguration;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.XMLConfiguration;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.XMLPropertiesConfiguration;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.plist.PropertyListConfiguration;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.plist.XMLPropertyListConfiguration;
import com.alibaba.schedulerx.shade.org.apache.commons.digester.AbstractObjectCreationFactory;
import com.alibaba.schedulerx.shade.org.apache.commons.digester.CallMethodRule;
import com.alibaba.schedulerx.shade.org.apache.commons.digester.Digester;
import com.alibaba.schedulerx.shade.org.apache.commons.digester.ObjectCreationFactory;
import com.alibaba.schedulerx.shade.org.apache.commons.digester.substitution.MultiVariableExpander;
import com.alibaba.schedulerx.shade.org.apache.commons.digester.substitution.VariableSubstitutor;
import com.alibaba.schedulerx.shade.org.apache.commons.digester.xmlrules.DigesterLoader;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.shade.org.apache.commons.logging.Log;
import com.alibaba.schedulerx.shade.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

@Deprecated
public class ConfigurationFactory {
    private static final String SEC_ROOT = "configuration/";
    private static final String SEC_OVERRIDE = "configuration/override/";
    private static final String SEC_ADDITIONAL = "configuration/additional/";
    private static final String ATTR_OPTIONAL = "optional";
    private static final String ATTR_FILENAME = "fileName";
    private static final String METH_LOAD = "load";
    private static final String DEF_BASE_PATH = ".";
    private static Log log = LogFactory.getLog(ConfigurationFactory.class);
    private String configurationFileName;
    private URL configurationURL;
    private String implicitBasePath;
    private String basePath;
    private URL digesterRules;
    private String digesterRuleNamespaceURI;

    public ConfigurationFactory() {
        this.setBasePath(DEF_BASE_PATH);
    }

    public ConfigurationFactory(String configurationFileName) {
        this.setConfigurationFileName(configurationFileName);
    }

    public Configuration getConfiguration() throws ConfigurationException {
        Digester digester;
        InputStream input = null;
        ConfigurationBuilder builder = new ConfigurationBuilder();
        URL url = this.getConfigurationURL();
        try {
            if (url == null) {
                url = ConfigurationUtils.locate(this.implicitBasePath, this.getConfigurationFileName());
            }
            input = url.openStream();
        }
        catch (Exception e) {
            log.error("Exception caught opening stream to URL", e);
            throw new ConfigurationException("Exception caught opening stream to URL", e);
        }
        if (this.getDigesterRules() == null) {
            digester = new Digester();
            this.configureNamespace(digester);
            this.initDefaultDigesterRules(digester);
        } else {
            digester = DigesterLoader.createDigester(this.getDigesterRules());
            this.configureNamespace(digester);
        }
        digester.setUseContextClassLoader(true);
        this.enableDigesterSubstitutor(digester);
        digester.push(builder);
        try {
            digester.parse(input);
            input.close();
        }
        catch (SAXException saxe) {
            log.error("SAX Exception caught", saxe);
            throw new ConfigurationException("SAX Exception caught", saxe);
        }
        catch (IOException ioe) {
            log.error("IO Exception caught", ioe);
            throw new ConfigurationException("IO Exception caught", ioe);
        }
        return builder.getConfiguration();
    }

    public String getConfigurationFileName() {
        return this.configurationFileName;
    }

    public void setConfigurationFileName(String configurationFileName) {
        File file = new File(configurationFileName).getAbsoluteFile();
        this.configurationFileName = file.getName();
        this.implicitBasePath = file.getParent();
    }

    public URL getConfigurationURL() {
        return this.configurationURL;
    }

    public void setConfigurationURL(URL url) {
        this.configurationURL = url;
        this.implicitBasePath = url.toString();
    }

    public URL getDigesterRules() {
        return this.digesterRules;
    }

    public void setDigesterRules(URL digesterRules) {
        this.digesterRules = digesterRules;
    }

    protected void enableDigesterSubstitutor(Digester digester) {
        Map systemProperties = System.getProperties();
        MultiVariableExpander expander = new MultiVariableExpander();
        expander.addSource("$", systemProperties);
        VariableSubstitutor substitutor = new VariableSubstitutor(expander);
        digester.setSubstitutor(substitutor);
    }

    protected void initDefaultDigesterRules(Digester digester) {
        this.initDigesterSectionRules(digester, SEC_ROOT, false);
        this.initDigesterSectionRules(digester, SEC_OVERRIDE, false);
        this.initDigesterSectionRules(digester, SEC_ADDITIONAL, true);
    }

    protected void initDigesterSectionRules(Digester digester, String matchString, boolean additional) {
        this.setupDigesterInstance(digester, matchString + "properties", new PropertiesConfigurationFactory(), METH_LOAD, additional);
        this.setupDigesterInstance(digester, matchString + "plist", new PropertyListConfigurationFactory(), METH_LOAD, additional);
        this.setupDigesterInstance(digester, matchString + "xml", new FileConfigurationFactory(XMLConfiguration.class), METH_LOAD, additional);
        this.setupDigesterInstance(digester, matchString + "hierarchicalXml", new FileConfigurationFactory(XMLConfiguration.class), METH_LOAD, additional);
        this.setupDigesterInstance(digester, matchString + "jndi", new JNDIConfigurationFactory(), null, additional);
        this.setupDigesterInstance(digester, matchString + "system", new SystemConfigurationFactory(), null, additional);
    }

    protected void setupDigesterInstance(Digester digester, String matchString, ObjectCreationFactory factory, String method, boolean additional) {
        if (additional) {
            this.setupUnionRules(digester, matchString);
        }
        digester.addFactoryCreate(matchString, factory);
        digester.addSetProperties(matchString);
        if (method != null) {
            digester.addRule(matchString, new CallOptionalMethodRule(method));
        }
        digester.addSetNext(matchString, "addConfiguration", Configuration.class.getName());
    }

    protected void setupUnionRules(Digester digester, String matchString) {
        digester.addObjectCreate(matchString, AdditionalConfigurationData.class);
        digester.addSetProperties(matchString);
        digester.addSetNext(matchString, "addAdditionalConfig", AdditionalConfigurationData.class.getName());
    }

    public String getDigesterRuleNamespaceURI() {
        return this.digesterRuleNamespaceURI;
    }

    public void setDigesterRuleNamespaceURI(String digesterRuleNamespaceURI) {
        this.digesterRuleNamespaceURI = digesterRuleNamespaceURI;
    }

    private void configureNamespace(Digester digester) {
        if (this.getDigesterRuleNamespaceURI() != null) {
            digester.setNamespaceAware(true);
            digester.setRuleNamespaceURI(this.getDigesterRuleNamespaceURI());
        } else {
            digester.setNamespaceAware(false);
        }
        digester.setValidating(false);
    }

    public String getBasePath() {
        String path = StringUtils.isEmpty(this.basePath) || DEF_BASE_PATH.equals(this.basePath) ? this.implicitBasePath : this.basePath;
        return StringUtils.isEmpty(path) ? DEF_BASE_PATH : path;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    private static class CallOptionalMethodRule
    extends CallMethodRule {
        private boolean optional;

        public CallOptionalMethodRule(String methodName) {
            super(methodName);
        }

        public void begin(Attributes attrs) throws Exception {
            this.optional = attrs.getValue(ConfigurationFactory.ATTR_OPTIONAL) != null && PropertyConverter.toBoolean(attrs.getValue(ConfigurationFactory.ATTR_OPTIONAL)) != false;
            super.begin(attrs);
        }

        public void end() throws Exception {
            try {
                super.end();
            }
            catch (Exception ex) {
                if (this.optional) {
                    log.warn("Could not create optional configuration!", ex);
                }
                throw ex;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigurationBuilder {
        private CompositeConfiguration config = new CompositeConfiguration();
        private Collection<AdditionalConfigurationData> additionalConfigs = new LinkedList<AdditionalConfigurationData>();

        public void addConfiguration(Configuration conf) {
            this.config.addConfiguration(conf);
        }

        public void addAdditionalConfig(AdditionalConfigurationData data) {
            this.additionalConfigs.add(data);
        }

        public CompositeConfiguration getConfiguration() {
            if (!this.additionalConfigs.isEmpty()) {
                Configuration unionConfig = this.createAdditionalConfiguration(this.additionalConfigs);
                if (unionConfig != null) {
                    this.addConfiguration(unionConfig);
                }
                this.additionalConfigs.clear();
            }
            return this.config;
        }

        protected Configuration createAdditionalConfiguration(Collection<AdditionalConfigurationData> configs) {
            HierarchicalConfiguration result = new HierarchicalConfiguration();
            for (AdditionalConfigurationData cdata : configs) {
                result.addNodes(cdata.getAt(), this.createRootNode(cdata).getChildren());
            }
            return result.isEmpty() ? null : result;
        }

        private HierarchicalConfiguration.Node createRootNode(AdditionalConfigurationData cdata) {
            if (cdata.getConfiguration() instanceof HierarchicalConfiguration) {
                return ((HierarchicalConfiguration)cdata.getConfiguration()).getRoot();
            }
            HierarchicalConfiguration hc = new HierarchicalConfiguration();
            ConfigurationUtils.copy(cdata.getConfiguration(), hc);
            return hc.getRoot();
        }
    }

    public static class AdditionalConfigurationData {
        private Configuration configuration;
        private String at;

        public String getAt() {
            return this.at;
        }

        public void setAt(String string) {
            this.at = string;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public void addConfiguration(Configuration config) {
            this.configuration = config;
        }
    }

    private class SystemConfigurationFactory
    extends DigesterConfigurationFactory {
        public SystemConfigurationFactory() {
            super(SystemConfiguration.class);
        }
    }

    private class JNDIConfigurationFactory
    extends DigesterConfigurationFactory {
        public JNDIConfigurationFactory() {
            super(JNDIConfiguration.class);
        }
    }

    public class PropertyListConfigurationFactory
    extends FileConfigurationFactory {
        public PropertyListConfigurationFactory() {
            super(null);
        }

        protected FileConfiguration createConfiguration(Attributes attributes) throws Exception {
            String filename = attributes.getValue(ConfigurationFactory.ATTR_FILENAME);
            if (filename != null && filename.toLowerCase().trim().endsWith(".xml")) {
                return new XMLPropertyListConfiguration();
            }
            return new PropertyListConfiguration();
        }
    }

    public class PropertiesConfigurationFactory
    extends FileConfigurationFactory {
        public PropertiesConfigurationFactory() {
            super(null);
        }

        protected FileConfiguration createConfiguration(Attributes attributes) throws Exception {
            String filename = attributes.getValue(ConfigurationFactory.ATTR_FILENAME);
            if (filename != null && filename.toLowerCase().trim().endsWith(".xml")) {
                return new XMLPropertiesConfiguration();
            }
            return new PropertiesConfiguration();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FileConfigurationFactory
    extends DigesterConfigurationFactory {
        public FileConfigurationFactory(Class<?> clazz) {
            super(clazz);
        }

        @Override
        public Object createObject(Attributes attributes) throws Exception {
            FileConfiguration conf = this.createConfiguration(attributes);
            conf.setBasePath(ConfigurationFactory.this.getBasePath());
            return conf;
        }

        protected FileConfiguration createConfiguration(Attributes attributes) throws Exception {
            return (FileConfiguration)super.createObject(attributes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DigesterConfigurationFactory
    extends AbstractObjectCreationFactory {
        private Class<?> clazz;

        public DigesterConfigurationFactory(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public Object createObject(Attributes attribs) throws Exception {
            return this.clazz.newInstance();
        }
    }
}

