/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.zaxxer.hikari.util;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DriverDataSource
implements DataSource {
    private final Logger LOGGER = LoggerFactory.getLogger(DriverDataSource.class);
    private final String jdbcUrl;
    private final Properties driverProperties;
    private Driver driver;

    public DriverDataSource(String jdbcUrl, String driverClassName, Properties properties, String username, String password) {
        this.jdbcUrl = jdbcUrl;
        this.driverProperties = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.driverProperties.setProperty(entry.getKey().toString(), entry.getValue().toString());
        }
        if (username != null) {
            this.driverProperties.put("user", this.driverProperties.getProperty("user", username));
        }
        if (password != null) {
            this.driverProperties.put("password", this.driverProperties.getProperty("password", password));
        }
        if (driverClassName != null) {
            Enumeration<Driver> drivers = DriverManager.getDrivers();
            while (drivers.hasMoreElements()) {
                Driver d = drivers.nextElement();
                if (!d.getClass().getName().equals(driverClassName)) continue;
                this.driver = d;
                break;
            }
            if (this.driver == null) {
                this.LOGGER.warn("Registered driver with driverClassName={} was not found, trying direct instantiation.", (Object)driverClassName);
                try {
                    Class<?> driverClass = this.getClass().getClassLoader().loadClass(driverClassName);
                    this.driver = (Driver)driverClass.newInstance();
                }
                catch (Exception e) {
                    this.LOGGER.warn("Could not instantiate instance of driver class {}, trying JDBC URL resolution", (Object)driverClassName, (Object)e);
                }
            }
        }
        if (this.driver == null) {
            try {
                this.driver = DriverManager.getDriver(jdbcUrl);
            }
            catch (SQLException e) {
                throw new RuntimeException("Unable to get driver instance for jdbcUrl=" + jdbcUrl, e);
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.driver.connect(this.jdbcUrl, this.driverProperties);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        DriverManager.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.driver.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public void shutdown() {
    }
}

