/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.zaxxer.hikari.proxy;

import com.alibaba.schedulerx.shade.com.zaxxer.hikari.proxy.CallableStatementProxy;
import com.alibaba.schedulerx.shade.com.zaxxer.hikari.proxy.ConnectionProxy;
import com.alibaba.schedulerx.shade.com.zaxxer.hikari.proxy.PreparedStatementProxy;
import com.alibaba.schedulerx.shade.com.zaxxer.hikari.proxy.ResultSetProxy;
import com.alibaba.schedulerx.shade.com.zaxxer.hikari.proxy.StatementProxy;
import com.alibaba.schedulerx.shade.com.zaxxer.hikari.util.ClassLoaderUtils;
import com.alibaba.schedulerx.shade.javassist.ClassPool;
import com.alibaba.schedulerx.shade.javassist.CtClass;
import com.alibaba.schedulerx.shade.javassist.CtMethod;
import com.alibaba.schedulerx.shade.javassist.CtNewMethod;
import com.alibaba.schedulerx.shade.javassist.LoaderClassPath;
import com.alibaba.schedulerx.shade.javassist.NotFoundException;
import java.lang.reflect.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public final class JavassistProxyFactory {
    private ClassPool classPool = new ClassPool();

    public static void initialize() {
    }

    private JavassistProxyFactory() throws Exception {
        this.classPool.importPackage("java.sql");
        this.classPool.appendClassPath(new LoaderClassPath(this.getClass().getClassLoader()));
        String methodBody = "{ try { return delegate.method($$); } catch (SQLException e) { throw checkException(e); } }";
        this.generateProxyClass(Connection.class, ConnectionProxy.class, methodBody);
        this.generateProxyClass(Statement.class, StatementProxy.class, methodBody);
        this.generateProxyClass(ResultSet.class, ResultSetProxy.class, methodBody);
        methodBody = "{ try { return ((cast) delegate).method($$); } catch (SQLException e) { throw checkException(e); } }";
        this.generateProxyClass(PreparedStatement.class, PreparedStatementProxy.class, methodBody);
        this.generateProxyClass(CallableStatement.class, CallableStatementProxy.class, methodBody);
    }

    private void modifyProxyFactory() throws Exception {
        String packageName = JavassistProxyFactory.class.getPackage().getName();
        CtClass proxyCt = this.classPool.getCtClass("com.alibaba.schedulerx.shade.com.zaxxer.hikari.proxy.ProxyFactory");
        for (CtMethod method : proxyCt.getMethods()) {
            String methodName = method.getName();
            if ("getProxyConnection".equals(methodName)) {
                method.setBody("{return new " + packageName + ".ConnectionJavassistProxy($$);}");
                continue;
            }
            if ("getProxyStatement".equals(methodName)) {
                method.setBody("{return new " + packageName + ".StatementJavassistProxy($$);}");
                continue;
            }
            if ("getProxyPreparedStatement".equals(methodName)) {
                method.setBody("{return new " + packageName + ".PreparedStatementJavassistProxy($$);}");
                continue;
            }
            if ("getProxyCallableStatement".equals(methodName)) {
                method.setBody("{return new " + packageName + ".CallableStatementJavassistProxy($$);}");
                continue;
            }
            if (!"getProxyResultSet".equals(methodName)) continue;
            method.setBody("{return new " + packageName + ".ResultSetJavassistProxy($$);}");
        }
        proxyCt.toClass(this.classPool.getClassLoader(), this.getClass().getProtectionDomain());
    }

    private <T> Class<T> generateProxyClass(Class<T> primaryInterface, Class<?> superClass, String methodBody) throws Exception {
        String superClassName = superClass.getName();
        CtClass superClassCt = this.classPool.getCtClass(superClassName);
        CtClass targetCt = this.classPool.makeClass(superClassName.replace("Proxy", "JavassistProxy"), superClassCt);
        targetCt.setModifiers(16);
        HashSet<String> superSigs = new HashSet<String>();
        for (CtMethod method : superClassCt.getMethods()) {
            if ((method.getModifiers() & 0x10) != 16) continue;
            superSigs.add(method.getName() + method.getSignature());
        }
        HashSet<String> methods = new HashSet<String>();
        Set<Class<?>> interfaces = ClassLoaderUtils.getAllInterfaces(primaryInterface);
        for (Class<?> intf : interfaces) {
            CtClass intfCt = this.classPool.getCtClass(intf.getName());
            targetCt.addInterface(intfCt);
            for (CtMethod intfMethod : intfCt.getDeclaredMethods()) {
                String signature = intfMethod.getName() + intfMethod.getSignature();
                if (superSigs.contains(signature) || methods.contains(signature) || this.isDefaultMethod(intf, intfCt, intfMethod)) continue;
                methods.add(signature);
                CtMethod method = CtNewMethod.copy(intfMethod, targetCt, null);
                String modifiedBody = methodBody;
                CtMethod superMethod = superClassCt.getMethod(intfMethod.getName(), intfMethod.getSignature());
                if ((superMethod.getModifiers() & 0x400) != 1024) {
                    modifiedBody = modifiedBody.replace("((cast) ", "");
                    modifiedBody = modifiedBody.replace("delegate", "super");
                    modifiedBody = modifiedBody.replace("super)", "super");
                }
                modifiedBody = modifiedBody.replace("cast", primaryInterface.getName());
                modifiedBody = this.isThrowsSqlException(intfMethod) ? modifiedBody.replace("method", method.getName()) : "{ return ((cast) delegate).method($$); }".replace("method", method.getName()).replace("cast", primaryInterface.getName());
                if (method.getReturnType() == CtClass.voidType) {
                    modifiedBody = modifiedBody.replace("return", "");
                }
                method.setBody(modifiedBody);
                targetCt.addMethod(method);
            }
        }
        return targetCt.toClass(this.classPool.getClassLoader(), this.getClass().getProtectionDomain());
    }

    private boolean isThrowsSqlException(CtMethod method) {
        try {
            for (CtClass clazz : method.getExceptionTypes()) {
                if (!clazz.getSimpleName().equals("SQLException")) continue;
                return true;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return false;
    }

    private boolean isDefaultMethod(Class<?> intf, CtClass intfCt, CtMethod intfMethod) throws Exception {
        ArrayList paramTypes = new ArrayList();
        for (CtClass pt : intfMethod.getParameterTypes()) {
            paramTypes.add(this.toJavaClass(pt));
        }
        return intf.getDeclaredMethod(intfMethod.getName(), paramTypes.toArray(new Class[0])).toString().contains("default ");
    }

    private Class<?> toJavaClass(CtClass cls) throws Exception {
        if (cls.getName().endsWith("[]")) {
            return Array.newInstance(this.toJavaClass(cls.getName().replace("[]", "")), 0).getClass();
        }
        return this.toJavaClass(cls.getName());
    }

    private Class<?> toJavaClass(String cn) throws Exception {
        if ("int".equals(cn)) {
            return Integer.TYPE;
        }
        if ("long".equals(cn)) {
            return Long.TYPE;
        }
        if ("short".equals(cn)) {
            return Short.TYPE;
        }
        if ("byte".equals(cn)) {
            return Byte.TYPE;
        }
        if ("float".equals(cn)) {
            return Float.TYPE;
        }
        if ("double".equals(cn)) {
            return Double.TYPE;
        }
        if ("boolean".equals(cn)) {
            return Boolean.TYPE;
        }
        if ("char".equals(cn)) {
            return Character.TYPE;
        }
        if ("void".equals(cn)) {
            return Void.TYPE;
        }
        return Class.forName(cn);
    }

    static {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(JavassistProxyFactory.class.getClassLoader());
            JavassistProxyFactory proxyFactoryFactory = new JavassistProxyFactory();
            proxyFactoryFactory.modifyProxyFactory();
        }
        catch (Exception e) {
            throw new RuntimeException("Fatal exception during proxy generation", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }
}

