/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.taobao.spas.sdk.common.log;

import com.alibaba.schedulerx.shade.com.taobao.spas.sdk.common.log.SpasLogger;
import com.alibaba.schedulerx.shade.com.taobao.spas.sdk.common.log.SpasRollingLogger;
import com.taobao.middleware.logger.Level;
import com.taobao.middleware.logger.Logger;
import com.taobao.middleware.logger.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpasLoggerFactory {
    public static Logger getLogger(Class<?> clazz) {
        boolean rolling;
        String file;
        String productName = "spas";
        String encoding = "UTF-8";
        String size = null;
        String backup = null;
        if (clazz == SpasLogger.class) {
            file = "spas_sdk.log";
            rolling = "Y".equalsIgnoreCase(System.getProperty("spas.log.roll"));
            if (rolling) {
                size = System.getProperty("spas.log.size", "512MB");
                backup = System.getProperty("spas.log.backup", "20");
            }
        } else if (clazz == SpasRollingLogger.class) {
            file = "spas_sdk_roll.log";
            rolling = true;
            size = System.getProperty("spas.log.roll.size");
            if (size == null) {
                size = System.getProperty("spas.log.size", "256MB");
            }
            if ((backup = System.getProperty("spas.log.roll.backup")) == null) {
                backup = System.getProperty("spas.log.backup", "20");
            }
        } else {
            throw new IllegalArgumentException("Unknown logger class " + clazz);
        }
        size = SpasLoggerFactory.normalizeSize(size);
        Logger logger = LoggerFactory.getLogger(clazz);
        String level = System.getProperty("spas.log.level", "INFO");
        logger.setLevel(Level.codeOf((String)level.toUpperCase()));
        if (rolling) {
            logger.activateAppenderWithSizeRolling(productName, file, encoding, size, Integer.valueOf(backup).intValue());
        } else {
            logger.activateAppender(productName, file, encoding);
        }
        logger.setAdditivity(false);
        return logger;
    }

    private static String normalizeSize(String size) {
        if (size == null) {
            return null;
        }
        if (!((size = size.toUpperCase()).endsWith("KB") || size.endsWith("MB") || size.endsWith("GB"))) {
            size = size.endsWith("K") || size.endsWith("M") || size.endsWith("G") ? size + "B" : size + "MB";
        }
        return size;
    }
}

