/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.request;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.request.Request;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.util.Args;
import java.util.Map;

public class PullLogsRequest
extends Request {
    private static final long serialVersionUID = 1374616714086668195L;
    private String logStore;
    private int shardId;
    private int count;
    private String cursor;
    private String endCursor;

    public PullLogsRequest(String project, String logStore, int shardId, int count, String cursor) {
        this(project, logStore, shardId, count, cursor, null);
    }

    public PullLogsRequest(String project, String logStore, int shardId, int count, String cursor, String endCursor) {
        super(project);
        this.setLogStore(logStore);
        this.setShardId(shardId);
        this.setCount(count);
        this.setCursor(cursor);
        this.setEndCursor(endCursor);
    }

    public String getLogStore() {
        return this.logStore;
    }

    public void setLogStore(String logStore) {
        Args.notNullOrEmpty(logStore, "logStore");
        this.logStore = logStore;
    }

    public int getShardId() {
        return this.shardId;
    }

    public void setShardId(int shardId) {
        Args.check(shardId >= 0, "shardId cannot be negative");
        this.shardId = shardId;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        Args.check(count > 0, "count must be positive");
        this.count = count;
    }

    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        Args.notNullOrEmpty(cursor, "cursor");
        this.cursor = cursor;
    }

    public String getEndCursor() {
        return this.endCursor;
    }

    public void setEndCursor(String endCursor) {
        this.endCursor = endCursor;
    }

    @Override
    public Map<String, String> GetAllParams() {
        this.SetParam("type", "log");
        this.SetParam("cursor", this.cursor);
        this.SetParam("count", String.valueOf(this.count));
        if (this.endCursor != null && !this.endCursor.isEmpty()) {
            this.SetParam("end_cursor", this.cursor);
        }
        return super.GetAllParams();
    }
}

