/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.client;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.Client;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.Shard;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.exception.LogException;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.client.ClientConnectionStatus;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.response.ListShardResponse;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClientConnectionContainer {
    private Client mClient = null;
    private ClientConnectionStatus mGlobalConnection = null;
    private Map<String, ClientConnectionStatus> mShardConnections = new ConcurrentHashMap<String, ClientConnectionStatus>();
    private Map<String, Long> mShardLastUpdateTime = new ConcurrentHashMap<String, Long>();
    private long mGlobalConnectionUpdateInterval = 30000000000L;
    private long mShardConnectionUpdateInterval = 300000000000L;
    private long mGlobalConnectionValidInterval = 60000000000L;
    private long mGlobalConnectionUpdateSendSize = 0x6400000L;

    public void Init(String endpoint, String accessId, String accessKey) {
        this.mClient = new Client(endpoint, accessId, accessKey);
    }

    public ClientConnectionStatus GetShardConnection(String project, String logstore, int shard_id) {
        String key_shard;
        String key = project + "#" + logstore;
        if (!this.mShardLastUpdateTime.containsKey(key)) {
            this.mShardLastUpdateTime.put(key, 0L);
        }
        if (!this.mShardConnections.containsKey(key_shard = project + "#" + logstore + "#" + String.valueOf(shard_id))) {
            this.UpdateShardConnection(key);
        }
        if (this.mShardConnections.containsKey(key_shard)) {
            return this.mShardConnections.get(key_shard);
        }
        return null;
    }

    public void ResetGlobalConnection() {
        this.mGlobalConnection = null;
    }

    public ClientConnectionStatus GetGlobalConnection() {
        return this.mGlobalConnection;
    }

    public void UpdateConnections() {
        this.UpdateGlobalConnection();
        this.UpdateShardConnections();
    }

    public void UpdateGlobalConnection() {
        String ip_address;
        long cur_time = System.nanoTime();
        boolean to_update = false;
        if (this.mGlobalConnection == null || !this.mGlobalConnection.IsValidConnection()) {
            to_update = true;
        } else if (cur_time - this.mGlobalConnection.GetLastUsedTime() < this.mGlobalConnectionValidInterval && (cur_time - this.mGlobalConnection.GetCreateTime() > this.mGlobalConnectionUpdateInterval || this.mGlobalConnection.GetSendDataSize() > this.mGlobalConnectionUpdateSendSize || this.mGlobalConnection.GetPullDataSize() > this.mGlobalConnectionUpdateSendSize)) {
            to_update = true;
        }
        if (to_update && (ip_address = this.mClient.GetServerIpAddress("")) != null && !ip_address.isEmpty()) {
            this.mGlobalConnection = new ClientConnectionStatus(ip_address);
        }
    }

    public void UpdateShardConnections() {
        for (Map.Entry<String, Long> entry : this.mShardLastUpdateTime.entrySet()) {
            String key = entry.getKey();
            this.UpdateShardConnection(key);
        }
    }

    private void UpdateShardConnection(String project_logstore) {
        if (!this.mShardLastUpdateTime.containsKey(project_logstore)) {
            return;
        }
        Long last_update_time = this.mShardLastUpdateTime.get(project_logstore);
        long cur_time = System.nanoTime();
        if (cur_time - last_update_time < this.mShardConnectionUpdateInterval) {
            return;
        }
        String[] items = project_logstore.split("#");
        if (items.length == 2) {
            try {
                ListShardResponse res = this.mClient.ListShard(items[0], items[1]);
                ArrayList<Shard> all_shards = res.GetShards();
                for (Shard shard : all_shards) {
                    String server_ip = shard.getServerIp();
                    if (server_ip == null || server_ip.isEmpty()) continue;
                    int shard_id = shard.GetShardId();
                    String key = project_logstore + "#" + String.valueOf(shard_id);
                    this.mShardConnections.put(key, new ClientConnectionStatus(server_ip));
                }
            }
            catch (LogException logException) {
                // empty catch block
            }
        }
        this.mShardLastUpdateTime.put(project_logstore, cur_time);
    }
}

