/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.util;

import com.taobao.hsf.com.caucho.hessian.io.HessianInput;
import com.taobao.hsf.com.caucho.hessian.io.HessianOutput;
import com.taobao.hsf.com.caucho.hessian.io.SerializerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class HessianUtil {
    private static SerializerFactory serializerFactory = SerializerFactory.createDefault();

    public static byte[] toBytes(Object object) throws IOException {
        if (null == object) {
            throw new IOException("object is null");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        HessianOutput hessianOutput = new HessianOutput(byteArrayOutputStream);
        hessianOutput.setSerializerFactory(serializerFactory);
        try {
            hessianOutput.writeObject(object);
        }
        catch (Throwable e) {
            throw new IOException("write object error", e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static Object toObject(byte[] bytes) throws IOException {
        if (null == bytes || bytes.length == 0) {
            throw new IOException("bytes is null or empty");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        HessianInput hessianInput = new HessianInput(byteArrayInputStream);
        Object object = null;
        try {
            object = hessianInput.readObject();
        }
        catch (Throwable e) {
            throw new IOException("read object error", e);
        }
        return object;
    }

    static {
        serializerFactory.setAllowNonSerializable(true);
    }
}

