/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.util;

import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.math.NumberUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AppGroupUtil {
    private static final String GROUP_FORMATTER = "[0-9]{1,8}-[0-9]{1,8}";

    public static boolean validateGroup(String groupId) {
        if (StringUtils.isBlank(groupId)) {
            return false;
        }
        Pattern pattern = Pattern.compile(GROUP_FORMATTER);
        Matcher matcher = pattern.matcher(groupId);
        return matcher.matches();
    }

    public static long getAppGroupId(String appGroupId) {
        long groupId = 0L;
        try {
            String[] appGroupInfo = appGroupId.split("-");
            groupId = NumberUtils.toLong(appGroupInfo[1]);
        }
        catch (Throwable e) {
            throw new RuntimeException("getAppGroupId error, appGroupId=" + appGroupId);
        }
        return groupId;
    }
}

