/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.sdk.common;

import com.alibaba.schedulerx.common.domain.enums.ResponseCodeEnum;
import com.alibaba.schedulerx.common.exception.RequestCheckException;
import com.alibaba.schedulerx.common.sdk.common.NotNull;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;

public class ParamValidate {
    public static <T> void doValidator(T t) {
        try {
            Class<?> clazz = t.getClass();
            ArrayList<Field> allFields = new ArrayList<Field>();
            while (!clazz.getName().equals("java.lang.Object")) {
                Field[] fields = clazz.getDeclaredFields();
                if (fields != null && fields.length > 0) {
                    allFields.addAll(Arrays.asList(clazz.getDeclaredFields()));
                }
                clazz = clazz.getSuperclass();
            }
            for (Field field : allFields) {
                Object value;
                NotNull notNull;
                if (field == null || null == (notNull = field.getAnnotation(NotNull.class)) || (value = ParamValidate.getValue(t, field.getName())) != null) continue;
                throw new RequestCheckException(ResponseCodeEnum.PARAM_CHECK_ERROR.getCode(), notNull.message());
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static <T> Object getValue(T t, String fieldName) {
        Object value = null;
        try {
            PropertyDescriptor[] props;
            BeanInfo beanInfo = Introspector.getBeanInfo(t.getClass());
            for (PropertyDescriptor property : props = beanInfo.getPropertyDescriptors()) {
                if (!fieldName.equals(property.getName())) continue;
                Method method = property.getReadMethod();
                value = method.invoke(t, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }
}

