/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.collect.Lists;
import com.sun.istack.NotNull;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.TimeZone;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.ISODateTimeFormat;

public class DateUtil {
    public static final String DEFAULT_TIME_ZONE_ID = "GMT";
    public static final String LOCAL_TIME_ZONE_ID = "LOCAL";
    private static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    public static final String DEFAULT_MS_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final Format DEFAULT_MS_DATE_FORMATTER;
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final Format DEFAULT_DATE_FORMATTER;
    public static final String DEFAULT_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final Format DEFAULT_TIME_FORMATTER;
    public static final String DEFAULT_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final Format DEFAULT_TIMESTAMP_FORMATTER;
    private static final DateTimeFormatter ISO_DATE_TIME_FORMATTER;
    private static String[] defaultPattern;

    private DateUtil() {
    }

    @NotNull
    public static PDataType.PDataCodec getCodecFor(PDataType type) {
        PDataType.PDataCodec codec = type.getCodec();
        if (codec != null) {
            return codec;
        }
        if (type == PTimestamp.INSTANCE) {
            return PDate.INSTANCE.getCodec();
        }
        if (type == PUnsignedTimestamp.INSTANCE) {
            return PUnsignedDate.INSTANCE.getCodec();
        }
        throw new RuntimeException(TypeMismatchException.newException((PDataType)PTimestamp.INSTANCE, type));
    }

    public static TimeZone getTimeZone(String timeZoneId) {
        TimeZone parserTimeZone = timeZoneId == null || timeZoneId.equals(DEFAULT_TIME_ZONE_ID) ? DEFAULT_TIME_ZONE : (LOCAL_TIME_ZONE_ID.equalsIgnoreCase(timeZoneId) ? TimeZone.getDefault() : TimeZone.getTimeZone(timeZoneId));
        return parserTimeZone;
    }

    private static String getDefaultFormat(PDataType type) {
        String format;
        int ordinal = type.ordinal();
        if ((ordinal >= 0 || ordinal < defaultPattern.length) && (format = defaultPattern[ordinal]) != null) {
            return format;
        }
        throw new IllegalArgumentException("Expected a date/time type, but got " + type);
    }

    public static DateTimeParser getDateTimeParser(String pattern, PDataType pDataType, String timeZoneId) {
        TimeZone timeZone = DateUtil.getTimeZone(timeZoneId);
        String defaultPattern = DateUtil.getDefaultFormat(pDataType);
        if (pattern == null || pattern.length() == 0) {
            pattern = defaultPattern;
        }
        if (defaultPattern.equals(pattern)) {
            return ISODateFormatParserFactory.getParser(timeZone);
        }
        return new SimpleDateFormatParser(pattern, timeZone);
    }

    public static DateTimeParser getDateTimeParser(String pattern, PDataType pDataType) {
        return DateUtil.getDateTimeParser(pattern, pDataType, null);
    }

    public static Format getDateFormatter(String pattern) {
        return DateUtil.getDateFormatter(pattern, DEFAULT_TIME_ZONE_ID);
    }

    public static Format getDateFormatter(String pattern, String timeZoneID) {
        return "yyyy-MM-dd HH:mm:ss.SSS".equals(pattern) && DEFAULT_TIME_ZONE_ID.equals(timeZoneID) ? DEFAULT_DATE_FORMATTER : FastDateFormat.getInstance((String)pattern, (TimeZone)DateUtil.getTimeZone(timeZoneID));
    }

    public static Format getTimeFormatter(String pattern, String timeZoneID) {
        return "yyyy-MM-dd HH:mm:ss.SSS".equals(pattern) && DEFAULT_TIME_ZONE_ID.equals(timeZoneID) ? DEFAULT_TIME_FORMATTER : FastDateFormat.getInstance((String)pattern, (TimeZone)DateUtil.getTimeZone(timeZoneID));
    }

    public static Format getTimestampFormatter(String pattern, String timeZoneID) {
        return "yyyy-MM-dd HH:mm:ss.SSS".equals(pattern) && DEFAULT_TIME_ZONE_ID.equals(timeZoneID) ? DEFAULT_TIMESTAMP_FORMATTER : FastDateFormat.getInstance((String)pattern, (TimeZone)DateUtil.getTimeZone(timeZoneID));
    }

    private static long parseDateTime(String dateTimeValue) {
        return ISODateFormatParser.getInstance().parseDateTime(dateTimeValue);
    }

    public static Date parseDate(String dateValue) {
        return new Date(DateUtil.parseDateTime(dateValue));
    }

    public static Time parseTime(String timeValue) {
        return new Time(DateUtil.parseDateTime(timeValue));
    }

    public static Timestamp parseTimestamp(String timestampValue) {
        Timestamp timestamp = new Timestamp(DateUtil.parseDateTime(timestampValue));
        int period = timestampValue.indexOf(46);
        if (period > 0) {
            String nanosStr = timestampValue.substring(period + 1);
            if (nanosStr.length() > 9) {
                throw new IllegalDataException("nanos > 999999999 or < 0");
            }
            if (nanosStr.length() > 3) {
                int nanos = Integer.parseInt(nanosStr);
                for (int i = 0; i < 9 - nanosStr.length(); ++i) {
                    nanos *= 10;
                }
                timestamp.setNanos(nanos);
            }
        }
        return timestamp;
    }

    public static Timestamp getTimestamp(long millis, int nanos) {
        if (nanos > 999999999 || nanos < 0) {
            throw new IllegalArgumentException("nanos > 999999999 or < 0");
        }
        Timestamp ts = new Timestamp(millis);
        if (ts.getNanos() + nanos > 999999999) {
            int millisToNanosConvertor = BigDecimal.valueOf(QueryConstants.MILLIS_TO_NANOS_CONVERTOR).intValue();
            int overFlowMs = (ts.getNanos() + nanos) / millisToNanosConvertor;
            int overFlowNanos = ts.getNanos() + nanos - overFlowMs * millisToNanosConvertor;
            ts = new Timestamp(millis + (long)overFlowMs);
            ts.setNanos(ts.getNanos() + overFlowNanos);
        } else {
            ts.setNanos(ts.getNanos() + nanos);
        }
        return ts;
    }

    public static Timestamp getTimestamp(BigDecimal bd) {
        return DateUtil.getTimestamp(bd.longValue(), bd.remainder(BigDecimal.ONE).multiply(BigDecimal.valueOf(QueryConstants.MILLIS_TO_NANOS_CONVERTOR)).intValue());
    }

    static {
        DEFAULT_DATE_FORMATTER = DEFAULT_MS_DATE_FORMATTER = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss.SSS", (TimeZone)TimeZone.getTimeZone(DEFAULT_TIME_ZONE_ID));
        DEFAULT_TIME_FORMATTER = DEFAULT_MS_DATE_FORMATTER;
        DEFAULT_TIMESTAMP_FORMATTER = DEFAULT_MS_DATE_FORMATTER;
        ISO_DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().append(ISODateTimeFormat.dateParser()).appendOptional(new DateTimeFormatterBuilder().appendLiteral(' ').toParser()).appendOptional(new DateTimeFormatterBuilder().append(ISODateTimeFormat.timeParser()).toParser()).toFormatter().withChronology((Chronology)ISOChronology.getInstanceUTC());
        int maxOrdinal = Integer.MIN_VALUE;
        ArrayList timeDataTypes = Lists.newArrayListWithExpectedSize((int)6);
        for (PDataType type : PDataType.values()) {
            if (!java.util.Date.class.isAssignableFrom(type.getJavaClass())) continue;
            timeDataTypes.add(type);
            if (type.ordinal() <= maxOrdinal) continue;
            maxOrdinal = type.ordinal();
        }
        defaultPattern = new String[maxOrdinal + 1];
        for (PDataType type : timeDataTypes) {
            switch (type.getResultSetSqlType()) {
                case 93: {
                    DateUtil.defaultPattern[type.ordinal()] = "yyyy-MM-dd HH:mm:ss.SSS";
                    break;
                }
                case 92: {
                    DateUtil.defaultPattern[type.ordinal()] = "yyyy-MM-dd HH:mm:ss.SSS";
                    break;
                }
                case 91: {
                    DateUtil.defaultPattern[type.ordinal()] = "yyyy-MM-dd HH:mm:ss.SSS";
                }
            }
        }
    }

    private static class ISODateFormatParser
    implements DateTimeParser {
        private static final ISODateFormatParser INSTANCE = new ISODateFormatParser();
        private final DateTimeFormatter formatter = DateUtil.access$100().withZone(DateTimeZone.UTC);

        public static ISODateFormatParser getInstance() {
            return INSTANCE;
        }

        private ISODateFormatParser() {
        }

        @Override
        public long parseDateTime(String dateTimeString) throws IllegalDataException {
            try {
                return this.formatter.parseDateTime(dateTimeString).getMillis();
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalDataException(ex);
            }
        }

        @Override
        public TimeZone getTimeZone() {
            return this.formatter.getZone().toTimeZone();
        }
    }

    private static class ISODateFormatParserFactory {
        private ISODateFormatParserFactory() {
        }

        public static DateTimeParser getParser(final TimeZone timeZone) {
            if (timeZone.equals(DEFAULT_TIME_ZONE)) {
                return ISODateFormatParser.getInstance();
            }
            return new DateTimeParser(){
                private final DateTimeFormatter formatter;
                {
                    this.formatter = ISO_DATE_TIME_FORMATTER.withZone(DateTimeZone.forTimeZone((TimeZone)timeZone));
                }

                @Override
                public long parseDateTime(String dateTimeString) throws IllegalDataException {
                    try {
                        return this.formatter.parseDateTime(dateTimeString).getMillis();
                    }
                    catch (IllegalArgumentException ex) {
                        throw new IllegalDataException(ex);
                    }
                }

                @Override
                public TimeZone getTimeZone() {
                    return timeZone;
                }
            };
        }
    }

    private static class SimpleDateFormatParser
    implements DateTimeParser {
        private String datePattern;
        private SimpleDateFormat parser;

        public SimpleDateFormatParser(String pattern, TimeZone timeZone) {
            this.datePattern = pattern;
            this.parser = new SimpleDateFormat(pattern){

                @Override
                public java.util.Date parseObject(String source) throws ParseException {
                    java.util.Date date = super.parse(source);
                    return new Date(date.getTime());
                }
            };
            this.parser.setTimeZone(timeZone);
        }

        @Override
        public long parseDateTime(String dateTimeString) throws IllegalDataException {
            try {
                java.util.Date date = this.parser.parse(dateTimeString);
                return date.getTime();
            }
            catch (ParseException e) {
                throw new IllegalDataException("Unable to parse date/time '" + dateTimeString + "' using format string of '" + this.datePattern + "'.");
            }
        }

        @Override
        public TimeZone getTimeZone() {
            return this.parser.getTimeZone();
        }
    }

    public static interface DateTimeParser {
        public long parseDateTime(String var1) throws IllegalDataException;

        public TimeZone getTimeZone();
    }
}

