/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.phoenix.jdbc.DelegateResultSet;
import org.apache.phoenix.jdbc.PhoenixMetricsLog;
import org.apache.phoenix.util.PhoenixRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingPhoenixResultSet
extends DelegateResultSet {
    private static final Logger logger = LoggerFactory.getLogger(LoggingPhoenixResultSet.class);
    private PhoenixMetricsLog phoenixMetricsLog;

    public LoggingPhoenixResultSet(ResultSet rs, PhoenixMetricsLog phoenixMetricsLog) {
        super(rs);
        this.phoenixMetricsLog = phoenixMetricsLog;
    }

    @Override
    public void close() throws SQLException {
        this.phoenixMetricsLog.logOverAllReadRequestMetrics(logger, PhoenixRuntime.getOverAllReadRequestMetricInfo(this.rs));
        this.phoenixMetricsLog.logRequestReadMetrics(logger, PhoenixRuntime.getRequestReadMetricInfo(this.rs));
        PhoenixRuntime.resetMetrics(this.rs);
        super.close();
    }
}

