/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.iterate.ParallelScanGrouper;

public class MapReduceParallelScanGrouper
implements ParallelScanGrouper {
    private static final MapReduceParallelScanGrouper INSTANCE = new MapReduceParallelScanGrouper();

    public static MapReduceParallelScanGrouper getInstance() {
        return INSTANCE;
    }

    private MapReduceParallelScanGrouper() {
    }

    @Override
    public boolean shouldStartNewScan(QueryPlan plan, List<Scan> scans, byte[] startKey, boolean crossedRegionBoundary) {
        return !plan.isRowKeyOrdered() || crossedRegionBoundary;
    }

    @Override
    public List<HRegionLocation> getRegionBoundaries(StatementContext context, byte[] tableName) throws SQLException {
        Configuration conf = context.getConnection().getQueryServices().getConfiguration();
        String snapshotName = this.getSnapshotName(conf);
        if (snapshotName != null) {
            try {
                Path rootDir = new Path(conf.get("hbase.rootdir"));
                FileSystem fs = rootDir.getFileSystem(conf);
                Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir((String)snapshotName, (Path)rootDir);
                HBaseProtos.SnapshotDescription snapshotDescription = SnapshotDescriptionUtils.readSnapshotInfo((FileSystem)fs, (Path)snapshotDir);
                SnapshotManifest manifest = SnapshotManifest.open((Configuration)conf, (FileSystem)fs, (Path)snapshotDir, (HBaseProtos.SnapshotDescription)snapshotDescription);
                return this.getRegionLocationsFromManifest(manifest);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return context.getConnection().getQueryServices().getAllTableRegions(tableName);
    }

    private List<HRegionLocation> getRegionLocationsFromManifest(SnapshotManifest manifest) {
        List regionManifests = manifest.getRegionManifests();
        Preconditions.checkNotNull((Object)regionManifests);
        ArrayList regionLocations = Lists.newArrayListWithCapacity((int)regionManifests.size());
        for (SnapshotProtos.SnapshotRegionManifest regionManifest : regionManifests) {
            regionLocations.add(new HRegionLocation(HRegionInfo.convert((HBaseProtos.RegionInfo)regionManifest.getRegionInfo()), null));
        }
        return regionLocations;
    }

    private String getSnapshotName(Configuration conf) {
        return conf.get("phoenix.mapreduce.snapshot.name");
    }
}

