/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.parallel;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.phoenix.hbase.index.parallel.ThreadPoolBuilder;

public class ThreadPoolManager {
    private static final Log LOG = LogFactory.getLog(ThreadPoolManager.class);

    public static synchronized ThreadPoolExecutor getExecutor(ThreadPoolBuilder builder, RegionCoprocessorEnvironment env) {
        return ThreadPoolManager.getExecutor(builder, env.getSharedData());
    }

    static synchronized ThreadPoolExecutor getExecutor(ThreadPoolBuilder builder, Map<String, Object> poolCache) {
        ThreadPoolExecutor pool = (ThreadPoolExecutor)poolCache.get(builder.getName());
        if (pool == null || pool.isTerminating() || pool.isShutdown()) {
            pool = ThreadPoolManager.getDefaultExecutor(builder);
            LOG.info((Object)("Creating new pool for " + builder.getName()));
            poolCache.put(builder.getName(), pool);
        }
        ((ShutdownOnUnusedThreadPoolExecutor)pool).addReference();
        return pool;
    }

    private static ShutdownOnUnusedThreadPoolExecutor getDefaultExecutor(ThreadPoolBuilder builder) {
        int maxThreads = builder.getMaxThreads();
        long keepAliveTime = builder.getKeepAliveTime();
        ShutdownOnUnusedThreadPoolExecutor pool = new ShutdownOnUnusedThreadPoolExecutor(maxThreads, maxThreads, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Threads.newDaemonThreadFactory((String)(builder.getName() + "-")), builder.getName());
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }

    private static class ShutdownOnUnusedThreadPoolExecutor
    extends ThreadPoolExecutor {
        private AtomicInteger references = new AtomicInteger();
        private String poolName;

        public ShutdownOnUnusedThreadPoolExecutor(int coreThreads, int maxThreads, long keepAliveTime, TimeUnit timeUnit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, String poolName) {
            super(coreThreads, maxThreads, keepAliveTime, timeUnit, workQueue, threadFactory);
            this.poolName = poolName;
        }

        public void addReference() {
            this.references.incrementAndGet();
        }

        @Override
        protected void finalize() {
            LOG.info((Object)("Shutting down pool '" + this.poolName + "' because no more references"));
            super.finalize();
        }

        @Override
        public void shutdown() {
            if (this.references.decrementAndGet() <= 0) {
                LOG.debug((Object)("Shutting down pool " + this.poolName));
                super.shutdown();
            }
        }

        @Override
        public List<Runnable> shutdownNow() {
            if (this.references.decrementAndGet() <= 0) {
                LOG.debug((Object)("Shutting down pool " + this.poolName + " NOW!"));
                return super.shutdownNow();
            }
            return Collections.emptyList();
        }
    }
}

