/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.compile.CreateTableCompiler;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnValueDecoder;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.SchemaUtil;

public class SingleCellColumnExpression
extends KeyValueColumnExpression {
    private int decodedColumnQualifier;
    private String arrayColDisplayName;
    private KeyValueColumnExpression keyValueColumnExpression;
    private PTable.QualifierEncodingScheme encodingScheme;

    public SingleCellColumnExpression() {
    }

    public SingleCellColumnExpression(PDatum column, byte[] cf, byte[] cq, PTable.QualifierEncodingScheme encodingScheme) {
        super(column, cf, QueryConstants.SINGLE_KEYVALUE_COLUMN_QUALIFIER_BYTES);
        Preconditions.checkNotNull((Object)encodingScheme);
        Preconditions.checkArgument((encodingScheme != PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS ? 1 : 0) != 0);
        this.decodedColumnQualifier = encodingScheme.decode(cq);
        this.encodingScheme = encodingScheme;
        this.setKeyValueExpression();
    }

    public SingleCellColumnExpression(PColumn column, String displayName, PTable.QualifierEncodingScheme encodingScheme) {
        super(column, column.getFamilyName().getBytes(), QueryConstants.SINGLE_KEYVALUE_COLUMN_QUALIFIER_BYTES);
        Preconditions.checkNotNull((Object)encodingScheme);
        Preconditions.checkArgument((encodingScheme != PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS ? 1 : 0) != 0);
        this.arrayColDisplayName = displayName;
        this.decodedColumnQualifier = encodingScheme.decode(column.getColumnQualifierBytes());
        this.encodingScheme = encodingScheme;
        this.setKeyValueExpression();
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (!super.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        int index = this.decodedColumnQualifier - 11 + 1;
        byte serializedImmutableStorageScheme = ptr.get()[ptr.getOffset() + ptr.getLength() - 1];
        PTable.ImmutableStorageScheme immutableStorageScheme = PTable.ImmutableStorageScheme.fromSerializedValue(serializedImmutableStorageScheme);
        ColumnValueDecoder encoderDecoder = immutableStorageScheme.getDecoder();
        return encoderDecoder.decode(ptr, index);
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.decodedColumnQualifier = WritableUtils.readVInt((DataInput)input);
        this.encodingScheme = PTable.QualifierEncodingScheme.values()[WritableUtils.readVInt((DataInput)input)];
        this.setKeyValueExpression();
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        WritableUtils.writeVInt((DataOutput)output, (int)this.decodedColumnQualifier);
        WritableUtils.writeVInt((DataOutput)output, (int)this.encodingScheme.ordinal());
    }

    public KeyValueColumnExpression getKeyValueExpression() {
        return this.keyValueColumnExpression;
    }

    private void setKeyValueExpression() {
        final boolean isNullable = this.isNullable();
        final SortOrder sortOrder = this.getSortOrder();
        final Integer scale = this.getScale();
        final Integer maxLength = this.getMaxLength();
        final PDataType datatype = this.getDataType();
        this.keyValueColumnExpression = new KeyValueColumnExpression(new PDatum(){

            @Override
            public boolean isNullable() {
                return isNullable;
            }

            @Override
            public SortOrder getSortOrder() {
                return sortOrder;
            }

            @Override
            public Integer getScale() {
                return scale;
            }

            @Override
            public Integer getMaxLength() {
                return maxLength;
            }

            @Override
            public PDataType getDataType() {
                return datatype;
            }
        }, this.getColumnFamily(), this.getPositionInArray());
    }

    @Override
    public String toString() {
        if (this.arrayColDisplayName == null) {
            this.arrayColDisplayName = SchemaUtil.getColumnDisplayName(this.getColumnFamily(), this.getColumnQualifier());
        }
        return this.arrayColDisplayName;
    }

    public byte[] getPositionInArray() {
        return this.encodingScheme.encode(this.decodedColumnQualifier);
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        if (visitor instanceof CreateTableCompiler.ViewWhereExpressionVisitor) {
            return visitor.visit(this);
        }
        return super.accept(visitor);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj.getClass() != SingleCellColumnExpression.class) {
            return false;
        }
        return this.keyValueColumnExpression.equals(((SingleCellColumnExpression)obj).getKeyValueExpression());
    }

    @Override
    public int hashCode() {
        return this.keyValueColumnExpression.hashCode();
    }
}

