/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc.controller;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ipc.DelegatingPayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.PhoenixRpcSchedulerFactory;

class IndexRpcController
extends DelegatingPayloadCarryingRpcController {
    private final int priority;
    private final String tracingTableName;

    public IndexRpcController(PayloadCarryingRpcController delegate, Configuration conf) {
        super(delegate);
        this.priority = PhoenixRpcSchedulerFactory.getIndexPriority(conf);
        this.tracingTableName = conf.get("phoenix.trace.statsTableName", "SYSTEM.TRACING_STATS");
    }

    public void setPriority(TableName tn) {
        if (!tn.isSystemTable() && !tn.getNameAsString().equals(this.tracingTableName)) {
            this.setPriority(this.priority);
        } else {
            super.setPriority(tn);
        }
    }
}

