/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.crypto;

import java.security.Provider;
import java.security.Security;

public class CryptoRuntime {
    static final String BOUNCY_CASTLE_PROVIDER = "BC";
    private static final String BC_PROVIDER_FQCN = "org.bouncycastle.jce.provider.BouncyCastleProvider";

    public static void enableBouncyCastle() {
        if (!CryptoRuntime.isBouncyCastleAvailable()) {
            CryptoRuntime.addBouncyCastleProvider();
            if (!CryptoRuntime.isBouncyCastleAvailable()) {
                throw new UnsupportedOperationException("The Bouncy castle library is not found.");
            }
        }
    }

    private static synchronized boolean isBouncyCastleAvailable() {
        return Security.getProvider(BOUNCY_CASTLE_PROVIDER) != null;
    }

    private static synchronized void addBouncyCastleProvider() {
        if (CryptoRuntime.isBouncyCastleAvailable()) {
            return;
        }
        try {
            Class<?> c = Class.forName(BC_PROVIDER_FQCN);
            Provider provider = (Provider)c.newInstance();
            Security.addProvider(provider);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

