/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.tools.github;

import com.alibaba.rocketmq.common.MixAll;
import com.alibaba.rocketmq.remoting.RPCHook;
import com.alibaba.rocketmq.tools.command.SubCommand;
import java.io.File;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;

public class SyncDocsToGithubSubCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "syncDocs";
    }

    @Override
    public String commandDesc() {
        return "Synchronize wiki and issue to github.com";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("u", "userName", true, "User name of github.com");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("p", "password", true, "Password of github.com");
        opt.setRequired(true);
        options.addOption(opt);
        return options;
    }

    private static boolean syncIssue(GHRepository rep, int issueId, String body) {
        try {
            GHIssue issue = rep.getIssue(issueId);
            issue.setBody(body);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean syncWiki(GHRepository rep, String wikiName, String body) {
        return false;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) {
        String userName = commandLine.getOptionValue('u').trim();
        String password = commandLine.getOptionValue('p').trim();
        try {
            GitHub github = GitHub.connectUsingPassword((String)userName, (String)password);
            GHOrganization alibaba = github.getOrganization("Alibaba");
            GHRepository rep = alibaba.getRepository("RocketMQ");
            File dir = new File(System.getenv("ROCKETMQ_HOME") + "/" + "issues");
            Object[] files = dir.listFiles();
            if (files != null) {
                Arrays.sort(files);
                for (Object file : files) {
                    int issueId = Integer.parseInt(((File)file).getName());
                    String body = MixAll.file2String((File)file);
                    boolean result = SyncDocsToGithubSubCommand.syncIssue(rep, issueId, body);
                    System.out.printf("Sync issue <%d> to github.com %s\n", issueId, result ? "OK" : "Failed");
                }
            }
            if ((files = (dir = new File(System.getenv("ROCKETMQ_HOME") + "/" + "wiki")).listFiles()) != null) {
                Arrays.sort(files);
                for (Object file : files) {
                    String fileName = ((File)file).getName();
                    int index = fileName.lastIndexOf(46);
                    if (index > 0) {
                        fileName = fileName.substring(0, index);
                    }
                    String body = MixAll.file2String((File)file);
                    boolean result = SyncDocsToGithubSubCommand.syncWiki(rep, fileName, body);
                    System.out.printf("Sync wiki <%s> to github.com %s\n", fileName, result ? "OK" : "Failed");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

