/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.tools.command.namesrv;

import com.alibaba.rocketmq.remoting.RPCHook;
import com.alibaba.rocketmq.tools.admin.DefaultMQAdminExt;
import com.alibaba.rocketmq.tools.command.SubCommand;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class UpdateProjectGroupCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "updateProjectGroup";
    }

    @Override
    public String commandDesc() {
        return "Create or update project group by server ip.";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("i", "ip", true, "set the server ip");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("p", "project", true, "set the project group");
        opt.setRequired(true);
        options.addOption(opt);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            String namespace = "PROJECT_CONFIG";
            String ip = commandLine.getOptionValue('i').trim();
            String project = commandLine.getOptionValue('p').trim();
            defaultMQAdminExt.start();
            defaultMQAdminExt.createAndUpdateKvConfig(namespace, ip, project);
            System.out.printf("create or update kv config to namespace success.\n", new Object[0]);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }
}

