/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.tools.command.consumer;

import com.alibaba.rocketmq.common.MQVersion;
import com.alibaba.rocketmq.common.MixAll;
import com.alibaba.rocketmq.common.protocol.body.Connection;
import com.alibaba.rocketmq.common.protocol.body.ConsumerConnection;
import com.alibaba.rocketmq.common.protocol.body.ConsumerRunningInfo;
import com.alibaba.rocketmq.remoting.RPCHook;
import com.alibaba.rocketmq.tools.admin.DefaultMQAdminExt;
import com.alibaba.rocketmq.tools.command.MQAdminStartup;
import com.alibaba.rocketmq.tools.command.SubCommand;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ConsumerStatusSubCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "consumerStatus";
    }

    @Override
    public String commandDesc() {
        return "Query consumer's internal data structure";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("g", "consumerGroup", true, "consumer group name");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("i", "clientId", true, "The consumer's client id");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("s", "jstack", false, "Run jstack command in the consumer progress");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            defaultMQAdminExt.start();
            String group = commandLine.getOptionValue('g').trim();
            ConsumerConnection cc = defaultMQAdminExt.examineConsumerConnectionInfo(group);
            boolean jstack = commandLine.hasOption('s');
            if (!commandLine.hasOption('i')) {
                int i = 1;
                long now = System.currentTimeMillis();
                TreeMap<String, ConsumerRunningInfo> criTable = new TreeMap<String, ConsumerRunningInfo>();
                for (Connection conn : cc.getConnectionSet()) {
                    try {
                        ConsumerRunningInfo consumerRunningInfo = defaultMQAdminExt.getConsumerRunningInfo(group, conn.getClientId(), jstack);
                        if (consumerRunningInfo == null) continue;
                        criTable.put(conn.getClientId(), consumerRunningInfo);
                        String filePath = now + "/" + conn.getClientId();
                        MixAll.string2FileNotSafe((String)consumerRunningInfo.formatString(), (String)filePath);
                        System.out.printf("%03d  %-40s %-20s %s\n", i++, conn.getClientId(), MQVersion.getVersionDesc((int)conn.getVersion()), filePath);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (!criTable.isEmpty()) {
                    boolean rebalanceOK;
                    boolean subSame = ConsumerRunningInfo.analyzeSubscription(criTable);
                    boolean bl = rebalanceOK = subSame && ConsumerRunningInfo.analyzeRebalance(criTable);
                    if (subSame) {
                        System.out.println("\n\nSame subscription in the same group of consumer");
                        System.out.printf("\n\nRebalance %s\n", rebalanceOK ? "OK" : "Failed");
                        for (Map.Entry next : criTable.entrySet()) {
                            String result = ConsumerRunningInfo.analyzeProcessQueue((String)((String)next.getKey()), (ConsumerRunningInfo)((ConsumerRunningInfo)next.getValue()));
                            if (result.length() <= 0) continue;
                            System.out.println(result);
                        }
                    } else {
                        System.out.println("\n\nWARN: Different subscription in the same group of consumer!!!");
                    }
                }
            } else {
                String clientId = commandLine.getOptionValue('i').trim();
                ConsumerRunningInfo consumerRunningInfo = defaultMQAdminExt.getConsumerRunningInfo(group, clientId, jstack);
                if (consumerRunningInfo != null) {
                    System.out.println(consumerRunningInfo.formatString());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }

    public static void main(String[] args) {
        System.setProperty("rocketmq.namesrv.addr", "127.0.0.1:9876");
        MQAdminStartup.main(new String[]{new ConsumerStatusSubCommand().commandName(), "-g", "benchmark_consumer"});
    }
}

